/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.IScriptEditor;
import editor.SimpleDocumentFilter;
import editor.search.BaseLocalSearchDialog;
import editor.search.MessageDisplay;
import editor.search.SearchLocation;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class SearchLocalDialog2
extends BaseLocalSearchDialog {
    private IScriptEditor _scriptSource;
    private Map<IScriptEditor, Integer> _mapReplaceAllOffset;

    public SearchLocalDialog2(IScriptEditor scriptSource, boolean bReplace) {
        this(scriptSource, scriptSource.getSelectedText(), bReplace);
    }

    public SearchLocalDialog2(IScriptEditor scriptSource, String searchText, boolean bReplace) {
        super(true, bReplace, searchText, scriptSource.getUndoManager());
        this._scriptSource = scriptSource;
    }

    @Override
    protected SearchLocation performFind(String strText, boolean backwards) {
        IScriptEditor scriptSource = this.getScriptSource();
        int iCaretPos = this.isReplaceMode() ? scriptSource.getEditor().getSelectionStart() : scriptSource.getEditor().getCaretPosition();
        this.setAllModeOffset(scriptSource, iCaretPos);
        SearchLocation location = this.findInSection(scriptSource, strText, iCaretPos, backwards);
        return location;
    }

    SearchLocation findInSection(IScriptEditor section, String strText, int caretPosition, boolean backwards) {
        return this.findInSection(section, strText, caretPosition, false, null, backwards);
    }

    SearchLocation findInSection(IScriptEditor section, String strText, int iOffset, boolean bForcePrompt, Point messageLocation, boolean backwards) {
        SearchLocation location;
        String strSource;
        JTextComponent editor = section.getEditor();
        int iDocLength = editor.getDocument().getLength();
        try {
            strSource = editor.getDocument().getText(0, iDocLength);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        List found = this.findInSource(strSource, strText, iOffset, backwards);
        if (found != null && found.size() > 0 && (location = (SearchLocation)found.get(0)) != null) {
            int iAllModeOffset;
            if (this.hasAllModeRecycledFromTop() && (iAllModeOffset = this.getAllModeOffset(section)) >= 0 && location._iOffset >= iAllModeOffset) {
                return null;
            }
            editor.requestFocus();
            editor.select(location._iOffset, location._iOffset + location._iLength);
            if (this.isReplaceMode()) {
                DocumentFilter documentFilter;
                int iRet;
                String strReplace = location.getReplacementText(this.getDialogReplaceText());
                strReplace = strReplace == null ? "" : strReplace;
                int n = iRet = this.isAllMode() ? 0 : MessageDisplay.displayConfirmation("Replace this_occurrence ", -999, new String[]{"Replace", "Skip", "All", "_cancel"}, messageLocation);
                if ((iRet == 0 || iRet == 2) && (documentFilter = ((AbstractDocument)editor.getDocument()).getDocumentFilter()) instanceof SimpleDocumentFilter && !((SimpleDocumentFilter)documentFilter).acceptEdit("")) {
                    return location;
                }
                switch (iRet) {
                    case 0: {
                        this.startUndoIfNecessary();
                        if (editor.isEditable()) {
                            editor.replaceSelection(strReplace);
                            int iAllModeOffset2 = this.getAllModeOffset(section);
                            if (location._iOffset < iAllModeOffset2) {
                                this.setAllModeOffset(section, iAllModeOffset2 - strText.length() + strReplace.length());
                            }
                        }
                    }
                    case 1: {
                        this.setStartedReplacing(true);
                        return this.findInSection(section, strText, section.getEditor().getCaretPosition(), bForcePrompt, MessageDisplay.getLastMessageLocation(), backwards);
                    }
                    case 2: {
                        this.setStartedReplacing(true);
                        this.startUndoIfNecessary();
                        this.setAllMode(true);
                        if (editor.isEditable()) {
                            editor.replaceSelection(strReplace);
                            int iAllModeOffset3 = this.getAllModeOffset(section);
                            if (location._iOffset < iAllModeOffset3) {
                                this.setAllModeOffset(section, iAllModeOffset3 - strText.length() + strReplace.length());
                            }
                        }
                        return this.findInSection(section, strText, location._iOffset + strReplace.length(), bForcePrompt, MessageDisplay.getLastMessageLocation(), backwards);
                    }
                }
            }
            return location;
        }
        if (this.isReplaceMode() && this.hasAllModeOffset()) {
            if (!this.hasAllModeRecycledFromTop()) {
                this.setAllModeRecyclingFromTop(true);
                return this.findInSection(this._scriptSource, strText, 0, false, messageLocation, backwards);
            }
            return null;
        }
        if (bForcePrompt || iOffset > 0) {
            int iRet = MessageDisplay.displayConfirmation("Search from the top of the file?", 0);
            if (iRet == 0) {
                return this.findInSection(this._scriptSource, strText, backwards ? strSource.length() : 0, false, MessageDisplay.getLastMessageLocation(), backwards);
            }
            this.setDisplayNotFound(false);
        }
        return null;
    }

    private IScriptEditor getScriptSource() {
        return this._scriptSource;
    }

    private int getAllModeOffset(IScriptEditor section) {
        if (this._mapReplaceAllOffset == null) {
            return -1;
        }
        Integer offset = this._mapReplaceAllOffset.get(section);
        if (offset == null) {
            return -1;
        }
        return offset;
    }

    private void setAllModeOffset(IScriptEditor section, int iOffset) {
        if (this._mapReplaceAllOffset == null) {
            this._mapReplaceAllOffset = new HashMap<IScriptEditor, Integer>();
        }
        this._mapReplaceAllOffset.put(section, iOffset);
    }

    private boolean hasAllModeOffset() {
        return this._mapReplaceAllOffset != null && !this._mapReplaceAllOffset.isEmpty();
    }
}

