/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.search.SearchLocation;
import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class StringUtil {
    public static final int ANT_STYLE = 0;
    public static final int JAVADOC_LINK_STYLE = 0;
    private static final Map _internMap = new InternMap(20000);

    public static String[] tokenize(String s, char separator) {
        List<String> tokens = StringUtil.tokenizeToList(s, separator);
        return tokens == null ? null : tokens.toArray(new String[tokens.size()]);
    }

    public static List<String> tokenizeToList(String s, char separator) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int start = 0;
        int stop = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        while (start <= s.length()) {
            stop = s.indexOf(separator, start);
            if (stop == -1) {
                stop = s.length();
            }
            String token = s.substring(start, stop);
            tokens.add(token);
            start = stop + 1;
        }
        return tokens;
    }

    public static String[] tokenizeUnescaped(String s, char separator, char escape) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int start = 0;
        int stop = 0;
        int mid = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        while (mid <= s.length()) {
            stop = s.indexOf(separator, mid);
            if (stop == -1) {
                stop = s.length();
            } else if (StringUtil.isEscaped(s, stop, escape)) {
                mid = stop + 1;
                continue;
            }
            String token = s.substring(start, stop);
            tokens.add(token);
            mid = start = stop + 1;
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static boolean isEscaped(String s, int pos, char escape) {
        int count = 0;
        while (pos > 0 && s.charAt(pos - 1) == escape) {
            ++count;
            --pos;
        }
        return count % 2 == 1;
    }

    public static String removeStartChars(String baseString, String chars) {
        if (baseString.startsWith(chars)) {
            return baseString.substring(chars.length());
        }
        return baseString;
    }

    public static String removeEndChars(String baseString, String chars) {
        if (baseString.endsWith(chars)) {
            return baseString.substring(0, baseString.length() - chars.length());
        }
        return baseString;
    }

    public static String removeStartAndEndChars(String baseString, String startChars, String endChars) {
        return StringUtil.removeEndChars(StringUtil.removeStartChars(baseString, startChars), endChars);
    }

    public static String substitute(String pattern, VariableMap variableMap) {
        int quoteStart = -1;
        int variableStart = -1;
        StringBuffer resultBuffer = null;
        int n = pattern.length();
        for (int i = 0; i < n; ++i) {
            boolean isVariableStart;
            char ch = pattern.charAt(i);
            boolean withinQuotes = quoteStart >= 0;
            boolean withinVariable = variableStart >= 0;
            boolean isQuote = ch == '\'';
            boolean bl = isVariableStart = !withinQuotes && ch == '{' && i > 0 && pattern.charAt(i - 1) == '$';
            if ((isQuote || isVariableStart) && resultBuffer == null) {
                resultBuffer = new StringBuffer(pattern);
                resultBuffer.setLength(i);
            }
            if (isVariableStart) {
                if (withinVariable) {
                    throw new IllegalArgumentException("Invalid pattern, ${ inside ${:" + pattern);
                }
                resultBuffer.setLength(resultBuffer.length() - 1);
                variableStart = i + 1;
                continue;
            }
            if (isQuote) {
                if (withinVariable) {
                    throw new IllegalArgumentException("Invalid pattern, ' inside ${:" + pattern);
                }
                if (withinQuotes) {
                    if (quoteStart == i - 1) {
                        resultBuffer.append('\'');
                    }
                    quoteStart = -1;
                    continue;
                }
                quoteStart = i;
                continue;
            }
            if (withinVariable) {
                if (ch != '}') continue;
                String variableName = pattern.substring(variableStart, i);
                String value = variableMap.getValue(variableName);
                if (value != null) {
                    resultBuffer.append(value);
                }
                variableStart = -1;
                continue;
            }
            if (resultBuffer == null) continue;
            resultBuffer.append(ch);
        }
        if (variableStart >= 0) {
            throw new IllegalArgumentException("Invalid pattern, non terminated ${ variable:" + pattern);
        }
        if (quoteStart >= 0) {
            throw new IllegalArgumentException("Invalid pattern, missing closing quote:" + pattern);
        }
        return resultBuffer != null ? resultBuffer.toString() : pattern;
    }

    public static void escapeForJava(Writer out, String string) throws IOException {
        if (string == null || string.length() == 0) {
            out.write(string);
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            String escape = StringUtil.escapeForJava(ch);
            if (escape != null) {
                out.write(escape);
                continue;
            }
            out.write(ch);
        }
    }

    public static String escapeForJava(String string) {
        return StringUtil.process(string, new Escaper(){

            @Override
            public String eacape(char ch) {
                return StringUtil.escapeForJava(ch);
            }
        });
    }

    public static String escapeForGosuStringLiteral(String string) {
        return StringUtil.process(string, new Escaper(){

            @Override
            public String eacape(char ch) {
                return StringUtil.escapeForGosuStringLiteral(ch);
            }
        });
    }

    private static String process(String string, Escaper escaper) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer resultBuffer = null;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            String escape = escaper.eacape(ch);
            if (escape != null) {
                if (resultBuffer == null) {
                    resultBuffer = new StringBuffer(string);
                    resultBuffer.setLength(i);
                }
                resultBuffer.append(escape);
                continue;
            }
            if (resultBuffer == null) continue;
            resultBuffer.append(ch);
        }
        return resultBuffer != null ? resultBuffer.toString() : string;
    }

    public static void escapeForJava(StringBuffer sb) {
        if (sb == null || sb.length() == 0) {
            return;
        }
        for (int i = 0; i < sb.length(); ++i) {
            String escape = StringUtil.escapeForJava(sb.charAt(i));
            if (escape == null) continue;
            sb.replace(i, i + 1, escape);
            i += escape.length() - 1;
        }
    }

    public static String doubleBackslashes(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer resultBuffer = null;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            String escape;
            char ch = string.charAt(i);
            String string2 = escape = ch == '\\' ? "\\\\" : null;
            if (escape != null) {
                if (resultBuffer == null) {
                    resultBuffer = new StringBuffer(string);
                    resultBuffer.setLength(i);
                }
                resultBuffer.append(escape);
                continue;
            }
            if (resultBuffer == null) continue;
            resultBuffer.append(ch);
        }
        return resultBuffer != null ? resultBuffer.toString() : string;
    }

    public static String escapeForJava(char ch) {
        String escape = StringUtil.escapeForGosuStringLiteral(ch);
        if (escape == null && (ch <= '\u001f' || ch >= '\u007f')) {
            escape = StringUtil.getUnicodeEscape(ch);
        }
        return escape;
    }

    private static String escapeForGosuStringLiteral(char ch) {
        String escape = null;
        switch (ch) {
            case '\b': {
                escape = "\\b";
                break;
            }
            case '\t': {
                escape = "\\t";
                break;
            }
            case '\n': {
                escape = "\\n";
                break;
            }
            case '\f': {
                escape = "\\f";
                break;
            }
            case '\r': {
                escape = "\\r";
                break;
            }
            case '\"': {
                escape = "\\\"";
                break;
            }
            case '\'': {
                escape = "\\'";
                break;
            }
            case '\\': {
                escape = "\\\\";
                break;
            }
        }
        return escape;
    }

    public static String escapeForXML(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer resultBuffer = null;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            String entity = null;
            char ch = string.charAt(i);
            if (!StringUtil.isAllowedXMLCharacter(ch)) {
                entity = StringUtil.replaceNonXMLCharacter(ch);
            } else if (ch > '\u007f') {
                entity = "&#" + ch + ";";
            } else {
                switch (ch) {
                    case '<': {
                        entity = "&lt;";
                        break;
                    }
                    case '>': {
                        entity = "&gt;";
                        break;
                    }
                    case '&': {
                        entity = "&amp;";
                        break;
                    }
                    case '\"': {
                        entity = "&quot;";
                        break;
                    }
                }
            }
            if (entity != null) {
                if (resultBuffer == null) {
                    resultBuffer = new StringBuffer(string);
                    resultBuffer.setLength(i);
                }
                resultBuffer.append(entity);
                continue;
            }
            if (resultBuffer == null) continue;
            resultBuffer.append(ch);
        }
        return resultBuffer != null ? resultBuffer.toString() : string;
    }

    public static boolean isAllowedXMLCharacter(char ch) {
        return ch == '\n' || ch == '\r' || ch == '\t' || ' ' <= ch && ch <= '\ud7ff' || '\ue000' <= ch && ch <= '\ufffd';
    }

    public static String replaceNonXMLCharacter(char ch) {
        if (ch < ' ') {
            return "^" + (char)(ch + 64);
        }
        return "U+" + Integer.toHexString(ch).toUpperCase();
    }

    public static String encodeCSV(List fields) {
        return StringUtil.encodeCSV(fields.iterator());
    }

    public static String encodeCSV(Iterator i) {
        StringBuilder resultBuffer = new StringBuilder();
        boolean first = true;
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                resultBuffer.append(',');
            }
            int fieldStart = resultBuffer.length();
            boolean isQuoted = false;
            String field = i.next().toString();
            int n = field.length();
            for (int j = 0; j < n; ++j) {
                char ch = field.charAt(j);
                if (!(ch != ',' && ch != '\"' || isQuoted)) {
                    resultBuffer.insert(fieldStart, '\"');
                    isQuoted = true;
                }
                resultBuffer.append(ch);
                if (ch != '\"') continue;
                resultBuffer.append('\"');
            }
            if (!isQuoted) continue;
            resultBuffer.append('\"');
        }
        return resultBuffer.toString();
    }

    public static String[] decodeCSV(String csvFields) {
        ArrayList<String> resultList = new ArrayList<String>();
        StringBuilder fieldBuffer = new StringBuilder();
        boolean inQuotedField = false;
        int n = csvFields.length();
        for (int i = 0; i < n; ++i) {
            char ch = csvFields.charAt(i);
            if (ch == '\"') {
                if (inQuotedField) {
                    char nextCh;
                    boolean atEnd = i == n - 1;
                    char c = nextCh = atEnd ? (char)'\u0000' : csvFields.charAt(i + 1);
                    if (nextCh == '\"') {
                        fieldBuffer.append('\"');
                        ++i;
                        continue;
                    }
                    if (atEnd || nextCh == ',') {
                        inQuotedField = false;
                        continue;
                    }
                    throw new IllegalArgumentException("Misplaced double quote in CSV string: " + csvFields);
                }
                if (fieldBuffer.length() == 0) {
                    inQuotedField = true;
                    continue;
                }
                throw new IllegalArgumentException("Misplaced double quote in CSV string: " + csvFields);
            }
            if (ch == ',' && !inQuotedField) {
                resultList.add(fieldBuffer.toString());
                fieldBuffer.setLength(0);
                continue;
            }
            fieldBuffer.append(ch);
        }
        if (inQuotedField) {
            throw new IllegalArgumentException("Missing quote at end of CSV string: " + csvFields);
        }
        resultList.add(fieldBuffer.toString());
        return resultList.toArray(new String[resultList.size()]);
    }

    public static List searchIgnoreCase(String strSource, String strPattern) {
        return StringUtil.search(strSource, strPattern, true);
    }

    public static List search(String strSource, String strPattern, boolean bIgnoreCase) {
        return StringUtil.search(strSource, strPattern, bIgnoreCase, 0);
    }

    public static List search(String strSource, String strPattern, boolean bIgnoreCase, int iOffset) {
        return StringUtil.search(strSource, strPattern, bIgnoreCase, iOffset, false);
    }

    public static List search(String strSource, String strPattern, boolean bIgnoreCase, int iOffset, boolean backwards) {
        int iIndex2;
        if (bIgnoreCase) {
            strSource = strSource.toLowerCase();
            strPattern = strPattern.toLowerCase();
        }
        ArrayList<SearchLocation> list = new ArrayList<SearchLocation>();
        int iIndex = backwards ? strSource.length() : 0;
        int n = iIndex2 = backwards ? strSource.lastIndexOf(strPattern, iOffset - strPattern.length() - 1) : strSource.indexOf(strPattern, iOffset);
        if (iIndex2 < 0) {
            return list;
        }
        SearchLocation slBuffer = new SearchLocation();
        do {
            SearchLocation sl = new SearchLocation();
            sl._iOffset = iIndex2;
            StringUtil.getLocation(strSource, iIndex, iIndex2, slBuffer);
            sl._iLine = slBuffer._iLine + 1;
            sl._iColumn = slBuffer._iColumn + 1;
            sl._iLineOffset = slBuffer._iLineOffset;
            sl._iLength = strPattern.length();
            list.add(sl);
            iIndex = iIndex2;
        } while ((iIndex2 = backwards ? strSource.lastIndexOf(strPattern, --iIndex) : strSource.indexOf(strPattern, iIndex += strPattern.length())) >= 0);
        return list;
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        if (s == null || s.length() < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            char c2Upper;
            char c1Upper = Character.toUpperCase(s.charAt(i));
            if (c1Upper == (c2Upper = Character.toUpperCase(prefix.charAt(i))) || Character.toLowerCase(c1Upper) == Character.toLowerCase(c2Upper)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(String s, String suffix) {
        if (s == null || s.length() < suffix.length()) {
            return false;
        }
        for (int i = 0; i < suffix.length(); ++i) {
            char c2Upper;
            char c1Upper = Character.toUpperCase(s.charAt(s.length() - 1 - i));
            if (c1Upper == (c2Upper = Character.toUpperCase(suffix.charAt(suffix.length() - 1 - i))) || Character.toLowerCase(c1Upper) == Character.toLowerCase(c2Upper)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(String s, String substr) {
        return s.indexOf(substr) >= 0;
    }

    public static boolean containsCaseInsensitive(String s, String substr) {
        return !StringUtil.searchIgnoreCase(s, substr).isEmpty();
    }

    public static void getLocation(String strSource, int iFrom, int iTo, SearchLocation location) {
        if (strSource == null) {
            return;
        }
        if (iFrom > strSource.length() || iTo > strSource.length()) {
            throw new IllegalArgumentException("String index out of bounds.  Source: , From: " + iFrom + ", To:" + iTo);
        }
        int iLineCount = 0;
        int iLineStart = location._iLineOffset;
        for (int i = iFrom; i < iTo; ++i) {
            char c = strSource.charAt(i);
            if (c != '\n') continue;
            ++iLineCount;
            iLineStart = i + 1;
        }
        location._iLine += iLineCount;
        location._iColumn = iTo - iLineStart;
        location._iLineOffset = iLineStart;
    }

    public static String formatObjectList(List list, String delimiter) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String truncateField(String fieldVal, String delimiter, int maxLength) {
        if (fieldVal != null) {
            int firstDelimiter = -1;
            if (delimiter != null) {
                firstDelimiter = fieldVal.indexOf(delimiter);
            }
            while (fieldVal.length() > maxLength) {
                if (firstDelimiter != -1) {
                    fieldVal = fieldVal.substring(firstDelimiter + delimiter.length());
                    firstDelimiter = fieldVal.indexOf(delimiter);
                    continue;
                }
                fieldVal = fieldVal.substring(fieldVal.length() - maxLength);
            }
        }
        return fieldVal;
    }

    private static String getUnicodeEscape(char ch) {
        String prefix = "\\u";
        int length = prefix.length() + 4;
        String hex = Integer.toHexString(ch);
        StringBuilder resultBuffer = new StringBuilder(length);
        resultBuffer.append(prefix);
        int n = length - (prefix.length() + hex.length());
        for (int i = 0; i < n; ++i) {
            resultBuffer.append('0');
        }
        resultBuffer.append(hex);
        return resultBuffer.toString();
    }

    public static String encodeSpaces(String strUrl) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strUrl.length(); ++i) {
            char c = strUrl.charAt(i);
            if (c == ' ') {
                StringUtil.escapeUrlChar(sb, c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String encodeURLCharacters(String strUrl) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strUrl.length(); ++i) {
            char c = strUrl.charAt(i);
            StringUtil.escapeUrlChar(sb, c);
        }
        return sb.toString();
    }

    public static String encodeDocumentFilenameChars(String strUrl) {
        return StringUtil.encodeURLCharacters(strUrl);
    }

    private static void escapeUrlChar(StringBuffer sb, char c) {
        switch (c) {
            case ' ': 
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '+': 
            case '@': 
            case '^': 
            case '`': 
            case '{': 
            case '}': 
            case '~': {
                sb.append('%').append(Integer.toHexString(0x100 | c).substring(1).toUpperCase());
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static boolean equalsIgnoreLineSeparatorDifferences(String s1, String s2) {
        int index2;
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int index1 = 0;
        for (index2 = 0; index1 < len1 && index2 < len2; ++index1, ++index2) {
            char c2;
            char c1 = s1.charAt(index1);
            if (c1 == (c2 = s2.charAt(index2))) continue;
            if (c1 == '\r' && index1 < len1 - 1 && s1.charAt(index1 + 1) == '\n') {
                --index2;
                continue;
            }
            if (c2 == '\r' && index2 < len2 - 1 && s2.charAt(index2 + 1) == '\n') {
                --index1;
                continue;
            }
            return false;
        }
        return index1 == len1 && index2 == len2;
    }

    public static StringBuffer join(String glue, String[] strings) {
        return StringUtil.join(glue, strings, 0, strings.length - 1);
    }

    public static StringBuffer join(String glue, String[] strings, int first, int last) {
        StringBuffer buf = new StringBuffer();
        for (int i = first; i <= last; ++i) {
            String s = strings[i];
            if (i > first) {
                buf.append(glue);
            }
            buf.append(s);
        }
        return buf;
    }

    public static <E> StringBuffer join(String glue, Collection<E> charSequences) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        for (E charSequence : charSequences) {
            if (i > 0) {
                buf.append(glue);
            }
            buf.append(charSequence);
            ++i;
        }
        return buf;
    }

    public static StringBuffer preFill(char fillChar, int minLength, String string) {
        if (string.length() >= minLength) {
            return new StringBuffer(string);
        }
        StringBuffer strbuf = new StringBuffer(minLength);
        for (int i = 0; i < minLength - string.length(); ++i) {
            strbuf.append(fillChar);
        }
        strbuf.append(string);
        return strbuf;
    }

    public static StringBuffer postFill(char fillChar, int minLength, String string) {
        if (string.length() >= minLength) {
            return new StringBuffer(string);
        }
        StringBuffer strbuf = new StringBuffer(minLength);
        strbuf.append(string);
        for (int i = 0; i < minLength - string.length(); ++i) {
            strbuf.append(fillChar);
        }
        return strbuf;
    }

    public static Set finalSetOfStrings(String[] members) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(members)));
    }

    public static String asStringOrNull(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static String asStringOrNullString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public static String asStringOrEmpty(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String escapeForCSV(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer resultBuffer = null;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            String escape = StringUtil.escapeForCSV(ch);
            if (escape != null) {
                if (resultBuffer == null) {
                    resultBuffer = new StringBuffer("\"" + str);
                    resultBuffer.setLength(1 + i);
                }
                resultBuffer.append(escape);
                continue;
            }
            if (resultBuffer == null) continue;
            resultBuffer.append(ch);
        }
        if (resultBuffer != null) {
            resultBuffer.append('\"');
        }
        return resultBuffer != null ? resultBuffer.toString() : str;
    }

    public static String escapeForCSV(char ch) {
        String escape = null;
        switch (ch) {
            case '\"': {
                escape = "\"\"";
                break;
            }
            case ',': {
                escape = ",";
            }
        }
        return escape;
    }

    public static String intern(String s) {
        if (s == null) {
            return null;
        }
        return new String(s).intern();
    }

    public static String heapIntern(String s) {
        if (s == null) {
            return null;
        }
        if (_internMap.containsKey(s)) {
            return (String)_internMap.get(s);
        }
        _internMap.put(s, s);
        return s;
    }

    public static String stripNewLinesAndExtraneousWhiteSpace(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean hitNewLine = false;
        boolean addedSpace = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                hitNewLine = true;
                continue;
            }
            if (c == ' ') {
                if (hitNewLine) {
                    if (addedSpace) continue;
                    result.append(c);
                    addedSpace = true;
                    continue;
                }
                result.append(c);
                continue;
            }
            hitNewLine = false;
            addedSpace = false;
            result.append(c);
        }
        return result.toString().trim();
    }

    public static String makeIdentifier(CharSequence name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ((sb.length() != 0 || c != '_' && !Character.isLetter(c)) && (sb.length() <= 0 || c != '_' && !Character.isLetterOrDigit(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String capitalizeFirstChar(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.startsWith("_")) {
            return StringUtil.capitalizeFirstChar(name.substring(1));
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String toRGBString(Color color) {
        StringBuilder str = new StringBuilder();
        int red = color.getRed();
        str.append(red < 16 ? "0" : "").append(Integer.toHexString(red));
        int green = color.getGreen();
        str.append(green < 16 ? "0" : "").append(Integer.toHexString(green));
        int blue = color.getBlue();
        str.append(blue < 16 ? "0" : "").append(Integer.toHexString(blue));
        return str.toString();
    }

    public static String elide(String str, int maxLength) {
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, (maxLength - 3) / 2) + "..." + str.substring(str.length() - (maxLength - 3) / 2);
    }

    public static int indexOf(CharSequence seq, char ch) {
        return StringUtil.indexOf(seq, ch, 0);
    }

    public static int indexOf(CharSequence seq, char ch, int startPos) {
        int max = seq.length();
        for (int i = startPos; i < max; ++i) {
            if (seq.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence seq, char ch) {
        return StringUtil.lastIndexOf(seq, ch, 0);
    }

    public static int lastIndexOf(CharSequence seq, char ch, int startPos) {
        for (int i = startPos - 1; i >= 0; --i) {
            if (seq.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static String htmlEncode(String text) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String xmlEncode(String text) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String formatDuration(long millis) {
        if (millis < 0L) {
            return "Negative";
        }
        int secs = (int)(millis / 1000L);
        int mins = secs / 60 % 60;
        int hrs = secs / 3600;
        secs %= 60;
        millis %= 1000L;
        StringBuilder buf = new StringBuilder();
        if (hrs > 0) {
            buf.append(hrs).append(":");
        }
        if (mins > 0 || hrs > 0) {
            if (buf.length() > 0 && mins < 10) {
                buf.append("0");
            }
            buf.append(mins).append(":");
        }
        if (secs > 0 || mins > 0 || hrs > 0) {
            if (buf.length() > 0 && secs < 10) {
                buf.append("0");
            }
            buf.append(secs).append(".");
        } else {
            buf.append("0.");
        }
        if (millis < 10L) {
            buf.append("0");
        }
        if (millis < 100L) {
            buf.append("0");
        }
        buf.append(millis);
        return buf.toString();
    }

    private static interface Escaper {
        public String eacape(char var1);
    }

    private static class InternMap
    extends ConcurrentHashMap {
        public InternMap(int initialCapacity) {
            super(initialCapacity);
        }
    }

    public static interface VariableMap {
        public String getValue(String var1);
    }
}

