/*
 * Decompiled with CFR 0.152.
 */
package editor.tabpane;

import editor.search.StudioUtilities;
import editor.tabpane.ITab;
import editor.tabpane.TabAndToolContainer;
import editor.tabpane.TabContainer;
import editor.tabpane.TabPosition;
import editor.util.EditorUtilities;
import editor.util.SettleModalEventQueue;
import editor.util.XPToolbarButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MoreTab
extends XPToolbarButton {
    private TabContainer _tabContainer;

    public MoreTab(TabContainer tabContainer) {
        this.setFont(new Font("Arial", 1, 16));
        this.setOpaque(false);
        this._tabContainer = tabContainer;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new TabContainerPopupHandler();
    }

    @Override
    public Dimension getPreferredSize() {
        switch (this._tabContainer.getTabPosition()) {
            case TOP: 
            case BOTTOM: {
                if (this._tabContainer.getTabCount() > 0) {
                    int iTabHeight = this._tabContainer.getTabAt(this._tabContainer.getTabCount() - 1).getComponent().getHeight();
                    return new Dimension(iTabHeight, iTabHeight);
                }
                return new Dimension(20, 10);
            }
            case LEFT: 
            case RIGHT: {
                if (this._tabContainer.getTabCount() > 0) {
                    int iTabWidth = this._tabContainer.getTabAt(this._tabContainer.getTabCount() - 1).getComponent().getWidth();
                    return new Dimension(iTabWidth, iTabWidth);
                }
                return new Dimension(10, 20);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.tooManyTabsToShow()) {
            return;
        }
        Graphics2D g2In = (Graphics2D)g;
        BufferedImage bi = g2In.getDeviceConfiguration().createCompatibleImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D g2Image = this.getTransformedGraphics(g2In, bi);
        this.paintTopOrientation(g2Image);
        if (g2Image != g2In) {
            g2Image.dispose();
            g2In.drawImage(bi, null, 0, 0);
        }
    }

    private Graphics2D getTransformedGraphics(Graphics2D g2, BufferedImage bi) {
        AffineTransform transform;
        if (this._tabContainer.getTabPosition() == TabPosition.TOP) {
            return g2;
        }
        Graphics2D g2Image = bi.createGraphics();
        if (this._tabContainer.getTabPosition() == TabPosition.BOTTOM) {
            transform = AffineTransform.getScaleInstance(1.0, -1.0);
            transform.translate(0.0, 1 - this.getHeight());
        } else if (this._tabContainer.getTabPosition() == TabPosition.LEFT) {
            transform = AffineTransform.getScaleInstance(-1.0, 1.0);
            transform.translate(1 - this.getWidth(), 0.0);
            transform.concatenate(AffineTransform.getRotateInstance(1.5707963267948966));
            transform.translate(0.0, 1 - this.getWidth());
        } else if (this._tabContainer.getTabPosition() == TabPosition.RIGHT) {
            transform = AffineTransform.getRotateInstance(1.5707963267948966);
            transform.translate(0.0, 1 - this.getWidth());
        } else {
            throw new IllegalStateException("Unknown TabPosition");
        }
        g2Image.setTransform(transform);
        return g2Image;
    }

    private void paintTopOrientation(Graphics g) {
        int iYStart = 1;
        g.setColor(EditorUtilities.CONTROL_SHADOW);
        g.drawLine(0, iYStart, 1, iYStart);
        boolean bLeft = true;
        int i = iYStart;
        int x = 1;
        while (i <= 32) {
            g.setColor(EditorUtilities.CONTROL_SHADOW);
            g.drawLine(x, i, x, i + 2);
            g.setColor(EditorUtilities.CONTROL_DARKSHADOW);
            g.drawLine(x + 1, i, x + 1, i + 2);
            g.setColor(EditorUtilities.CONTROL);
            g.fillRect(x + 2, i, this.getWidth(), i + 2);
            bLeft = x != 0 && (x == 2 || bLeft);
            i += 3;
            x += bLeft ? -1 : 1;
        }
        g.setFont(this.getFont());
        g.setColor(EditorUtilities.CONTROL_TEXT);
        g.drawString("...", 5, 8);
    }

    private boolean tooManyTabsToShow() {
        if (this._tabContainer.getTabCount() > 0) {
            ITab tab = this._tabContainer.getTabAt(this._tabContainer.getTabCount() - 1);
            return !this.isTabFullyVisible(tab);
        }
        return false;
    }

    private boolean isTabFullyVisible(ITab tab) {
        switch (this._tabContainer.getTabPosition()) {
            case TOP: 
            case BOTTOM: {
                return tab.getComponent().getX() + tab.getComponent().getWidth() <= this._tabContainer.getWidth();
            }
            case LEFT: 
            case RIGHT: {
                return tab.getComponent().getY() + tab.getComponent().getHeight() <= this._tabContainer.getHeight();
            }
        }
        throw new IllegalStateException();
    }

    class TabContainerPopupHandler
    extends MouseAdapter {
        private TabPaneSelectionHandler _selectionListener;
        private long _lastSelectionTime;
        private Timer _timer;
        private Placeholder _placeholder;

        TabContainerPopupHandler() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            e.consume();
            if (this._timer != null) {
                this._timer.stop();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            e.consume();
            if (!MoreTab.this.tooManyTabsToShow()) {
                return;
            }
            if (System.currentTimeMillis() - this._lastSelectionTime < 500L) {
                return;
            }
            this._timer = new Timer(250, new PopupAction());
            this._timer.setRepeats(false);
            this._timer.start();
        }

        private Point fitToScreen(Point pt, JComponent parent, TabContainer tabContainer) {
            switch (tabContainer.getTabPosition()) {
                case TOP: 
                case BOTTOM: {
                    return this.fitHorizontally(pt, parent, tabContainer);
                }
                case LEFT: 
                case RIGHT: {
                    return this.fitVertically(pt, parent, tabContainer);
                }
            }
            throw new IllegalStateException();
        }

        private Point fitHorizontally(Point pt, JComponent parent, TabContainer tabContainer) {
            Point ptScreen = new Point(pt);
            SwingUtilities.convertPointToScreen(ptScreen, parent);
            int iDelta = pt.x + tabContainer.getWidth() - parent.getToolkit().getScreenSize().width;
            if (iDelta > 0) {
                pt.x -= iDelta;
            }
            return pt;
        }

        private Point fitVertically(Point pt, JComponent parent, TabContainer tabContainer) {
            Point ptScreen = new Point(pt);
            SwingUtilities.convertPointToScreen(ptScreen, parent);
            int iDelta = pt.y + tabContainer.getHeight() - parent.getToolkit().getScreenSize().height;
            if (iDelta > 0) {
                pt.y -= iDelta;
            }
            return pt;
        }

        private class TabPopup
        extends JPopupMenu {
            private TabAndToolContainer _tabParent;

            TabPopup() {
                this._tabParent = (TabAndToolContainer)MoreTab.this._tabContainer.getParent();
                this.setLightWeightPopupEnabled(false);
            }

            @Override
            public Dimension getPreferredSize() {
                return MoreTab.this._tabContainer.getPreferredSize();
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                MoreTab.this._tabContainer.removeSelectionListener(TabContainerPopupHandler.this._selectionListener);
                this._tabParent.remove(TabContainerPopupHandler.this._placeholder);
                this._tabParent.add((Component)MoreTab.this._tabContainer, "Center");
                MoreTab.this._tabContainer.revalidate();
            }

            @Override
            public void setVisible(boolean bVisible) {
                super.setVisible(bVisible);
                if (bVisible) {
                    StudioUtilities.removePopupBorder(this);
                }
            }
        }

        private class Placeholder
        extends JComponent {
            private Placeholder() {
            }

            @Override
            public Dimension getPreferredSize() {
                switch (MoreTab.this._tabContainer.getTabPosition()) {
                    case TOP: 
                    case BOTTOM: {
                        return new Dimension(1, ((MoreTab)MoreTab.this)._tabContainer.getPreferredSize().height);
                    }
                    case LEFT: 
                    case RIGHT: {
                        return new Dimension(((MoreTab)MoreTab.this)._tabContainer.getPreferredSize().width, 1);
                    }
                }
                throw new IllegalStateException();
            }
        }

        private class TabPaneSelectionHandler
        implements ChangeListener {
            private JPopupMenu _popup;

            public TabPaneSelectionHandler(JPopupMenu popup) {
                this._popup = popup;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                TabContainerPopupHandler.this._lastSelectionTime = System.currentTimeMillis();
                this._popup.setVisible(false);
                SettleModalEventQueue.instance().run();
                MoreTab.this._tabContainer.selectTab(MoreTab.this._tabContainer.getSelectedTab(), true);
                for (ITab tab : MoreTab.this._tabContainer.getTabs()) {
                    tab.setHover(false);
                    tab.getComponent().repaint();
                }
            }
        }

        class PopupAction
        implements ActionListener {
            PopupAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MoreTab.this._tabContainer.getParent() instanceof TabPopup) {
                    return;
                }
                TabAndToolContainer parent = (TabAndToolContainer)MoreTab.this._tabContainer.getParent();
                TabPopup popup = new TabPopup();
                TabContainerPopupHandler.this._selectionListener = new TabPaneSelectionHandler(popup);
                popup.setLayout(new BorderLayout());
                popup.setBackground(EditorUtilities.CONTROL);
                Point pt = MoreTab.this._tabContainer.getLocation();
                pt = TabContainerPopupHandler.this.fitToScreen(pt, parent, MoreTab.this._tabContainer);
                MoreTab.this._tabContainer.addSelectionListener(TabContainerPopupHandler.this._selectionListener);
                int iTabDimDelta = 0;
                switch (MoreTab.this._tabContainer.getTabPosition()) {
                    case TOP: 
                    case BOTTOM: {
                        iTabDimDelta = MoreTab.this._tabContainer.getHeight() - ((MoreTab)MoreTab.this)._tabContainer.getPreferredSize().height;
                        break;
                    }
                    case LEFT: 
                    case RIGHT: {
                        iTabDimDelta = MoreTab.this._tabContainer.getWidth() - ((MoreTab)MoreTab.this)._tabContainer.getPreferredSize().width;
                    }
                }
                parent.remove(MoreTab.this._tabContainer);
                parent.add((Component)(TabContainerPopupHandler.this._placeholder = new Placeholder()), "Center");
                popup.add((Component)MoreTab.this._tabContainer, "Center");
                MoreTab.this._tabContainer.revalidate();
                switch (MoreTab.this._tabContainer.getTabPosition()) {
                    case TOP: {
                        popup.show(parent, pt.x, pt.y + iTabDimDelta);
                        break;
                    }
                    case BOTTOM: {
                        popup.show(parent, pt.x, pt.y);
                        break;
                    }
                    case LEFT: {
                        popup.show(parent, pt.x + iTabDimDelta, pt.y);
                        break;
                    }
                    case RIGHT: {
                        popup.show(parent, pt.x - iTabDimDelta, pt.y);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }
}

