/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.IValuePopup;
import editor.util.EditorUtilities;
import editor.util.TextComponentUtil;
import java.awt.EventQueue;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;

public abstract class AbstractPopup
extends JPopupMenu
implements IValuePopup {
    private EventListenerList _nodeListenerList;
    private JTextComponent _editor;

    public AbstractPopup(JTextComponent editor) {
        this._editor = editor;
        this._nodeListenerList = new EventListenerList();
    }

    public abstract void setValue(Object var1);

    public abstract void refresh();

    protected abstract void registerListeners();

    protected abstract void unregisterListeners();

    public JTextComponent getEditor() {
        return this._editor;
    }

    @Override
    public void setVisible(boolean bVisible) {
        boolean wasVisible = this.isVisible();
        super.setVisible(bVisible);
        if (this._editor == null) {
            return;
        }
        if (!wasVisible && bVisible) {
            this.registerListeners();
            EditorUtilities.removePopupBorder(this);
        } else if (wasVisible && !bVisible) {
            this.unregisterListeners();
            this._editor.requestFocus();
        }
    }

    @Override
    public void addNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.add(ChangeListener.class, l);
    }

    public void removeNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.remove(ChangeListener.class, l);
    }

    protected void fireNodeChanged(final ChangeEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fireNodeChangedNow(this._nodeListenerList, e);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractPopup.this.fireNodeChangedNow(AbstractPopup.this._nodeListenerList, e);
                }
            });
        }
    }

    private void fireNodeChangedNow(EventListenerList list, ChangeEvent e) {
        Object[] listeners = list.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    protected String filterDisplay() {
        String strPrefix = TextComponentUtil.getWordAtCaret(this._editor);
        if (!(strPrefix == null || strPrefix.length() <= 0 || !Character.isWhitespace(strPrefix.charAt(0)) && Character.isJavaIdentifierPart(strPrefix.charAt(0)) || (strPrefix = TextComponentUtil.getWordBeforeCaret(this._editor)) == null || strPrefix.length() <= 0 || !Character.isWhitespace(strPrefix.charAt(0)) && Character.isJavaIdentifierPart(strPrefix.charAt(0)))) {
            strPrefix = null;
        }
        return strPrefix;
    }
}

