/*
 * Decompiled with CFR 0.152.
 */
package editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class AbstractRangeCellRenderer
extends JPanel
implements ListCellRenderer {
    private static Border g_noFocusBorder;
    private JList _list;
    int _iMaxCodeWidth;

    public AbstractRangeCellRenderer(JList list) {
        this._list = list;
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        if (g_noFocusBorder == null) {
            g_noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }
        this.setOpaque(true);
        this.setBorder(g_noFocusBorder);
        this.setUpLabels();
        this.updateDimensions();
        this._list.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractRangeCellRenderer.this.updateDimensions();
            }
        });
    }

    private void updateDimensions() {
        ListModel model = this._list.getModel();
        if (model == null) {
            return;
        }
        int iSize = model.getSize();
        this._iMaxCodeWidth = 0;
        FontMetrics fm = this._list.getFontMetrics(this._list.getFont());
        for (int i = 0; i < iSize; ++i) {
            this._iMaxCodeWidth = Math.max(this._iMaxCodeWidth, this.getCodeWidth(fm, model.getElementAt(i)));
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int modelIndex, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setLabelsValues(list, value, isSelected);
        this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : g_noFocusBorder);
        return this;
    }

    protected void setUpLabels() {
    }

    protected void setLabelsValues(JList list, Object value, boolean isSelected) {
    }

    protected int getCodeWidth(FontMetrics fm, Object obj) {
        return 0;
    }
}

