/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.GosuEventQueue;
import editor.GosuPanel;
import editor.GosuWindowsLAF;
import editor.IGosuEditor;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import gw.config.CommonServices;
import gw.lang.parser.IScriptPartId;
import gw.lang.reflect.module.IFileSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;

public class BasicGosuEditor
extends JFrame
implements IGosuEditor {
    private GosuPanel _panel;
    private Rectangle _restoreBounds;

    public BasicGosuEditor() throws HeadlessException {
        super("Gosu Editor");
        this.configUI();
        this.setInitialSize();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BasicGosuEditor.this.exit();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                EventQueue.invokeLater(() -> {
                    GosuEditor currentEditor = BasicGosuEditor.this._panel.getCurrentEditor();
                    if (currentEditor != null) {
                        currentEditor.parse();
                    }
                });
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                EventQueue.invokeLater(BasicGosuEditor.this._panel::saveIfDirty);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if ((BasicGosuEditor.this.getExtendedState() & 6) != 6) {
                    BasicGosuEditor.this._restoreBounds = BasicGosuEditor.this.getBounds();
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if ((BasicGosuEditor.this.getExtendedState() & 6) != 6) {
                    BasicGosuEditor.this._restoreBounds = BasicGosuEditor.this.getBounds();
                }
            }
        });
    }

    public void exit() {
        EditorUtilities.saveLayoutState(this._panel.getExperimentView().getExperiment());
        if (this._panel.saveIfDirty()) {
            System.exit(0);
        }
    }

    private void configUI() {
        this.setDefaultCloseOperation(0);
        this.setIconImage(EditorUtilities.loadLabIcon().getImage());
        this._panel = new GosuPanel(this);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this._panel, "Center");
    }

    private void setInitialSize() {
        this._panel.setEditorSplitPosition(60);
        this._panel.setExperimentSplitPosition(30);
    }

    @Override
    public void reset() {
        if (EventQueue.isDispatchThread()) {
            this.resetNow();
            return;
        }
        try {
            EventQueue.invokeAndWait(this::resetNow);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void resetNow() {
        this._panel.clearTabs();
    }

    @Override
    public void openInitialFile(IScriptPartId partId, File file) {
        this._panel.openInitialFile(partId, file);
    }

    @Override
    public void openFile(File anySourceFile) {
        this._panel.openFile(anySourceFile);
    }

    @Override
    public void showMe() {
        this.setVisible(true);
        GosuEventQueue.instance().run();
    }

    @Override
    public GosuPanel getGosuPanel() {
        return this._panel;
    }

    @Override
    public void restoreState(Experiment experiment) {
        this._panel.restoreExperimentState(experiment);
    }

    public void selectTab(Object contentId) {
        this._panel.selectTab((File)contentId);
    }

    public void closeTab(Object contentId) {
        this._panel.closeTab((File)contentId);
    }

    public Rectangle getRestoreBounds() {
        return new Rectangle(this._restoreBounds);
    }

    public void setRestoreBounds(Rectangle restoreBounds) {
        this._restoreBounds = restoreBounds;
    }

    public static BasicGosuEditor create() {
        GosuWindowsLAF.setLookAndFeel();
        CommonServices.getFileSystem().setCachingMode(IFileSystem.CachingMode.NO_CACHING);
        return new BasicGosuEditor();
    }
}

