/*
 * Decompiled with CFR 0.152.
 */
package editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;

public class BatchDocument
extends DefaultStyledDocument {
    private static final char[] EOL_ARRAY = new char[]{'\n'};
    private final List<DefaultStyledDocument.ElementSpec> _batch = new ArrayList<DefaultStyledDocument.ElementSpec>();

    public void appendString(String str, AttributeSet a) {
        this.processInserts(this.getElementsForString(str, a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendBatchString(String str, AttributeSet a) {
        List<DefaultStyledDocument.ElementSpec> list = this._batch;
        synchronized (list) {
            this._batch.addAll(this.getElementsForString(str, a));
            while (this._batch.size() > 2000) {
                this._batch.remove(0);
            }
        }
    }

    private List<DefaultStyledDocument.ElementSpec> getElementsForString(String str, AttributeSet a) {
        if (str.length() > 0) {
            ArrayList<DefaultStyledDocument.ElementSpec> ret = new ArrayList<DefaultStyledDocument.ElementSpec>();
            StringTokenizer t = new StringTokenizer(str, "\n", true);
            while (t.hasMoreTokens()) {
                String s = t.nextToken();
                if (s.equals("\n")) {
                    ret.addAll(this.getElementsForLineFeed(a));
                    continue;
                }
                ret.addAll(this._getElementsForString(s, a));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    private Collection<? extends DefaultStyledDocument.ElementSpec> _getElementsForString(String str, AttributeSet a) {
        a = a.copyAttributes();
        char[] chars = str.toCharArray();
        ArrayList<DefaultStyledDocument.ElementSpec> ret = new ArrayList<DefaultStyledDocument.ElementSpec>();
        ret.add(new DefaultStyledDocument.ElementSpec(a, 3, chars, 0, str.length()));
        return ret;
    }

    public List<DefaultStyledDocument.ElementSpec> getElementsForLineFeed(AttributeSet a) {
        ArrayList<DefaultStyledDocument.ElementSpec> ret = new ArrayList<DefaultStyledDocument.ElementSpec>(3);
        Element paragraph = this.getParagraphElement(0);
        AttributeSet pattr = paragraph.getAttributes();
        ret.add(new DefaultStyledDocument.ElementSpec(null, 2));
        ret.add(new DefaultStyledDocument.ElementSpec(pattr, 1));
        ret.add(new DefaultStyledDocument.ElementSpec(a, 3, EOL_ARRAY, 0, 1));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBatchUpdates() {
        List<DefaultStyledDocument.ElementSpec> list = this._batch;
        synchronized (list) {
            this.processInserts(this._batch);
            this._batch.clear();
        }
    }

    private void processInserts(List<DefaultStyledDocument.ElementSpec> insertsList) {
        if (!insertsList.isEmpty()) {
            if (insertsList.get(insertsList.size() - 1).getType() == 1) {
                insertsList.addAll(this.getElementsForLineFeed(null));
            }
            DefaultStyledDocument.ElementSpec[] inserts = new DefaultStyledDocument.ElementSpec[insertsList.size()];
            insertsList.toArray(inserts);
            try {
                super.insert(this.getLength(), inserts);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

