/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractRangeCellRenderer;
import gw.lang.reflect.IEnumValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.JList;

public class EnumerationCellRenderer
extends AbstractRangeCellRenderer {
    private JLabel _labelCode;

    public EnumerationCellRenderer(JList list) {
        super(list);
        this.init();
    }

    @Override
    protected int getCodeWidth(FontMetrics fm, Object obj) {
        IEnumValue enumeratedValue = (IEnumValue)obj;
        return fm.stringWidth(enumeratedValue.getCode());
    }

    @Override
    protected void setUpLabels() {
        this._labelCode = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                pref.width = EnumerationCellRenderer.this._iMaxCodeWidth;
                return pref;
            }
        };
        this._labelCode.setOpaque(false);
        this.add((Component)this._labelCode, "Center");
    }

    @Override
    protected void setLabelsValues(JList list, Object value, boolean isSelected) {
        IEnumValue typecode = (IEnumValue)value;
        if (isSelected) {
            this._labelCode.setForeground(list.getSelectionForeground());
        } else {
            this._labelCode.setForeground(list.getForeground());
        }
        this._labelCode.setEnabled(list.isEnabled());
        this._labelCode.setFont(list.getFont());
        this._labelCode.setText(typecode == null ? "" : typecode.getCode());
    }
}

