/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BeanInfoNode;
import editor.BeanTree;
import editor.MethodNode;
import editor.PropertyNode;
import editor.util.EditorUtilities;
import editor.util.TextComponentUtil;
import gw.config.CommonServices;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class FlatBeanInfoPopup
extends JPopupMenu {
    private static final Map<IType, Set<IType>> BEAN_REFERENCE_MAP = new HashMap<IType, Set<IType>>();
    private JTree _tree;
    private EventListenerList _nodeListenerList;
    private boolean _bLocked;
    private JTextComponent _editor;
    private IType[] _classes;
    private EditorKeyListener _editorKeyListener;
    private UndoableEditListener _docListener;
    private int _iWidth;

    public FlatBeanInfoPopup(IType[] classBeans, JTextComponent editor, boolean bIncludeOnlySimpleDescriptors) {
        this(classBeans, editor, bIncludeOnlySimpleDescriptors, true);
    }

    public FlatBeanInfoPopup(IType[] classBeans, JTextComponent editor, boolean bIncludeOnlySimpleDescriptors, boolean bBeanGraph) {
        this._editor = editor;
        this._nodeListenerList = new EventListenerList();
        this.initLayout(classBeans, bIncludeOnlySimpleDescriptors, bBeanGraph);
    }

    protected void initLayout(IType[] classBeans, boolean bIncludeOnlySimpleDescriptors, boolean bBeanGraph) {
        this._classes = classBeans;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        JPanel pane = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        pane.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        int iY = 0;
        if (bBeanGraph) {
            Arrays.sort(classBeans, new Comparator<IType>(){

                @Override
                public int compare(IType o1, IType o2) {
                    String s1 = o1.getRelativeName();
                    String s2 = o2.getRelativeName();
                    return s1.compareToIgnoreCase(s2);
                }
            });
        }
        BeanTree beanTree = new BeanTree(classBeans, null, bIncludeOnlySimpleDescriptors, false);
        this._tree = new JTree(new DefaultTreeModel(beanTree)){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dim = super.getPreferredScrollableViewportSize();
                dim.width = FlatBeanInfoPopup.this._iWidth;
                return dim;
            }

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.addMouseListener(new BeanTreeListener());
        this._tree.setCellRenderer(new BeanTreeCellRenderer());
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setSelectionRow(0);
        this._tree.setVisibleRowCount(10);
        this._tree.expandRow(0);
        JScrollPane scrollPane = new JScrollPane(this._tree);
        scrollPane.setBorder(UIManager.getBorder("TextField.border"));
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        pane.add((Component)scrollPane, c);
        this._editorKeyListener = new EditorKeyListener();
        this._docListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                FlatBeanInfoPopup.this.filterDisplay();
            }
        };
        this.add("Center", pane);
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (bVisible) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
            this._editor.requestFocus();
        }
    }

    void registerListeners() {
        this.unregisterListeners();
        this._editor.addKeyListener(this._editorKeyListener);
        this._editor.getDocument().addUndoableEditListener(this._docListener);
    }

    void unregisterListeners() {
        this._editor.getDocument().removeUndoableEditListener(this._docListener);
        this._editor.removeKeyListener(this._editorKeyListener);
    }

    IType[] getReferences(IType[] classBeans) {
        HashSet<IType> setAggregate = new HashSet<IType>();
        for (IType classBean : classBeans) {
            Set<IType> s = FlatBeanInfoPopup.getClassReferenceSet(classBean);
            setAggregate.addAll(s);
        }
        return setAggregate.toArray(new IType[setAggregate.size()]);
    }

    void filterDisplay() {
        int iDotIndex;
        String strWholePath;
        String strPrefix = strWholePath = TextComponentUtil.getWordBeforeCaret(this._editor);
        if (strWholePath != null && strWholePath.length() > 0 && (iDotIndex = strWholePath.lastIndexOf(46)) >= 0) {
            strPrefix = strWholePath.substring(iDotIndex + 1);
        }
        BeanTree beanTree = new BeanTree(this._classes[0], null, "", strPrefix, (Boolean)false);
        this._tree.setModel(new DefaultTreeModel(beanTree));
        this._tree.setSelectionRow(0);
        this._tree.revalidate();
        this._tree.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Component invoker, int iX, int iY, int iWidth) {
        this._bLocked = true;
        try {
            this._iWidth = iWidth;
            BeanTree root = (BeanTree)this._tree.getModel().getRoot();
            if (root == null || root.getChildCount() == 0) {
                return;
            }
            super.show(invoker, iX, iY);
        }
        finally {
            this._bLocked = false;
        }
    }

    public void addNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.add(ChangeListener.class, l);
    }

    public void removeNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.remove(ChangeListener.class, l);
    }

    protected void fireNodeChanged(final EventListenerList list, final ChangeEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FlatBeanInfoPopup.this.fireNodeChangedNow(list, e);
            }
        });
    }

    protected void fireNodeChangedNow(EventListenerList list, ChangeEvent e) {
        Object[] listeners = list.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    static void initBeans() {
    }

    public static Set<IType> getClassReferenceSet(IType classSource) {
        Set<IType> setBeanReferences = BEAN_REFERENCE_MAP.get(classSource);
        if (setBeanReferences == null) {
            setBeanReferences = new HashSet<IType>();
        }
        FlatBeanInfoPopup.getClassReferenceSet(classSource, setBeanReferences, new HashSet<IType>());
        BEAN_REFERENCE_MAP.put(classSource, setBeanReferences);
        return setBeanReferences;
    }

    private static void getClassReferenceSet(IType classSource, Set<IType> setBeanReferences, Set<IType> setCyclicPrevention) {
        try {
            Class[] interfaces;
            if (classSource.isArray()) {
                classSource = classSource.getComponentType();
                FlatBeanInfoPopup.getClassReferenceSet(classSource, setBeanReferences, setCyclicPrevention);
                return;
            }
            if (setCyclicPrevention.contains(classSource)) {
                return;
            }
            setCyclicPrevention.add(classSource);
            if (!CommonServices.getEntityAccess().isEntityClass(classSource)) {
                return;
            }
            setBeanReferences.add(classSource);
            ITypeInfo beanInfo = classSource.getTypeInfo();
            if (beanInfo == null) {
                return;
            }
            List properties = TypeSystem.getProperties((ITypeInfo)beanInfo, (IType)classSource);
            for (Object pi : properties) {
                if (pi.isHidden()) continue;
                FlatBeanInfoPopup.getClassReferenceSet(pi.getFeatureType(), setBeanReferences, setCyclicPrevention);
            }
            List methods = TypeSystem.getMethods((ITypeInfo)beanInfo, (IType)beanInfo.getOwnersType());
            for (IMethodInfo method : methods) {
                if (method.isHidden()) continue;
                FlatBeanInfoPopup.getClassReferenceSet(method.getReturnType(), setBeanReferences, setCyclicPrevention);
                IParameterInfo[] paramTypes = method.getParameters();
                if (paramTypes == null) continue;
                for (IParameterInfo paramType : paramTypes) {
                    FlatBeanInfoPopup.getClassReferenceSet(paramType.getFeatureType(), setBeanReferences, setCyclicPrevention);
                }
            }
            for (Class anInterface : interfaces = FlatBeanInfoPopup.getImplementedInterfaces(classSource)) {
                FlatBeanInfoPopup.getClassReferenceSet(TypeSystem.get((Class)anInterface), setBeanReferences, setCyclicPrevention);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class[] getImplementedInterfaces(IType cls) {
        if (!(cls instanceof IJavaType)) {
            return new Class[0];
        }
        HashSet<Class> interfacesSet = new HashSet<Class>();
        FlatBeanInfoPopup.getImplementedInterfaces(((IJavaType)cls).getIntrinsicClass(), interfacesSet);
        return interfacesSet.toArray(new Class[interfacesSet.size()]);
    }

    private static void getImplementedInterfaces(Class cls, Set<Class> interfacesSet) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = cls.getInterfaces()) {
            if (interfacesSet.contains(anInterface) || CommonServices.getEntityAccess().isInternal(TypeSystem.get(anInterface))) continue;
            interfacesSet.add(anInterface);
            FlatBeanInfoPopup.getImplementedInterfaces(anInterface, interfacesSet);
        }
    }

    class BeanTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected boolean _bSelected;
        protected BeanTree _node;

        BeanTreeCellRenderer() {
        }

        @Override
        public synchronized Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
            if (value != null) {
                this._node = (BeanTree)value;
                this._bSelected = bSelected;
                this.configure();
            }
            return this;
        }

        public void update() {
            FlatBeanInfoPopup.this._tree.repaint();
        }

        public void configure() {
            if (this._node == null) {
                return;
            }
            BeanInfoNode node = this._node.getBeanNode();
            ImageIcon icon = null;
            this.setText(node.getDisplayName());
            if (node instanceof MethodNode) {
                IMethodInfo mi = ((MethodNode)node).getMethodDescriptor();
                icon = mi.isPrivate() ? EditorUtilities.loadIcon("images/Method_Private.png") : (mi.isInternal() ? EditorUtilities.loadIcon("images/Method_Sealed.png") : (mi.isProtected() ? EditorUtilities.loadIcon("images/Method_Protected.png") : EditorUtilities.loadIcon("images/Method.png")));
                if (mi.isDeprecated()) {
                    this.setText("<html><strike>" + this.getText() + "</strike></html>");
                }
            } else if (node instanceof PropertyNode) {
                IPropertyInfo pi = ((PropertyNode)node).getPropertyDescriptor();
                icon = pi.isPrivate() ? EditorUtilities.loadIcon("images/Field_Private.png") : (pi.isInternal() ? EditorUtilities.loadIcon("images/Field_Sealed.png") : (pi.isProtected() ? EditorUtilities.loadIcon("images/Field_Protected.png") : EditorUtilities.loadIcon("images/Field.png")));
                if (pi.isDeprecated()) {
                    this.setText("<html><strike>" + this.getText() + "</strike></html>");
                }
            }
            this.setIcon(icon);
        }

        @Override
        public void paint(Graphics g) {
            Color bkColor;
            if (this._bSelected) {
                bkColor = FlatBeanInfoPopup.this._tree.isEnabled() ? EditorUtilities.TEXT_HIGHLIGHT : EditorUtilities.CONTROL_SHADOW;
            } else {
                bkColor = FlatBeanInfoPopup.this._tree.getBackground();
                if (bkColor == null) {
                    bkColor = this.getBackground();
                }
            }
            if (bkColor != null) {
                Icon currentIcon = this.getIcon();
                g.setColor(bkColor);
                if (currentIcon != null && this.getText() != null) {
                    int offset = currentIcon.getIconWidth() + this.getIconTextGap() - 1;
                    g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
                    if (this._bSelected && FlatBeanInfoPopup.this._tree.hasFocus()) {
                        g.setColor(FlatBeanInfoPopup.this._tree.isEnabled() ? EditorUtilities.TEXT_HIGHLIGHT_TEXT : EditorUtilities.CONTROL_LIGHT);
                        BasicGraphicsUtils.drawDashedRect(g, offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
                    }
                } else {
                    g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    if (this._bSelected && FlatBeanInfoPopup.this._tree.hasFocus()) {
                        g.setColor(FlatBeanInfoPopup.this._tree.isEnabled() ? EditorUtilities.TEXT_HIGHLIGHT_TEXT : EditorUtilities.CONTROL_LIGHT);
                        BasicGraphicsUtils.drawDashedRect(g, 0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    }
                }
                g.setColor(bkColor);
            }
            this.setForeground(this._bSelected ? (FlatBeanInfoPopup.this._tree.isEnabled() ? EditorUtilities.TEXT_HIGHLIGHT_TEXT : EditorUtilities.CONTROL_LIGHT) : (FlatBeanInfoPopup.this._tree.isEnabled() ? EditorUtilities.TEXT_TEXT : EditorUtilities.CONTROL_SHADOW));
            super.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (dim != null) {
                dim = new Dimension(dim.width + 3, dim.height);
            }
            return dim;
        }
    }

    class BeanTreeListener
    extends MouseAdapter {
        BeanTreeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (FlatBeanInfoPopup.this._bLocked) {
                return;
            }
            TreePath path = FlatBeanInfoPopup.this._tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            BeanTree tree = (BeanTree)path.getLastPathComponent();
            FlatBeanInfoPopup.this.setVisible(false);
            FlatBeanInfoPopup.this.fireNodeChanged(FlatBeanInfoPopup.this._nodeListenerList, new ChangeEvent(tree));
            e.consume();
        }
    }

    class EditorKeyListener
    extends KeyAdapter {
        EditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
                Action selectPrevious = FlatBeanInfoPopup.this._tree.getActionMap().get("selectPrevious");
                selectPrevious.actionPerformed(new ActionEvent(FlatBeanInfoPopup.this._tree, 0, "selectPrevious"));
                e.consume();
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                Action selectNext = FlatBeanInfoPopup.this._tree.getActionMap().get("selectNext");
                selectNext.actionPerformed(new ActionEvent(FlatBeanInfoPopup.this._tree, 0, "selectNext"));
                e.consume();
            } else if (e.getKeyCode() == 33) {
                Action scrollUpChangeSelection = FlatBeanInfoPopup.this._tree.getActionMap().get("scrollUpChangeSelection");
                scrollUpChangeSelection.actionPerformed(new ActionEvent(FlatBeanInfoPopup.this._tree, 0, "scrollUpChangeSelection"));
                e.consume();
            } else if (e.getKeyCode() == 34) {
                Action scrollDownChangeSelection = FlatBeanInfoPopup.this._tree.getActionMap().get("scrollDownChangeSelection");
                scrollDownChangeSelection.actionPerformed(new ActionEvent(FlatBeanInfoPopup.this._tree, 0, "scrollDownChangeSelection"));
                e.consume();
            } else if (e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 9) {
                TreePath path = FlatBeanInfoPopup.this._tree.getSelectionPath();
                if (path == null) {
                    e.consume();
                    return;
                }
                BeanTree tree = (BeanTree)path.getLastPathComponent();
                FlatBeanInfoPopup.this.fireNodeChanged(FlatBeanInfoPopup.this._nodeListenerList, new ChangeEvent(tree));
                FlatBeanInfoPopup.this.setVisible(false);
                e.consume();
            } else if (e.getKeyCode() == 27) {
                FlatBeanInfoPopup.this.setVisible(false);
                e.consume();
            }
        }
    }
}

