/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BeanInfoNode;
import editor.BeanInfoPopup;
import editor.BeanTree;
import editor.EditorBasedPopup;
import editor.GosuEditor;
import editor.ISelectionPopup;
import editor.util.ContainerMoverSizer;
import editor.util.ContainerSizer;
import editor.util.EditorUtilities;
import editor.util.TextComponentUtil;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IDynamicPropertySymbol;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbol;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SymbolPopup
extends EditorBasedPopup
implements ISelectionPopup {
    private JPanel _pane = new JPanel();
    private JTree _tree;
    private EventListenerList _nodeListenerList = new EventListenerList();
    private boolean _bLocked;
    private EditorKeyListener _editorKeyListener;
    private UndoableEditListener _docListener;
    private ISymbol[] _symbols;
    private String _strPrefix;
    private boolean _autoDismissed;

    public SymbolPopup(ISymbol[] symbols, String strPrefix, GosuEditor editor) {
        super(editor);
        this._symbols = symbols;
        this._strPrefix = strPrefix;
        this.initLayout();
    }

    public void setSelection(ISymbol value) {
        this._tree.setSelectionRow(Arrays.asList(this._symbols).indexOf(value));
    }

    protected void initLayout() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        ContainerMoverSizer content = new ContainerMoverSizer(border);
        content.setLayout(new BorderLayout());
        this._pane.setLayout(new BorderLayout());
        this._pane.add((Component)content, "Center");
        if (this._symbols != null && this._symbols.length > 0) {
            JLabel labelTypeName = new JLabel("Objects and Functions");
            labelTypeName.setOpaque(true);
            labelTypeName.setBackground(EditorUtilities.CONTROL);
            labelTypeName.setFont(labelTypeName.getFont().deriveFont(1));
            labelTypeName.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            content.add((Component)labelTypeName, "North");
        }
        this._tree = new JTree(new SymbolRoot(this._symbols));
        this._tree.addMouseListener(new SymbolListener());
        this._tree.setCellRenderer(new BeanInfoPopup.BeanTreeCellRenderer(this._tree));
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setVisibleRowCount(10);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        JScrollPane scrollPane = new JScrollPane(this._tree);
        scrollPane.setBorder(UIManager.getBorder("TextField.border"));
        content.add((Component)scrollPane, "Center");
        JPanel sizerPanel = new JPanel(new BorderLayout());
        sizerPanel.add((Component)new JPanel(), "Center");
        sizerPanel.add((Component)new ContainerSizer(), "East");
        content.add((Component)sizerPanel, "South");
        this._editorKeyListener = new EditorKeyListener();
        this.add((Component)this._pane, "Center");
        if (this.getEditor() != null) {
            this._editorKeyListener = new EditorKeyListener();
            this._docListener = new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent e) {
                    SymbolPopup.this.filterDisplay();
                }
            };
        }
        if (this._strPrefix != null) {
            this.filterDisplay(this._strPrefix);
        }
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (this.getEditor() == null) {
            return;
        }
        if (bVisible) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
            this.getEditor().getEditor().requestFocus();
        }
    }

    void registerListeners() {
        this.unregisterListeners();
        this.getEditor().getEditor().addKeyListener(this._editorKeyListener);
        this.getEditor().getEditor().getDocument().addUndoableEditListener(this._docListener);
    }

    void unregisterListeners() {
        this.getEditor().getEditor().getDocument().removeUndoableEditListener(this._docListener);
        this.getEditor().getEditor().removeKeyListener(this._editorKeyListener);
    }

    void filterDisplay() {
        this.filterDisplay(null);
    }

    void filterDisplay(String strWholePath) {
        int iDotIndex;
        if (strWholePath == null && (strWholePath = TextComponentUtil.getWordAtCaret(this.getEditor().getEditor())) != null && strWholePath.length() > 0 && Character.isWhitespace(strWholePath.charAt(0))) {
            strWholePath = TextComponentUtil.getWordBeforeCaret(this.getEditor().getEditor());
        }
        String strPrefix = strWholePath;
        if (strWholePath != null && strWholePath.length() > 0 && (iDotIndex = strWholePath.lastIndexOf(46)) >= 0) {
            strPrefix = strWholePath.substring(iDotIndex + 1);
        }
        if (this.endsWithInvalidChar(strPrefix)) {
            this.setVisible(false);
            return;
        }
        ISymbol[] symbols = this.getSymbols();
        ArrayList<ISymbol> listSymbols = new ArrayList<ISymbol>();
        for (ISymbol symbol : symbols) {
            if (strPrefix == null || symbol.getDisplayName() == null || !symbol.getDisplayName().toLowerCase().startsWith(strPrefix.toLowerCase())) continue;
            listSymbols.add(symbol);
        }
        this._tree.setModel(new DefaultTreeModel(new SymbolRoot(listSymbols.toArray(new ISymbol[listSymbols.size()]))));
        this._tree.setSelectionRow(0);
        this._tree.revalidate();
        this._tree.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show(Component invoker, int iX, int iY) {
        this._bLocked = true;
        try {
            SymbolRoot model = (SymbolRoot)this._tree.getModel().getRoot();
            int iSize = model.getChildCount();
            if (iSize == 0) {
                return;
            }
            if (iSize == 1) {
                BeanTree symbol = (BeanTree)model.getChildAt(0);
                if (this._strPrefix != null && !this._strPrefix.equalsIgnoreCase(symbol.getBeanNode().getName())) {
                    this.fireNodeChanged(this._nodeListenerList, new ChangeEvent(symbol.makePath(false)));
                    this._autoDismissed = true;
                    return;
                }
            }
            super.show(invoker, iX, iY);
        }
        finally {
            this._bLocked = false;
        }
    }

    @Override
    public void addNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.add(ChangeListener.class, l);
    }

    public void removeNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.remove(ChangeListener.class, l);
    }

    protected void fireNodeChanged(final EventListenerList list, final ChangeEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SymbolPopup.this.fireNodeChangedNow(list, e);
            }
        });
    }

    protected void fireNodeChangedNow(EventListenerList list, ChangeEvent e) {
        Object[] listeners = list.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    ISymbol[] getSymbols() {
        return this._symbols;
    }

    ISymbol[] getFilteredSymbols() {
        return ((SymbolRoot)this._tree.getModel().getRoot())._symbols;
    }

    private String getScriptText(ISymbol symbol) {
        if (symbol.getType() instanceof IFunctionType && !(symbol.getType() instanceof IBlockType)) {
            return EditorUtilities.buildFunctionIntellisenseString(false, (IFunctionType)symbol.getType());
        }
        return symbol.getDisplayName();
    }

    @Override
    public void setSelection(String strSelection) {
        List<String> suggestionNames = this.getPopupSuggestions();
        for (int currentIndex = 0; currentIndex < suggestionNames.size(); ++currentIndex) {
            if (!suggestionNames.get(currentIndex).equals(strSelection)) continue;
            this._tree.setSelectionRow(currentIndex);
            break;
        }
    }

    @Override
    public List<String> getPopupSuggestions() {
        ArrayList<String> suggestionList = new ArrayList<String>();
        SymbolRoot listObjects = (SymbolRoot)this._tree.getModel().getRoot();
        for (int i = 0; i < listObjects.getChildCount(); ++i) {
            TreeNode value = listObjects.getChildAt(i);
            if (value instanceof ISymbol) {
                suggestionList.add(this.getScriptText((ISymbol)value));
                continue;
            }
            if (value instanceof BeanTree) {
                suggestionList.add(((BeanTree)value).getBeanNode().getName());
                continue;
            }
            suggestionList.add(value.toString());
        }
        return suggestionList;
    }

    private void handleSelection(ISymbol symbol) {
        this.fireNodeChanged(this._nodeListenerList, new ChangeEvent(this.getScriptText(symbol)));
        this.setVisible(false);
    }

    private void handleSelection(BeanTree selection) {
        this.fireNodeChanged(this._nodeListenerList, new ChangeEvent(selection.makePath(false)));
        this.setVisible(false);
    }

    void fireSelection(String s) {
        this.setSelection(s);
        this.handleSelection((BeanTree)this._tree.getSelectionPath().getLastPathComponent());
    }

    boolean wasAutoDismissed() {
        return this._autoDismissed;
    }

    private IType getWhosAskin() {
        IScriptPartId scriptPart = this.getEditor().getScriptPart();
        if (scriptPart != null) {
            return scriptPart.getContainingType();
        }
        return null;
    }

    static String getDisplayText(ISymbol symbol) {
        if (symbol.getType() instanceof IFunctionType) {
            IFunctionType type = (IFunctionType)symbol.getType();
            return type.getName() + SymbolPopup.getParamSignatureText(symbol) + " : " + SymbolPopup.getReturnTypeText(type.getReturnType());
        }
        return symbol.getName() + " : " + SymbolPopup.getTypeDisplayText(symbol.getType());
    }

    static String getReturnTypeText(IType type) {
        return SymbolPopup.getTypeDisplayText(type);
    }

    static String getParamSignatureText(ISymbol symbol) {
        if (symbol instanceof IDynamicFunctionSymbol) {
            return SymbolPopup.getDynParamSignatureText((IDynamicFunctionSymbol)symbol);
        }
        return SymbolPopup.getStaticParamSignatureText((IFunctionType)symbol.getType());
    }

    static String getDynParamSignatureText(IDynamicFunctionSymbol symbol) {
        List args = symbol.getArgs();
        if (args == null || args.size() == 0) {
            return "()";
        }
        String strParams = "(";
        for (int i = 0; i < args.size(); ++i) {
            strParams = strParams + (i == 0 ? "" : ", ") + ((ISymbol)args.get(i)).getName() + " : " + SymbolPopup.getTypeDisplayText(((ISymbol)args.get(i)).getType());
        }
        strParams = strParams + ")";
        return strParams;
    }

    static String getStaticParamSignatureText(IFunctionType type) {
        IType[] argTypes = type.getParameterTypes();
        if (argTypes == null || argTypes.length == 0) {
            return "()";
        }
        String strParams = "(";
        for (int i = 0; i < argTypes.length; ++i) {
            strParams = strParams + (i == 0 ? "" : ", ") + SymbolPopup.getTypeDisplayText(argTypes[i]);
        }
        strParams = strParams + ")";
        return strParams;
    }

    static String getTypeDisplayText(IType type) {
        return type.getRelativeName();
    }

    private class SymbolRoot
    implements TreeNode {
        private ISymbol[] _symbols;
        private List<BeanTree> _children;

        public SymbolRoot(ISymbol[] symbols) {
            this._symbols = symbols;
            this._children = new ArrayList<BeanTree>();
            for (final ISymbol symbol : symbols) {
                IType type;
                IScriptPartId scriptPart;
                BeanTree child = null;
                if (symbol.getType() instanceof IFunctionType) {
                    IMethodInfo mi = ((IFunctionType)symbol.getType()).getMethodInfo();
                    if (mi != null) {
                        child = new BeanTree(mi, this, SymbolPopup.this.getWhosAskin());
                    }
                } else if (symbol instanceof IDynamicPropertySymbol && (scriptPart = ((IDynamicPropertySymbol)symbol).getScriptPart()) != null && (type = scriptPart.getContainingType()) != null) {
                    IPropertyInfo pi = type.getTypeInfo().getProperty((CharSequence)symbol.getName());
                    if (pi != null) {
                        child = new BeanTree(type.getTypeInfo(), pi, false, SymbolPopup.this.getWhosAskin(), this);
                    } else {
                        boolean bl = false;
                    }
                }
                if (child == null) {
                    BeanInfoNode node = new BeanInfoNode(symbol.getType(), SymbolPopup.getDisplayText(symbol)){

                        @Override
                        public String getName() {
                            return SymbolPopup.this.getScriptText(symbol);
                        }

                        @Override
                        public String getPathComponent(boolean bFeatureLiteralCompletion) {
                            return SymbolPopup.this.getScriptText(symbol);
                        }
                    };
                    child = new BeanTree(node, SymbolPopup.this.getWhosAskin(), this);
                }
                this._children.add(child);
            }
            Collections.sort(this._children);
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this._children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this._symbols.length;
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public int getIndex(TreeNode node) {
            return this._children.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public Enumeration children() {
            return new Enumeration(){
                int i = 0;

                @Override
                public boolean hasMoreElements() {
                    return SymbolRoot.this._children.size() > this.i;
                }

                public Object nextElement() {
                    return SymbolRoot.this._children.get(this.i++);
                }
            };
        }
    }

    class SymbolListener
    extends MouseAdapter {
        SymbolListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SymbolPopup.this._bLocked) {
                return;
            }
            int iIndex = SymbolPopup.this._tree.getRowForLocation(e.getX(), e.getY());
            if (iIndex < 0) {
                return;
            }
            SymbolPopup.this._tree.setSelectionRow(iIndex);
            BeanTree selection = (BeanTree)SymbolPopup.this._tree.getSelectionPath().getLastPathComponent();
            if (selection != null) {
                SymbolPopup.this.handleSelection(selection);
            }
        }
    }

    class EditorKeyListener
    extends KeyAdapter {
        EditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 224 || e.getKeyCode() == 37 || e.getKeyCode() == 226) {
                Action selectPrevious = SymbolPopup.this._tree.getActionMap().get("selectPrevious");
                selectPrevious.actionPerformed(new ActionEvent(SymbolPopup.this._tree, 0, "selectPrevious"));
                e.consume();
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 225 || e.getKeyCode() == 39 || e.getKeyCode() == 227) {
                Action selectNext = SymbolPopup.this._tree.getActionMap().get("selectNext");
                selectNext.actionPerformed(new ActionEvent(SymbolPopup.this._tree, 0, "selectNext"));
                e.consume();
            } else if (e.getKeyCode() == 33) {
                Action scrollUpChangeSelection = SymbolPopup.this._tree.getActionMap().get("scrollUpChangeSelection");
                scrollUpChangeSelection.actionPerformed(new ActionEvent(SymbolPopup.this._tree, 0, "scrollUpChangeSelection"));
                e.consume();
            } else if (e.getKeyCode() == 34) {
                Action scrollDownChangeSelection = SymbolPopup.this._tree.getActionMap().get("scrollDownChangeSelection");
                scrollDownChangeSelection.actionPerformed(new ActionEvent(SymbolPopup.this._tree, 0, "scrollDownChangeSelection"));
                e.consume();
            } else if (e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 9) {
                BeanTree selection = (BeanTree)SymbolPopup.this._tree.getSelectionPath().getLastPathComponent();
                if (selection != null) {
                    SymbolPopup.this.handleSelection(selection);
                }
                SymbolPopup.this.setVisible(false);
                e.consume();
            } else if (e.getKeyCode() == 46) {
                this.handleSelectionForDot();
                e.consume();
            } else if (e.getKeyCode() == 27) {
                SymbolPopup.this.setVisible(false);
                e.consume();
            }
        }

        private void handleSelectionForDot() {
            BeanTree selection;
            TreePath path = SymbolPopup.this._tree.getSelectionPath();
            BeanTree beanTree = selection = path == null ? null : (BeanTree)path.getLastPathComponent();
            if (selection == null) {
                SymbolPopup.this.setVisible(false);
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorKeyListener.this.sendKeyEvent(8);
                    SymbolPopup.this.handleSelection(selection);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditorKeyListener.this.sendKeyEvent(46);
                        }
                    });
                }
            });
        }

        private void sendKeyEvent(int iKey) {
            SymbolPopup.this.getEditor().getEditor().dispatchEvent(new KeyEvent(SymbolPopup.this.getEditor().getEditor(), 401, System.currentTimeMillis(), 0, iKey, '\uffff'));
            SymbolPopup.this.getEditor().getEditor().dispatchEvent(new KeyEvent(SymbolPopup.this.getEditor().getEditor(), 402, System.currentTimeMillis(), 0, iKey, '\uffff'));
            SymbolPopup.this.getEditor().getEditor().dispatchEvent(new KeyEvent(SymbolPopup.this.getEditor().getEditor(), 400, System.currentTimeMillis(), 0, 0, (char)iKey));
        }
    }
}

