/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BatchDocument;
import editor.EditorScrollPane;
import editor.ScrollableEditorRootPane;
import editor.TextComponentWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.PrintStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;

public class SystemPanel
extends JPanel {
    private JTextPane _outputPanel;
    private PrintStream _out;
    private PrintStream _err;
    private PrintStream _sysOut;
    private PrintStream _sysErr;

    public SystemPanel() {
        BatchDocument document = new BatchDocument();
        this._outputPanel = new JTextPane(document);
        this._out = new TextComponentWriter(Color.WHITE, document, System.out);
        this._err = new TextComponentWriter(Color.PINK, document, System.err);
        this.configureUI();
    }

    public void configureUI() {
        this.setLayout(new BorderLayout());
        this._outputPanel.setFont(new Font("monospaced", 1, 12));
        this._outputPanel.setBorder(new EmptyBorder(3, 3, 0, 0));
        this._outputPanel.setMargin(new Insets(10, 10, 10, 10));
        this._outputPanel.setForeground(Color.white);
        this._outputPanel.setBackground(Color.black);
        this._outputPanel.setEditable(false);
        ScrollableEditorRootPane editorRootScroller = new ScrollableEditorRootPane(this._outputPanel);
        editorRootScroller.setContentPane(this._outputPanel);
        editorRootScroller.setBorder(null);
        final EditorScrollPane scroller = new EditorScrollPane(null, this._outputPanel, editorRootScroller);
        scroller.setBorder(null);
        JViewport vp = scroller.getViewport();
        vp.setScrollMode(1);
        this.add((Component)scroller, "Center");
        JLabel label = new JLabel("");
        label.setFont(label.getFont().deriveFont(1));
        label.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.add((Component)label, "North");
        this._outputPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() == 0) {
                    return;
                }
                if ((e.getModifiers() & 2) == 0) {
                    this.forward(e);
                    return;
                }
                int iInc = e.getWheelRotation() < 0 ? -1 : 1;
                Font font = SystemPanel.this._outputPanel.getFont();
                int iSize = font.getSize() + iInc;
                if (iSize < 4 || iSize > 72) {
                    return;
                }
                SystemPanel.this._outputPanel.setFont(font.deriveFont((float)iSize));
                scroller.getAdviceColumn().revalidate();
                scroller.getAdviceColumn().repaint();
            }

            private void forward(MouseWheelEvent e) {
                e = new MouseWheelEvent((Component)e.getComponent().getParent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
            }
        });
    }

    public JTextPane getOutputPanel() {
        return this._outputPanel;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._sysOut = System.out;
        this._sysErr = System.err;
        System.setOut(this._out);
        System.setErr(this._err);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        System.setOut(this._sysOut);
        System.setErr(this._sysErr);
    }

    public void println(String strOut) {
        this._out.println(strOut);
    }

    public void setText(String strOut) {
        this._outputPanel.setText(strOut);
    }

    public void clear() {
        this._outputPanel.setText("");
        this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
    }
}

