/*
 * Decompiled with CFR 0.152.
 */
package editor.tabpane;

import editor.actions.GenericAction;
import editor.splitpane.ICaptionActionListener;
import editor.tabpane.ITab;
import editor.tabpane.TabAndToolContainer;
import editor.tabpane.TabListPopup;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.util.EditorUtilities;
import editor.util.ToolBar;
import editor.util.XPToolbarButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolContainer
extends JPanel {
    private ToolBar _toolbar;
    private XPToolbarButton _btnDisplayTabs;
    private TabPane _tabPane;
    private XPToolbarButton _btnMinimize;
    private XPToolbarButton _btnRestore;
    private XPToolbarButton _btnMaximize;

    public ToolContainer(TabPane tabPane) {
        super(new BorderLayout());
        this._tabPane = tabPane;
        this._tabPane.getTabContainer().addTabpositionListener(new TabPositionChangeHandler());
        this.addCaptionTypeChangeListener();
        this.configUi();
    }

    public ToolBar getToolBar() {
        return this._toolbar;
    }

    private void configUi() {
        this.setBorder(this.makeBorder());
        this._toolbar = new ToolBar(this.isVertical() ? 1 : 0);
        if (this._tabPane.isDynamic()) {
            this.addDynamicTools();
        }
        this.addCaptionTools();
        this.add((Component)this._toolbar, "South");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.revalidate();
    }

    public TabPane getTabPane() {
        return this._tabPane;
    }

    @Override
    public Border getBorder() {
        if (this._tabPane != null && !this._tabPane.isShowing()) {
            return null;
        }
        return super.getBorder();
    }

    private Border makeBorder() {
        TabPosition tp = this._tabPane.getTabContainer().getTabPosition();
        if (tp == TabPosition.TOP) {
            return BorderFactory.createMatteBorder(0, 0, 1, 0, EditorUtilities.CONTROL_SHADOW);
        }
        if (tp == TabPosition.BOTTOM) {
            return BorderFactory.createMatteBorder(1, 0, 0, 0, EditorUtilities.CONTROL_SHADOW);
        }
        if (tp == TabPosition.LEFT) {
            return BorderFactory.createMatteBorder(0, 0, 0, 1, EditorUtilities.CONTROL_SHADOW);
        }
        return BorderFactory.createMatteBorder(0, 1, 0, 0, EditorUtilities.CONTROL_SHADOW);
    }

    private void addDynamicTools() {
        this._btnDisplayTabs = new XPToolbarButton(new DisplayTabsAction());
        this._btnDisplayTabs.setToolTipText("Open views");
        this._toolbar.add(this._btnDisplayTabs);
        if (this._tabPane.hasAtLeastOneOfMinMaxRestore()) {
            this._toolbar.addSeparator();
        }
    }

    private void addCaptionTools() {
        this._btnMinimize = new XPToolbarButton(new MinimizeAction());
        this._btnMinimize.setToolTipText("Minimize");
        if (this._tabPane.isMinimizable()) {
            this._toolbar.add(this._btnMinimize);
        }
        this._btnRestore = new XPToolbarButton(new RestoreAction());
        this._btnRestore.setToolTipText("Restore");
        if (this._tabPane.isRestorable()) {
            this._toolbar.add(this._btnRestore);
        }
        this._btnRestore.setVisible(false);
        this._btnMaximize = new XPToolbarButton(new MaximizeAction());
        this._btnMaximize.setToolTipText("Maximize");
        if (this._tabPane.isMaximizable()) {
            this._toolbar.add(this._btnMaximize);
        }
        if (this._tabPane.isDynamic()) {
            if (this._tabPane.hasAtLeastOneOfMinMaxRestore()) {
                this._toolbar.addSeparator();
            }
            XPToolbarButton btnCloseTab = new XPToolbarButton(new CloseTabAction());
            btnCloseTab.setToolTipText("Close tab");
            this._toolbar.add(btnCloseTab);
        }
    }

    private boolean isVertical() {
        return this._tabPane.getTabContainer().isVertical();
    }

    private void addCaptionTypeChangeListener() {
        EventQueue.invokeLater(() -> {
            if (this._tabPane.getTabAndToolContainer() != null) {
                this._tabPane.getTabAndToolContainer().addCaptionTypeListener(new CaptionTypeChangeHandler());
            }
        });
    }

    public ToolBar getToolbar() {
        return this._toolbar;
    }

    class CaptionTypeChangeHandler
    implements ChangeListener {
        CaptionTypeChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            EventQueue.invokeLater(() -> {
                ICaptionActionListener.ActionType actionType = ToolContainer.this._tabPane.getTabAndToolContainer().getCaptionType();
                ToolContainer.this._btnMaximize.setVisible(actionType != ICaptionActionListener.ActionType.MAXIMIZE);
                ToolContainer.this._btnRestore.setVisible(actionType != ICaptionActionListener.ActionType.RESTORE);
                ToolContainer.this._btnMinimize.setVisible(actionType != ICaptionActionListener.ActionType.MINIMIZE);
            });
        }
    }

    class TabPositionChangeHandler
    implements ChangeListener {
        TabPositionChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ToolContainer.this.getToolBar().setOrientation(ToolContainer.this._tabPane.getTabContainer().isVertical() ? 1 : 0);
        }
    }

    class MaximizeAction
    extends GenericAction {
        public MaximizeAction() {
            super("_maximize", null, "images/caption_max.gif", ' ', null, "Maximize", null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((TabAndToolContainer)ToolContainer.this._tabPane.getCaption()).fireCaptionActionPerformed(ICaptionActionListener.ActionType.MAXIMIZE);
            ToolContainer.this._btnMaximize.setVisible(false);
            ToolContainer.this._btnRestore.setVisible(true);
            ToolContainer.this._btnMaximize.setVisible(true);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    class RestoreAction
    extends GenericAction {
        public RestoreAction() {
            super("_restore", null, "images/caption_restore.gif", ' ', null, "Restore", null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((TabAndToolContainer)ToolContainer.this._tabPane.getCaption()).fireCaptionActionPerformed(ICaptionActionListener.ActionType.RESTORE);
            ToolContainer.this._btnRestore.setVisible(false);
            ToolContainer.this._btnMinimize.setVisible(true);
            ToolContainer.this._btnMaximize.setVisible(true);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    class MinimizeAction
    extends GenericAction {
        public MinimizeAction() {
            super("_minimize", null, "images/caption_min.gif", ' ', null, "Minimize", null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((TabAndToolContainer)ToolContainer.this._tabPane.getCaption()).fireCaptionActionPerformed(ICaptionActionListener.ActionType.MINIMIZE);
            ToolContainer.this._btnMinimize.setVisible(false);
            ToolContainer.this._btnRestore.setVisible(true);
            ToolContainer.this._btnMaximize.setVisible(true);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    class CloseTabAction
    extends GenericAction {
        private boolean _enabled;

        public CloseTabAction() {
            super("_closeTab", null, "images/caption_close.png", ' ', null, "Close Tab", null);
            this.setEnabled(false);
            ToolContainer.this._tabPane.getTabContainer().addSelectionListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CloseTabAction.this._enabled = ToolContainer.this._tabPane.getTabContainer().getTabCount() > 0 && ToolContainer.this._tabPane.getTabContainer().getSelectedTab().canClose();
                    CloseTabAction.this.setEnabled(CloseTabAction.this._enabled);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.closeTab();
        }

        @Override
        public boolean isEnabled() {
            return this._enabled;
        }

        private void closeTab() {
            if (ToolContainer.this._tabPane.getTabContainer().getTabCount() == 0) {
                return;
            }
            ToolContainer.this._tabPane.getTabContainer().removeTab(ToolContainer.this._tabPane.getTabContainer().getSelectedTab());
        }
    }

    class DisplayTabsAction
    extends GenericAction {
        private boolean _enabled;

        public DisplayTabsAction() {
            super("_displayTabs", null, "images/caption_list.gif", ' ', null, "Display Tabs", null);
            this.setEnabled(false);
            ToolContainer.this._tabPane.getTabContainer().addSelectionListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DisplayTabsAction.this._enabled = ToolContainer.this._tabPane.getTabContainer().getTabCount() > 0;
                    DisplayTabsAction.this.setEnabled(DisplayTabsAction.this._enabled);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.displayTabPopup();
        }

        @Override
        public boolean isEnabled() {
            return this._enabled;
        }

        private void displayTabPopup() {
            if (ToolContainer.this._tabPane.getTabContainer().getTabCount() == 0) {
                return;
            }
            TabListPopup tabListPopup = new TabListPopup(ToolContainer.this._tabPane.getTabContainer());
            tabListPopup.addNodeChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ToolContainer.this._tabPane.getTabContainer().selectTab((ITab)e.getSource(), true);
                }
            });
            tabListPopup.show(ToolContainer.this._btnDisplayTabs, ToolContainer.this._btnDisplayTabs.getX(), ToolContainer.this._btnDisplayTabs.getY() + ToolContainer.this._btnDisplayTabs.getHeight());
        }
    }
}

