/*
 * Decompiled with CFR 0.152.
 */
package editor;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;

public class EventMonitor {
    private static final EventMonitor INSTANCE = new EventMonitor();
    private boolean _bAltDown;
    private boolean _bShiftDown;
    private boolean _bCtrlDown;

    public static EventMonitor instance() {
        return INSTANCE;
    }

    private EventMonitor() {
        this.installKeyMonitor();
    }

    public boolean isAltDown() {
        return this._bAltDown;
    }

    private void setAltDown(boolean bAltDown) {
        this._bAltDown = bAltDown;
    }

    public boolean isShiftDown() {
        return this._bShiftDown;
    }

    private void setShiftDown(boolean bShiftDown) {
        this._bShiftDown = bShiftDown;
    }

    public boolean isCtrlDown() {
        return this._bCtrlDown;
    }

    private void setCtrlDown(boolean bCtrlDown) {
        this._bCtrlDown = bCtrlDown;
    }

    private void installKeyMonitor() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getID() == 401 || event.getID() == 402) {
                    KeyEvent ke = (KeyEvent)event;
                    EventMonitor.this.setCtrlDown(ke.isControlDown());
                    EventMonitor.this.setAltDown(ke.isAltDown());
                    EventMonitor.this.setShiftDown(ke.isShiftDown());
                }
            }
        }, 8L);
    }
}

