/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.CommonMenus;
import editor.FileTree;
import editor.IContextMenuHandler;
import editor.NewFilePopup;
import editor.RunMe;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.PlatformUtil;
import editor.util.SmartMenu;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuProgram;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;

public class ExperimentTreeContextMenu
implements IContextMenuHandler<JTree> {
    private static final String CUT_PREFIX = "-CUT-";
    private final Experiment _experiment;

    public ExperimentTreeContextMenu(Experiment experiment) {
        this._experiment = experiment;
    }

    @Override
    public JPopupMenu getContextMenu(JTree tree) {
        IType type;
        JPopupMenu menu = new JPopupMenu();
        SmartMenu newMenu = new SmartMenu("New");
        NewFilePopup.addMenuItems(newMenu);
        menu.add(newMenu);
        menu.add(new JSeparator());
        menu.add(new JMenuItem(new OpenAction(tree)));
        menu.add(new JSeparator());
        menu.add(new JMenuItem(new OpenOnDesktopAction(tree)));
        menu.add(new JSeparator());
        menu.add(new JMenuItem(new ClipCutAction(tree)));
        menu.add(new JMenuItem(new ClipCopyAction(tree)));
        menu.add(new JMenuItem(new ClipPasteAction(tree)));
        menu.add(new JSeparator());
        menu.add(new JMenuItem(new DeleteAction(tree)));
        FileTree item = (FileTree)tree.getLastSelectedPathComponent();
        if (item != null && (type = item.getType()) instanceof IGosuProgram) {
            menu.add(new JSeparator());
            menu.add(CommonMenus.makeRun(() -> type));
        }
        return menu;
    }

    @Override
    public void displayContextMenu(JTree tree, int x, int y, Component eventSource) {
        tree.requestFocus();
        this.getContextMenu(tree).show(tree, x, y);
    }

    public void copy(File from, File to) {
        if (from.isDirectory()) {
            to.mkdir();
            String[] children = from.list();
            for (int i = 0; i < children.length; ++i) {
                this.copy(new File(from, children[i]), new File(to, children[i]));
            }
        } else {
            try {
                int len;
                FileInputStream in = new FileInputStream(from);
                FileOutputStream out = new FileOutputStream(to);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    class DeleteAction
    extends ClipCopyAction {
        public DeleteAction(JTree tree) {
            super(tree);
            this.putValue("Name", "Delete");
            this.putValue("MnemonicKey", new Integer(68));
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null && item.canDelete();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                item.delete();
            }
        }
    }

    class ClipCutAction
    extends ClipCopyAction {
        public ClipCutAction(JTree tree) {
            super(tree);
            this.putValue("Name", "Cut");
            this.putValue("MnemonicKey", new Integer(84));
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null && !item.isSourcePathRoot() && item.getParent() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                Clipboard clipboard = ExperimentTreeContextMenu.this._experiment.getGosuPanel().getClipboard();
                clipboard.setContents(new StringSelection(ExperimentTreeContextMenu.CUT_PREFIX + item.getFileOrDir().getAbsolutePath()), this);
            }
        }
    }

    class ClipPasteAction
    extends AbstractAction
    implements ClipboardOwner {
        private JTree _tree;

        public ClipPasteAction(JTree tree) {
            super("Paste");
            this.putValue("MnemonicKey", new Integer(80));
            this._tree = tree;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item == null || item.getParent() == null) {
                return false;
            }
            Clipboard clipboard = ExperimentTreeContextMenu.this._experiment.getGosuPanel().getClipboard();
            Transferable t = clipboard.getContents(this);
            try {
                if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String path = (String)t.getTransferData(DataFlavor.stringFlavor);
                    if (path.startsWith(ExperimentTreeContextMenu.CUT_PREFIX)) {
                        path = path.substring(ExperimentTreeContextMenu.CUT_PREFIX.length());
                    }
                    return new File(path).exists();
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = ExperimentTreeContextMenu.this._experiment.getGosuPanel().getClipboard();
            Transferable t = clipboard.getContents(this);
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    FileTree selection = (FileTree)this._tree.getLastSelectedPathComponent();
                    String path = (String)t.getTransferData(DataFlavor.stringFlavor);
                    boolean bCut = path.startsWith(ExperimentTreeContextMenu.CUT_PREFIX);
                    if (bCut) {
                        path = path.substring(ExperimentTreeContextMenu.CUT_PREFIX.length());
                    }
                    File source = new File(path);
                    File target = selection.getFileOrDir().isFile() ? selection.getFileOrDir().getParentFile() : selection.getFileOrDir();
                    File newSource = new File(target.getAbsolutePath() + File.separator + source.getName());
                    if (bCut) {
                        if (!newSource.exists()) {
                            source.renameTo(newSource);
                        }
                    } else {
                        ExperimentTreeContextMenu.this.copy(source, newSource);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    class ClipCopyAction
    extends AbstractAction
    implements ClipboardOwner {
        JTree _tree;

        public ClipCopyAction(JTree tree) {
            super("Copy");
            this.putValue("MnemonicKey", new Integer(67));
            this._tree = tree;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null && !item.isSourcePathRoot() && item.getParent() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                Clipboard clipboard = ExperimentTreeContextMenu.this._experiment.getGosuPanel().getClipboard();
                clipboard.setContents(new StringSelection(item.getFileOrDir().getAbsolutePath()), this);
            }
        }
    }

    static class OpenOnDesktopAction
    extends AbstractAction
    implements ClipboardOwner {
        JTree _tree;

        private static String getFileManagerString() {
            if (PlatformUtil.isMac()) {
                return "Open in Finder";
            }
            if (PlatformUtil.isWindows()) {
                return "Open in Explorer";
            }
            return "Open in File Manager";
        }

        public OpenOnDesktopAction(JTree tree) {
            super(OpenOnDesktopAction.getFileManagerString());
            this.putValue("MnemonicKey", new Integer(80));
            this._tree = tree;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                EditorUtilities.openFileOrDir(item.getFileOrDir());
            }
        }
    }

    class OpenAction
    extends AbstractAction
    implements ClipboardOwner {
        JTree _tree;

        public OpenAction(JTree tree) {
            super("Open");
            this.putValue("MnemonicKey", new Integer(79));
            this._tree = tree;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null && item.isFile() && item.getType() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                ExperimentTreeContextMenu.this._experiment.getGosuPanel().openFile(item.getFileOrDir());
            }
        }
    }

    class NewAction
    extends AbstractAction
    implements ClipboardOwner {
        JTree _tree;

        public NewAction(JTree tree) {
            super("New...");
            this.putValue("MnemonicKey", new Integer(78));
            this._tree = tree;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null && item.getParent() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                NewFilePopup popup = new NewFilePopup();
                popup.show(RunMe.getEditorFrame().getGosuPanel(), 200, 200);
            }
        }
    }
}

