/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.GosuEditorKit;
import editor.GosuStyleContext;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class ScriptEditorMouseWheelHandler
implements MouseWheelListener {
    private GosuEditor _gsEditor;

    public ScriptEditorMouseWheelHandler(GosuEditor gsEditor) {
        this._gsEditor = gsEditor;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() == 0) {
            return;
        }
        if ((e.getModifiers() & 2) == 0) {
            this.forward(e);
            return;
        }
        int iInc = e.getWheelRotation() < 0 ? -1 : 1;
        Font font = this._gsEditor.getEditor().getFont();
        int iSize = font.getSize() + iInc;
        if (iSize < 4 || iSize > 72) {
            return;
        }
        GosuStyleContext.setDefaultFontSize(iSize);
        GosuEditorKit.getStylePreferences().setFontSize(iSize);
        font = font.deriveFont((float)iSize);
        this._gsEditor.getEditor().setFont(font);
        this._gsEditor.getScroller().getAdviceColumn().revalidate();
        this._gsEditor.getScroller().getAdviceColumn().repaint();
    }

    private void forward(MouseWheelEvent e) {
        e = new MouseWheelEvent((Component)e.getComponent().getParent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
    }
}

