/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ShallowBevelBorder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class ToolBarButton
extends JButton {
    public static final int DEFAULT_MARGIN = 2;
    private Border _borderRaised;
    private Border _borderLowered;

    public ToolBarButton(String text, Icon icon, int iMargin) {
        super(text, icon);
        this._borderRaised = new CompoundBorder(new ShallowBevelBorder(0), BorderFactory.createEmptyBorder(iMargin, iMargin, iMargin, iMargin));
        this._borderLowered = new CompoundBorder(new ShallowBevelBorder(1), BorderFactory.createEmptyBorder(iMargin, iMargin, iMargin, iMargin));
        this.setBorderPainted(false);
        this.setBorder(this._borderRaised);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setContentAreaFilled(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ToolBarButton.this.isEnabled()) {
                    ToolBarButton.this.setBorderPainted(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolBarButton.this.setBorderPainted(false);
            }
        });
    }

    public ToolBarButton(String text, Icon icon) {
        this(text, icon, 2);
    }

    public ToolBarButton(Icon icon, int iMargin) {
        this(null, icon, iMargin);
    }

    public ToolBarButton(Icon icon) {
        this(icon, 2);
    }

    public ToolBarButton(Icon icon, Color clrBorderHighlight, Color clrBorderShadow, int iMargin) {
        this(null, icon, iMargin);
        this._borderRaised = new CompoundBorder(new ShallowBevelBorder(0, clrBorderHighlight, clrBorderShadow), BorderFactory.createEmptyBorder(iMargin, iMargin, iMargin, iMargin));
        this._borderLowered = new CompoundBorder(new ShallowBevelBorder(1, clrBorderHighlight, clrBorderShadow), BorderFactory.createEmptyBorder(iMargin, iMargin, iMargin, iMargin));
    }

    public ToolBarButton(Icon icon, Color clrBorderHighlight, Color clrBorderShadow) {
        this(icon, clrBorderHighlight, clrBorderShadow, 2);
    }

    public ToolBarButton(String text) {
        this(text, null);
    }

    public ToolBarButton() {
        this(null, null);
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        JComponent separator = (JComponent)this.getClientProperty("_separatorComp");
        if (separator != null) {
            separator.setVisible(bVisible);
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setBorderPainted(false);
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.isBorderPainted()) {
            if (this.getModel().isPressed()) {
                this._borderLowered.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                this._borderRaised.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    public ToolBarButton(Action action) {
        this();
        this.setAction(action);
    }
}

