/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.search.MessageDisplay;
import editor.search.MultiLineLabelUI;
import editor.search.StudioUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.LabelUI;

public class MessageBox
extends JDialog {
    public static final int CUSTOM = -999;
    public static final String CANCEL = "_cancel";
    int _iWidestButton;
    int _iType;
    int _iButtons;
    String _strWrappedMsg;
    String[] _astrButtonLabels;
    int _iRet;
    private static Point _lastDismissedLocation;

    public MessageBox(Frame frame, String strWrappedMsg, int iButtons, int iType, String ... astrButtonLabels) {
        super(frame == null ? JOptionPane.getRootFrame() : frame, "Gosu", true);
        if (strWrappedMsg != null) {
            strWrappedMsg = strWrappedMsg.trim();
        }
        this._strWrappedMsg = strWrappedMsg;
        this._astrButtonLabels = astrButtonLabels;
        if (this._astrButtonLabels != null && this._astrButtonLabels.length == 0) {
            this._astrButtonLabels = null;
        }
        this._iType = iType;
        this._iButtons = iButtons;
        this._iRet = -1;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new MessageBoxListener());
        this.configureUI();
    }

    public static void showMessageDialog(String strWrappedMsg, int iType) {
        MessageBox.showMessageDialog(MessageDisplay.getFrame(), strWrappedMsg, iType);
    }

    public static void showMessageDialog(Frame frame, String strWrappedMsg, int iType) {
        MessageBox mb = new MessageBox(frame, strWrappedMsg, -1, iType, new String[0]);
        mb.show();
        _lastDismissedLocation = mb.getLocation();
    }

    public static int showConfirmDialog(Frame frame, String strWrappedMsg, int iButtons, int iType, String ... astrButtonLabels) {
        return MessageBox.showConfirmDialog(frame, strWrappedMsg, iButtons, iType, null, astrButtonLabels);
    }

    public static int showConfirmDialog(Frame frame, String strWrappedMsg, int iButtons, int iType, Point loc, String ... astrButtonLabels) {
        MessageBox mb = new MessageBox(frame, strWrappedMsg, iButtons, iType, astrButtonLabels);
        mb.show(loc);
        _lastDismissedLocation = mb.getLocation();
        return mb._iRet;
    }

    @Override
    public void show() {
        this.show(null);
    }

    private void show(Point loc) {
        this.pack();
        if (loc != null) {
            this.setLocation(loc);
        } else {
            StudioUtilities.centerWindowInFrame(this, this.getOwner());
        }
        super.show();
    }

    void configureUI() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel labelMsg = new JLabel(){

            @Override
            public void setUI(LabelUI ui) {
                ui = (MultiLineLabelUI)MultiLineLabelUI.createUI(this);
                super.setUI(ui);
            }

            @Override
            public Dimension getPreferredSize() {
                Insets insets = this.getInsets();
                String strText = this.getText();
                if (strText == null) {
                    return super.getPreferredSize();
                }
                int iLines = 1;
                int iMaxLen = 0;
                StringBuilder strbBuf = new StringBuilder();
                FontMetrics fm = this.getFontMetrics(this.getFont());
                for (int i = 0; i < strText.length(); ++i) {
                    char c = strText.charAt(i);
                    if (c != '\n') {
                        strbBuf.append(c);
                        continue;
                    }
                    iMaxLen = Math.max(fm.stringWidth(strbBuf.toString()), iMaxLen);
                    strbBuf.setLength(0);
                    ++iLines;
                }
                iMaxLen = Math.max(fm.stringWidth(strbBuf.toString()), iMaxLen);
                return new Dimension(iMaxLen += insets.left + insets.right, fm.getHeight() * iLines + insets.top + insets.bottom);
            }
        };
        labelMsg.setHorizontalAlignment(2);
        labelMsg.setText(this._strWrappedMsg);
        labelMsg.setBorder(new EmptyBorder(15, 15, 15, 15));
        JLabel labelIcon = new JLabel(this.loadIcon());
        labelIcon.setBorder(new EmptyBorder(15, 5, 5, 5));
        JPanel panelCenter = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panelCenter.setLayout(gridBag);
        c.anchor = 11;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        panelCenter.add((Component)labelIcon, c);
        c.anchor = 11;
        c.fill = 3;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panelCenter.add((Component)new JPanel(), c);
        c.anchor = 11;
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panelCenter.add((Component)labelMsg, c);
        this.getContentPane().add("North", panelCenter);
        this.getContentPane().add("Center", new JPanel());
        JPanel panelBtns = new JPanel();
        panelBtns.setLayout(new FlowLayout());
        switch (this._iButtons) {
            case -1: {
                JButton btnOk = new JButton(this._astrButtonLabels == null || this._astrButtonLabels[0] == null ? "OK" : this._astrButtonLabels[0]);
                this.setPreferredSize(btnOk);
                btnOk.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 0;
                        MessageBox.this.close();
                    }
                });
                panelBtns.add(btnOk);
                this.getRootPane().setDefaultButton(btnOk);
                break;
            }
            case 0: {
                this._iRet = 1;
                JButton btnYes = new JButton(this._astrButtonLabels == null || this._astrButtonLabels[0] == null ? "Yes" : this._astrButtonLabels[0]);
                this.setPreferredSize(btnYes);
                btnYes.setMnemonic('Y');
                btnYes.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 0;
                        MessageBox.this.close();
                    }
                });
                panelBtns.add(btnYes);
                this.getRootPane().setDefaultButton(btnYes);
                ((JComponent)this.getContentPane()).registerKeyboardAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 0;
                        MessageBox.this.close();
                    }
                }, KeyStroke.getKeyStroke(89, 0), 1);
                JButton btnNo = new JButton(this._astrButtonLabels == null || this._astrButtonLabels[1] == null ? "No" : this._astrButtonLabels[1]);
                this.setPreferredSize(btnNo);
                btnNo.setMnemonic('N');
                btnNo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 1;
                        MessageBox.this.close();
                    }
                });
                panelBtns.add(btnNo);
                ((JComponent)this.getContentPane()).registerKeyboardAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 1;
                        MessageBox.this.close();
                    }
                }, KeyStroke.getKeyStroke(78, 0), 1);
                break;
            }
            case 1: {
                this._iRet = 2;
                JButton btnYes = new JButton(this._astrButtonLabels == null || this._astrButtonLabels[0] == null ? "Yes" : this._astrButtonLabels[0]);
                this.setPreferredSize(btnYes);
                btnYes.setMnemonic('Y');
                btnYes.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 0;
                        MessageBox.this.close();
                    }
                });
                panelBtns.add(btnYes);
                this.getRootPane().setDefaultButton(btnYes);
                ((JComponent)this.getContentPane()).registerKeyboardAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 0;
                        MessageBox.this.close();
                    }
                }, KeyStroke.getKeyStroke(89, 0), 1);
                JButton btnNo = new JButton(this._astrButtonLabels == null || this._astrButtonLabels[1] == null ? "No" : this._astrButtonLabels[1]);
                this.setPreferredSize(btnNo);
                btnNo.setMnemonic('N');
                btnNo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 1;
                        MessageBox.this.close();
                    }
                });
                panelBtns.add(btnNo);
                ((JComponent)this.getContentPane()).registerKeyboardAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 1;
                        MessageBox.this.close();
                    }
                }, KeyStroke.getKeyStroke(78, 0), 1);
                JButton btnCancel = new JButton(this._astrButtonLabels == null || this._astrButtonLabels[2] == null ? "Cancel" : this._astrButtonLabels[2]);
                this.setPreferredSize(btnCancel);
                btnCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 2;
                        MessageBox.this.close();
                    }
                });
                panelBtns.add(btnCancel);
                break;
            }
            case 2: {
                this._iRet = 2;
                JButton btnOk = new JButton(this._astrButtonLabels == null || this._astrButtonLabels[0] == null ? "OK" : this._astrButtonLabels[0]);
                this.setPreferredSize(btnOk);
                btnOk.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 0;
                        MessageBox.this.close();
                    }
                });
                panelBtns.add(btnOk);
                this.getRootPane().setDefaultButton(btnOk);
                JButton btnCancel = new JButton(this._astrButtonLabels == null || this._astrButtonLabels[1] == null ? "Cancel" : this._astrButtonLabels[1]);
                this.setPreferredSize(btnCancel);
                btnCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageBox.this._iRet = 2;
                        MessageBox.this.close();
                    }
                });
                panelBtns.add(btnCancel);
                break;
            }
            case -999: {
                this._iRet = -1;
                for (int i = 0; i < this._astrButtonLabels.length; ++i) {
                    String strLabel = this._astrButtonLabels == null || this._astrButtonLabels[0] == null ? "Button1" : this._astrButtonLabels[i];
                    strLabel = strLabel == CANCEL ? "Cancel" : strLabel;
                    JButton btn = new JButton(strLabel);
                    final int iRet = i;
                    if (strLabel != CANCEL) {
                        char cMnemonic = strLabel.charAt(0);
                        btn.setMnemonic(cMnemonic);
                        ((JComponent)this.getContentPane()).registerKeyboardAction(new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                MessageBox.this._iRet = iRet;
                                MessageBox.this.close();
                            }
                        }, KeyStroke.getKeyStroke(Character.toLowerCase(cMnemonic)), 1);
                    }
                    this.setPreferredSize(btn);
                    btn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MessageBox.this._iRet = iRet;
                            MessageBox.this.close();
                        }
                    });
                    panelBtns.add(btn);
                    if (i != 0) continue;
                    this.getRootPane().setDefaultButton(btn);
                }
                break;
            }
        }
        this.getContentPane().add("South", panelBtns);
        ((JComponent)this.getContentPane()).registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBox.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    protected void setPreferredSize(JButton btn) {
        btn.setPreferredSize(new Dimension(this.determineWidestButton(), btn.getPreferredSize().height));
    }

    protected int determineWidestButton() {
        if (this._iWidestButton == 0) {
            JButton btn = new JButton("Cancel");
            this._iWidestButton = Math.max(this._iWidestButton, btn.getPreferredSize().width);
            btn.setText("Yes");
            this._iWidestButton = Math.max(this._iWidestButton, btn.getPreferredSize().width);
            btn.setText("No");
            this._iWidestButton = Math.max(this._iWidestButton, btn.getPreferredSize().width);
            btn.setText("OK");
            this._iWidestButton = Math.max(this._iWidestButton, btn.getPreferredSize().width);
            if (this._astrButtonLabels != null) {
                for (int i = 0; i < this._astrButtonLabels.length; ++i) {
                    if (this._astrButtonLabels[i] == null) continue;
                    btn.setText(this._astrButtonLabels[i]);
                    this._iWidestButton = Math.max(this._iWidestButton, btn.getPreferredSize().width);
                }
            }
        }
        return this._iWidestButton;
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    protected Icon loadIcon() {
        switch (this._iType) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return UIManager.getIcon("OptionPane.informationIcon");
    }

    public static Point getLastMessageLocation() {
        return _lastDismissedLocation;
    }

    class MessageBoxListener
    extends WindowAdapter {
        MessageBoxListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            MessageBox.this.close();
        }
    }
}

