/*
 * Decompiled with CFR 0.152.
 */
package editor.tabpane;

import editor.search.StudioUtilities;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.util.EditorUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ContentContainer
extends JPanel {
    private TabPane _tabPane;

    public ContentContainer(TabPane tabPane) {
        super(new GridBagLayout());
        this._tabPane = tabPane;
        this.configUi();
    }

    private void configUi() {
        this.setBorder(new ContentInnerBorder());
    }

    @Override
    public Component add(Component c) {
        this.add(c, this.getContentPaneConstraints());
        return c;
    }

    @Override
    public void remove(Component c) {
        this._tabPane.removeTabWithContent((JComponent)c);
    }

    void removeDirect(Component c) {
        super.remove(c);
        if (this.getComponentCount() == 0) {
            this.setLayout(new GridBagLayout());
        }
    }

    GridBagConstraints getContentPaneConstraints() {
        return new GridBagConstraints(0, 0, 0, 0, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
    }

    private class ContentInnerBorder
    implements Border {
        private Insets _insets;

        ContentInnerBorder() {
        }

        public Color getColor() {
            if (StudioUtilities.containsFocus(ContentContainer.this)) {
                return EditorUtilities.ACTIVE_CAPTION;
            }
            return EditorUtilities.CONTROL;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets insets = this.getBorderInsets(c);
            g.translate(x, y);
            Color borderColor = this.getColor();
            if (borderColor != null) {
                g.setColor(borderColor);
                g.fillRect(0, 0, width - insets.right, insets.top);
                g.fillRect(0, insets.top, insets.left, height - insets.top);
                g.fillRect(insets.left, height - insets.bottom, width - insets.left, insets.bottom);
                g.fillRect(width - insets.right, 0, insets.right, height - insets.bottom);
                if (ContentContainer.this._tabPane.isTopBorderOnly()) {
                    g.setColor(EditorUtilities.CONTROL_SHADOW);
                    TabPosition tp = ContentContainer.this._tabPane.getTabContainer().getTabPosition();
                    if (tp == TabPosition.TOP || tp == TabPosition.BOTTOM) {
                        g.drawLine(0, 0, 0, 1);
                        g.drawLine(ContentContainer.this.getWidth() - 1, 0, ContentContainer.this.getWidth() - 1, 1);
                    } else {
                        g.drawLine(0, 0, 1, 0);
                        g.drawLine(0, ContentContainer.this.getHeight() - 1, 1, ContentContainer.this.getHeight() - 1);
                    }
                }
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this._insets == null ? this.initInsets() : this._insets;
        }

        private Insets initInsets() {
            TabPosition tp = ContentContainer.this._tabPane.getTabContainer().getTabPosition();
            this._insets = tp == TabPosition.TOP ? new Insets(2, 0, 0, 0) : (tp == TabPosition.BOTTOM ? new Insets(0, 0, 2, 0) : (tp == TabPosition.LEFT ? new Insets(0, 2, 0, 0) : new Insets(0, 0, 0, 2)));
            return this._insets;
        }
    }
}

