/*
 * Decompiled with CFR 0.152.
 */
package editor.tabpane;

import editor.splitpane.EmptyCaptionBar;
import editor.splitpane.ICaptionActionListener;
import editor.splitpane.ICaptionBar;
import editor.tabpane.TabContainer;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.tabpane.ToolContainer;
import editor.util.EditorUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabAndToolContainer
extends JPanel
implements ICaptionBar {
    private TabPane _tabPane;
    private TabContainer _tabContainer;
    private ToolContainer _toolContainer;
    private ICaptionActionListener.ActionType _captionType;
    private TabPosition _activePosition;
    private TabAndToolContainer _copiedFrom;
    private List<ICaptionActionListener> _captionActionListeners;
    private List<ChangeListener> _captionTypeListeners;

    public TabAndToolContainer(TabPane tabPane) {
        super(new BorderLayout());
        this._tabPane = tabPane;
        this._tabContainer = this._tabPane.getTabContainer();
        this._toolContainer = this._tabPane.getToolContainer();
        this._activePosition = this._tabContainer.getTabPosition();
        this._captionActionListeners = new ArrayList<ICaptionActionListener>();
        this._captionTypeListeners = new ArrayList<ChangeListener>();
        this.configUi();
    }

    private TabAndToolContainer(TabAndToolContainer source) {
        this(source._tabPane);
        this._copiedFrom = source;
    }

    @Override
    public Component[] getDecorations() {
        return this._toolContainer.getToolBar().getComponents();
    }

    @Override
    public void addDecoration(JComponent decoration, int iIndex) {
        this._toolContainer.getToolBar().add((Component)decoration, iIndex);
    }

    @Override
    public void setCaptionType(ICaptionActionListener.ActionType actionType) {
        this._captionType = actionType;
        if (this._captionType != ICaptionActionListener.ActionType.MINIMIZE) {
            if (this._copiedFrom != null) {
                this._copiedFrom.setCaptionType(actionType);
            } else {
                this._tabContainer.setTabPosition(this._activePosition);
                this.configUi();
            }
        }
        this.fireCaptionTypePerformed();
    }

    @Override
    public ICaptionActionListener.ActionType getCaptionType() {
        return this._captionType;
    }

    @Override
    public ICaptionBar getMinimizedPanel(TabPosition tabPosition) {
        this._tabContainer.setTabPosition(tabPosition);
        this._tabContainer.addSelectionListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabAndToolContainer.this.fireCaptionActionPerformed(ICaptionActionListener.ActionType.RESTORE);
                TabAndToolContainer.this._tabContainer.removeSelectionListener(this);
            }
        });
        if (this._tabContainer.getTabCount() > 0) {
            TabAndToolContainer copy = new TabAndToolContainer(this);
            copy.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, EditorUtilities.CONTROL_SHADOW));
            return copy;
        }
        return new EmptyCaptionBar();
    }

    @Override
    public void addCaptionActionListener(ICaptionActionListener captionListener) {
        if (!this._captionActionListeners.contains(captionListener)) {
            this._captionActionListeners.add(captionListener);
        }
    }

    @Override
    public void removeCaptionActionListener(ICaptionActionListener captionListener) {
        this._captionActionListeners.remove(captionListener);
    }

    void fireCaptionActionPerformed(ICaptionActionListener.ActionType actionType) {
        ICaptionActionListener[] listeners = this._captionActionListeners.toArray(new ICaptionActionListener[this._captionActionListeners.size()]);
        if (listeners.length == 0) {
            return;
        }
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].captionActionPerformed(this._tabPane, actionType);
        }
    }

    public void addCaptionTypeListener(ChangeListener captionListener) {
        if (!this._captionTypeListeners.contains(captionListener)) {
            this._captionTypeListeners.add(captionListener);
        }
    }

    public void removeCaptionTypeListener(ChangeListener captionListener) {
        this._captionTypeListeners.remove(captionListener);
    }

    private void fireCaptionTypePerformed() {
        ChangeListener[] listeners = this._captionTypeListeners.toArray(new ChangeListener[this._captionTypeListeners.size()]);
        if (listeners.length == 0) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].stateChanged(e);
        }
    }

    private void configUi() {
        this.setOpaque(false);
        this.add((Component)this._tabContainer, "Center");
        TabPosition tabPosition = this._tabContainer.getTabPosition();
        if (tabPosition == TabPosition.TOP) {
            this.add((Component)this._toolContainer, "East");
        } else if (tabPosition == TabPosition.BOTTOM) {
            this.add((Component)this._toolContainer, "East");
        } else if (tabPosition == TabPosition.RIGHT) {
            this.add((Component)this._toolContainer, "South");
        } else if (tabPosition == TabPosition.LEFT) {
            this.add((Component)this._toolContainer, "South");
        } else {
            throw new IllegalStateException("Unknown TabPosition ");
        }
    }
}

