/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaType;
import gw.util.GosuStringUtil;
import java.util.HashMap;
import java.util.Map;

public class JavadocAccess {
    private static JavadocAccess g_instance;
    private static final String[] J2SE_PACKAGE_PREFIXES;
    private static final String J2SE_URL_PREFIX = "http://java.sun.com/j2se/1.5.0/docs/api/";
    private static final Map<String, String> JAVADOC_URL_BY_PREFIXES;

    private JavadocAccess() {
    }

    public static synchronized JavadocAccess instance() {
        if (g_instance == null) {
            g_instance = new JavadocAccess();
        }
        return g_instance;
    }

    public String getJavadocHelp(IFeatureInfo featureInfo) {
        if (featureInfo instanceof ITypeInfo) {
            return this.getTypeHelp(featureInfo.getOwnersType());
        }
        if (featureInfo instanceof IPropertyInfo) {
            return this.getMemberHelp((IPropertyInfo)featureInfo);
        }
        if (featureInfo instanceof IMethodInfo) {
            return this.getMemberHelp((IMethodInfo)featureInfo);
        }
        return null;
    }

    private String getTypeHelp(IType type) {
        if (this.isTypeHandled(type)) {
            return this.buildHtmlForClass(type.getName());
        }
        if (type instanceof IJavaType) {
            return this.getGenericNoJavadocContent((IFeatureInfo)type.getTypeInfo());
        }
        return null;
    }

    private String getMemberHelp(IPropertyInfo propertyInfo) {
        IType type = propertyInfo.getOwnersType();
        if (this.isTypeHandled(type)) {
            return this.buildHtmlForProperty((IJavaType)type, propertyInfo);
        }
        if (type instanceof IJavaType) {
            return this.getGenericNoJavadocContent((IFeatureInfo)propertyInfo);
        }
        return null;
    }

    private String getMemberHelp(IMethodInfo methodInfo) {
        IType type = methodInfo.getOwnersType();
        if (this.isTypeHandled(type)) {
            return this.buildHtmlForMethod((IJavaType)type, methodInfo);
        }
        if (type instanceof IJavaType) {
            return this.getGenericNoJavadocContent((IFeatureInfo)methodInfo);
        }
        return null;
    }

    private boolean isTypeHandled(IType type) {
        if (type instanceof IJavaType) {
            String javadocURLPrefix = this.getJavadocURLPrefix(type);
            return javadocURLPrefix != null;
        }
        return false;
    }

    private String getJavadocURLPrefix(IType type) {
        String typeName = type.getName();
        int i = typeName.indexOf(46);
        return JAVADOC_URL_BY_PREFIXES.get(typeName.substring(0, i + 1));
    }

    private String getGenericNoJavadocContent(IFeatureInfo featureInfo) {
        return "No javadoc found for " + featureInfo.getDisplayName();
    }

    private String buildHtmlForClass(String fqn) {
        return this.buildHtml("http://java.sun.com/j2se/1.5.0/docs/api/index.html?" + fqn.replace('.', '/') + ".html", fqn);
    }

    private String buildHtmlForProperty(IJavaType type, IPropertyInfo propertyInfo) {
        String propertyName = propertyInfo.getName();
        String strClassName = type.getName();
        strClassName = GosuStringUtil.replaceChars((String)strClassName, (char)'.', (char)'/');
        return this.buildHtml(this.getJavadocURLPrefix((IType)type) + strClassName + ".html#" + propertyName, propertyName);
    }

    private String buildHtmlForMethod(IJavaType type, IMethodInfo methodInfo) {
        String strClassName = type.getName();
        strClassName = GosuStringUtil.replaceChars((String)strClassName, (char)'.', (char)'/');
        StringBuilder strUrl = new StringBuilder(this.getJavadocURLPrefix((IType)type));
        strUrl.append(strClassName).append(".html#");
        this.appendMethodSignatureLink(strUrl, methodInfo);
        return this.buildHtml(strUrl.toString(), this.getMethodSignatureHtml(methodInfo));
    }

    private void appendMethodSignatureLink(StringBuilder strUrl, IMethodInfo methodInfo) {
        strUrl.append(methodInfo.getDisplayName()).append('(');
        IParameterInfo[] parameterInfos = methodInfo.getParameters();
        for (int i = 0; i < parameterInfos.length; ++i) {
            IParameterInfo parameterInfo = parameterInfos[i];
            strUrl.append(i > 0 ? ",%20" : "").append(parameterInfo.getFeatureType());
        }
        strUrl.append(')');
    }

    private String getMethodSignatureHtml(IMethodInfo methodInfo) {
        StringBuilder strSignature = new StringBuilder(methodInfo.getDisplayName() + "(");
        IParameterInfo[] parameterInfos = methodInfo.getParameters();
        for (int i = 0; i < parameterInfos.length; ++i) {
            IParameterInfo parameterInfo = parameterInfos[i];
            strSignature.append(i > 0 ? ", " : "").append(TypeSystem.getUnqualifiedClassName((IType)parameterInfo.getFeatureType()));
        }
        strSignature.append(')');
        return strSignature.toString();
    }

    private String buildHtml(String strUrl, String strText) {
        return "<html><b>Go to online JavaDoc </b><a href=\"" + strUrl + "\">" + strText + "</a></html>";
    }

    static {
        J2SE_PACKAGE_PREFIXES = new String[]{"java.", "javax."};
        JAVADOC_URL_BY_PREFIXES = new HashMap<String, String>();
        for (String J2SE_PACKAGE_PREFIX : J2SE_PACKAGE_PREFIXES) {
            JAVADOC_URL_BY_PREFIXES.put(J2SE_PACKAGE_PREFIX, J2SE_URL_PREFIX);
        }
    }
}

