/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.actions.UpdateNotifier;
import editor.util.IModalHandler;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.MenuComponent;
import java.awt.Toolkit;

public class ModalEventQueue
implements Runnable {
    private IModalHandler _modalHandler;

    public ModalEventQueue(final Component visibleComponent) {
        this._modalHandler = new IModalHandler(){

            @Override
            public boolean isModal() {
                return visibleComponent.isVisible();
            }
        };
    }

    public ModalEventQueue(IModalHandler modalHandler) {
        this._modalHandler = modalHandler;
    }

    @Override
    public void run() {
        while (this.isModal()) {
            try {
                AWTEvent event = Toolkit.getDefaultToolkit().getSystemEventQueue().getNextEvent();
                this.dispatchEvent(event);
            }
            catch (Throwable e) {
                this.handleUncaughtException(e);
            }
        }
    }

    protected void handleUncaughtException(Throwable t) {
        throw new RuntimeException(t);
    }

    protected boolean isModal() {
        return this._modalHandler.isModal();
    }

    private void handleIdleTime() {
        if (Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent() == null) {
            UpdateNotifier.instance().notifyActionComponentsNow();
        }
    }

    public void dispatchEvent(AWTEvent event) {
        Object src = event.getSource();
        if (event instanceof ActiveEvent) {
            ((ActiveEvent)((Object)event)).dispatch();
        } else if (src instanceof Component) {
            ((Component)src).dispatchEvent(event);
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(event);
        }
    }
}

