/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.util.EditorUtilities;
import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class SystemColorFilter
extends RGBImageFilter {
    private Color _clrFace;
    private Color _clrHighlight;
    private Color _clrShadow;
    private float _fFudgeFactor = 0.05f;

    public SystemColorFilter() {
        this.canFilterIndexColorModel = true;
        this._clrFace = new Color(204, 204, 203);
        this._clrHighlight = new Color(255, 255, 255);
        this._clrShadow = new Color(153, 153, 153);
    }

    public SystemColorFilter(Color clrFace, Color clrHighlight, Color clrShadow, float fFudgeFactor) {
        this.canFilterIndexColorModel = true;
        this._clrFace = clrFace;
        this._clrHighlight = clrHighlight;
        this._clrShadow = clrShadow;
        this._fFudgeFactor = fFudgeFactor;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        if ((float)r >= (float)this._clrFace.getRed() - this._fFudgeFactor * (float)this._clrFace.getRed() && (float)r <= (float)this._clrFace.getRed() + this._fFudgeFactor * (float)this._clrFace.getRed() && (float)g >= (float)this._clrFace.getGreen() - this._fFudgeFactor * (float)this._clrFace.getGreen() && (float)g <= (float)this._clrFace.getGreen() + this._fFudgeFactor * (float)this._clrFace.getGreen() && (float)b >= (float)this._clrFace.getBlue() - this._fFudgeFactor * (float)this._clrFace.getBlue() && (float)b <= (float)this._clrFace.getBlue() + this._fFudgeFactor * (float)this._clrFace.getBlue()) {
            r = EditorUtilities.CONTROL.getRed();
            g = EditorUtilities.CONTROL.getGreen();
            b = EditorUtilities.CONTROL.getBlue();
        } else if ((float)r >= (float)this._clrHighlight.getRed() - this._fFudgeFactor * (float)this._clrHighlight.getRed() && (float)r <= (float)this._clrHighlight.getRed() + this._fFudgeFactor * (float)this._clrHighlight.getRed() && (float)g >= (float)this._clrHighlight.getGreen() - this._fFudgeFactor * (float)this._clrHighlight.getGreen() && (float)g <= (float)this._clrHighlight.getGreen() + this._fFudgeFactor * (float)this._clrHighlight.getGreen() && (float)b >= (float)this._clrHighlight.getBlue() - this._fFudgeFactor * (float)this._clrHighlight.getBlue() && (float)b <= (float)this._clrHighlight.getBlue() + this._fFudgeFactor * (float)this._clrHighlight.getBlue()) {
            r = EditorUtilities.CONTROL_HIGHLIGHT.getRed();
            g = EditorUtilities.CONTROL_HIGHLIGHT.getGreen();
            b = EditorUtilities.CONTROL_HIGHLIGHT.getBlue();
        } else if ((float)r >= (float)this._clrShadow.getRed() - this._fFudgeFactor * (float)this._clrShadow.getRed() && (float)r <= (float)this._clrShadow.getRed() + this._fFudgeFactor * (float)this._clrShadow.getRed() && (float)g >= (float)this._clrShadow.getGreen() - this._fFudgeFactor * (float)this._clrShadow.getGreen() && (float)g <= (float)this._clrShadow.getGreen() + this._fFudgeFactor * (float)this._clrShadow.getGreen() && (float)b >= (float)this._clrShadow.getBlue() - this._fFudgeFactor * (float)this._clrShadow.getBlue() && (float)b <= (float)this._clrShadow.getBlue() + this._fFudgeFactor * (float)this._clrShadow.getBlue()) {
            r = EditorUtilities.CONTROL_SHADOW.getRed();
            g = EditorUtilities.CONTROL_SHADOW.getGreen();
            b = EditorUtilities.CONTROL_SHADOW.getBlue();
        }
        return (rgb & 0xFF000000) + (r << 16) + (g << 8) + b;
    }
}

