/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ITreeNode;
import editor.NodeKind;
import editor.util.EditorUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTree<T extends AbstractTree<T, N>, N extends ITreeNode>
implements MutableTreeNode {
    protected String _text;
    private NodeKind _kind;
    private N _node;
    private Map<String, Object> _userData;
    private T _parent;
    private List<T> _children;

    public AbstractTree(JTree tree) {
        this._text = "_root_";
        this._kind = NodeKind.Root;
        this._userData = new HashMap<String, Object>();
        this._children = Collections.emptyList();
        this.putUserData("_tree", tree);
    }

    public AbstractTree(NodeKind kind, N node) {
        this(null, kind, node);
    }

    public AbstractTree(String text, NodeKind kind, N node) {
        this._text = text;
        this._kind = kind;
        this._node = node;
        this._children = Collections.emptyList();
    }

    public abstract Icon getIcon();

    public JTree getTree() {
        T root = this.getRoot();
        return root == null ? null : (JTree)((AbstractTree)root).getUserData("_tree");
    }

    public T getRoot() {
        if (this._kind == NodeKind.Root) {
            return (T)this;
        }
        return this.getParent() == null ? null : (T)((AbstractTree)this.getParent()).getRoot();
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
        ((DefaultTreeModel)this.getTree().getModel()).nodeStructureChanged(this);
    }

    public NodeKind getKind() {
        return this._kind;
    }

    public N getNode() {
        return this._node;
    }

    public boolean isTerminal() {
        return this._kind.isTerminal();
    }

    public List<T> getChildren() {
        return this._children;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        if (this._children.isEmpty()) {
            this._children = new CopyOnWriteArrayList<T>();
        }
        this._children.add(index, (AbstractTree)child);
        child.setParent(this);
    }

    public void addViaModel(MutableTreeNode child) {
        EditorUtilities.invokeInDispatchThread(() -> {
            JTree tree = this.getTree();
            if (tree != null) {
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                model.insertNodeInto(child, this, this.getChildCount());
            } else {
                this.insert(child, this.getChildCount());
            }
        });
    }

    public void insertViaModel(MutableTreeNode child, int index) {
        EditorUtilities.invokeInDispatchThread(() -> {
            JTree tree = this.getTree();
            if (tree != null) {
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                model.insertNodeInto(child, this, index);
            }
        });
    }

    @Override
    public void remove(int index) {
        this.remove((MutableTreeNode)this.getChildren().get(index));
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.getChildren().remove(node);
    }

    @Override
    public void setUserObject(Object object) {
    }

    public void putUserData(String name, Object value) {
        if (this._userData == null) {
            this._userData = new HashMap<String, Object>();
        }
        this._userData.put(name, value);
    }

    public Object getUserData(String name) {
        if (this._userData == null) {
            return null;
        }
        return this._userData.get(name);
    }

    @Override
    public void removeFromParent() {
        ((AbstractTree)this._parent).remove(this);
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this._parent = (AbstractTree)newParent;
    }

    public T getChildAt(int childIndex) {
        return (T)((AbstractTree)this.getChildren().get(childIndex));
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    public T getParent() {
        return this._parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this._kind.isTerminal();
    }

    @Override
    public boolean isLeaf() {
        return this.isTerminal();
    }

    public Enumeration children() {
        final Iterator<T> iter = this.getChildren().iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    public String toString() {
        return this._text;
    }

    public void select() {
        JTree tree = this.getTree();
        TreePath path = this.getPath();
        tree.expandPath(path);
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public TreePath getPath() {
        List path = this.makePath(new ArrayList());
        return new TreePath(path.toArray(new AbstractTree[path.size()]));
    }

    List<T> makePath(List<T> path) {
        if (this.getParent() != null) {
            ((AbstractTree)this.getParent()).makePath(path);
        }
        path.add(this);
        return path;
    }

    public boolean hasFailures() {
        return this._kind == NodeKind.Failure || this.getChildren().stream().anyMatch(child -> child.hasFailures());
    }

    public boolean hasErrors() {
        return this._kind == NodeKind.Error || this.getChildren().stream().anyMatch(child -> child.hasErrors());
    }

    public boolean hasWarnings() {
        return this._kind == NodeKind.Warning || this.getChildren().stream().anyMatch(child -> child.hasWarnings());
    }

    public int depth() {
        int depth = 0;
        TreeNode csr = this;
        while (csr.getParent() != null) {
            csr = csr.getParent();
            ++depth;
        }
        return depth;
    }
}

