/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorHost;
import editor.EditorScrollPane;
import editor.ILineInfoManager;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.View;

public class EditorHostTextPane
extends JEditorPane {
    private EditorHost _editor;

    public EditorHostTextPane(EditorHost editor) {
        this._editor = editor;
        this.putClientProperty("JEditorPane.honorDisplayProperties", true);
    }

    public EditorHost getEditor() {
        return this._editor;
    }

    @Override
    public void setHighlighter(Highlighter h) {
        super.setHighlighter(new GosuHighlighter((LayeredHighlighter)h));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = 0;
        Element root = this.getDocument().getDefaultRootElement();
        for (int i = 0; i < root.getElementCount(); ++i) {
            Element line = root.getElement(i);
            try {
                String strLine = this.getDocument().getText(line.getStartOffset(), line.getEndOffset() - line.getStartOffset());
                int iWidth = this.getFontMetrics(this.getFont()).stringWidth(strLine) + 50;
                dim.width = Math.max(iWidth, dim.width);
                continue;
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        return dim;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        try {
            return this._editor.getTooltipMessage(event);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return "";
        }
    }

    @Override
    public void paint(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g);
        this.paintBreakpoints(g);
    }

    private void paintBreakpoints(Graphics g) {
        Rectangle rc = g.getClipBounds();
        int[] lines = this.getLinesInClipBounds(rc);
        for (int i = lines[0]; i <= lines[1]; ++i) {
            ILineInfoManager lineInfoMgr;
            EditorScrollPane scroller = this._editor.getScroller();
            if (scroller == null || (lineInfoMgr = scroller.getLineInfoMgr()) == null) continue;
            lineInfoMgr.renderHighlight(g, i);
        }
    }

    private int[] getLinesInClipBounds(Rectangle rc) {
        int iOffset = this.viewToModel(new Point(rc.x, rc.y));
        int iExtent = this.viewToModel(new Point(rc.x + rc.width, rc.y + rc.height));
        Element root = this.getDocument().getRootElements()[0];
        int iStartLine = 1 + root.getElementIndex(iOffset);
        int iEndLine = 1 + root.getElementIndex(iExtent);
        return new int[]{iStartLine, iEndLine};
    }

    @Override
    public void setCaretPosition(int position) {
        block3: {
            try {
                Rectangle newCaretRect = this.modelToView(position);
                if (newCaretRect != null) {
                    newCaretRect.grow(0, 100);
                    this.scrollRectToVisible(newCaretRect);
                }
                super.setCaretPosition(position);
            }
            catch (BadLocationException e) {
                if (this.getDocument().getLength() >= position) break block3;
                this.setCaretPosition(this.getDocument().getLength());
            }
        }
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (!GraphicsEnvironment.isHeadless() && orientation == 1) {
            return this.getFontMetrics(this.getFont()).getHeight();
        }
        return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return super.getScrollableBlockIncrement(visibleRect, orientation, direction) - this.getFontMetrics(this.getFont()).getHeight() + 1;
    }

    void simulateKeyEvent(KeyEvent e) {
        this.processKeyEvent(e);
    }

    private class GosuHighlighter
    extends LayeredHighlighter {
        private LayeredHighlighter _highlighter;

        private GosuHighlighter(LayeredHighlighter h) {
            this._highlighter = h;
        }

        @Override
        public void install(JTextComponent c) {
            this._highlighter.install(c);
        }

        @Override
        public void deinstall(JTextComponent c) {
            this._highlighter.deinstall(c);
        }

        @Override
        public void paint(Graphics g) {
            this._highlighter.paint(g);
        }

        @Override
        public void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
            this._highlighter.paintLayeredHighlights(g, p0, p1, viewBounds, editor, view);
        }

        @Override
        public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter p) throws BadLocationException {
            return this._highlighter.addHighlight(p0, p1, p);
        }

        @Override
        public void removeHighlight(Object tag) {
            this._highlighter.removeHighlight(tag);
        }

        @Override
        public void removeAllHighlights() {
            this._highlighter.removeAllHighlights();
        }

        @Override
        public void changeHighlight(Object tag, int p0, int p1) throws BadLocationException {
            this._highlighter.changeHighlight(tag, p0, p1);
        }

        @Override
        public Highlighter.Highlight[] getHighlights() {
            return this._highlighter.getHighlights();
        }
    }
}

