/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.util.EditorUtilities;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HtmlViewer
extends JEditorPane {
    public HtmlViewer() {
        this.setEditable(false);
        this.setContentType("text/html");
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addHyperlinkListener(new HyperlinkHandler());
    }

    @Override
    public void setText(String strText) {
        if (strText == null) {
            strText = "";
        } else if (!strText.startsWith("<html")) {
            strText = "<head>\n<style type=\"text/css\">\nBODY {margin: 5px; font-family: Tahoma, Verdana, Arial, Helvetica; font-size: 12pt}\nH1 {font-size: 120%;}\nH3 {background-color: #E4E4DA; text-indent: 5px; }\nCODE {font-size: 111%; color: #000099; }\nDT {font-style: italic;}\n</style>\n</head><html>" + strText + "</html>";
        }
        super.setText(strText);
    }

    class HyperlinkHandler
    implements HyperlinkListener {
        HyperlinkHandler() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            URL url = e.getURL();
            if (url == null) {
                return;
            }
            String strProtocol = url.getProtocol();
            String strUrl = url.toString();
            if (!strProtocol.equals("gosu")) {
                try {
                    EditorUtilities.browse(strUrl);
                }
                catch (Throwable t) {
                    EditorUtilities.handleUncaughtException(t);
                }
            }
        }
    }
}

