/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.IHandleCancel;
import editor.IdentifierTextField;
import editor.plugin.typeloader.ITypeFactory;
import editor.util.EditorUtilities;
import editor.util.LabButton;
import gw.lang.reflect.gs.ClassType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NewIdentifierDialog
extends JDialog
implements IHandleCancel {
    private IdentifierTextField _nameField;
    private boolean _bAcceptDot;
    private String _name;

    public NewIdentifierDialog(ClassType classType) {
        super((JFrame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), "New " + classType.keyword() + " Name", true);
        this.setIconImage(((ImageIcon)EditorUtilities.findIcon(classType)).getImage());
        this.configUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NewIdentifierDialog.this.dispose();
            }
        });
    }

    public NewIdentifierDialog(ITypeFactory factory) {
        super((JFrame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), "New " + factory.getName() + " Name", true);
        this.setIconImage(EditorUtilities.loadIcon(factory.getIcon()).getImage());
        this.configUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NewIdentifierDialog.this.dispose();
            }
        });
    }

    public NewIdentifierDialog(boolean bAcceptDot) {
        super((JFrame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), "New File", true);
        this._bAcceptDot = bAcceptDot;
        this.setIconImage(EditorUtilities.loadIcon("images/FileText.png").getImage());
        this.configUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NewIdentifierDialog.this.dispose();
            }
        });
    }

    public NewIdentifierDialog() {
        super((JFrame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), "New Namespace Name", true);
        this.setIconImage(EditorUtilities.loadIcon("images/folder.png").getImage());
        this.configUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NewIdentifierDialog.this.dispose();
            }
        });
    }

    protected void configUI() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        contentPane.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        this._nameField = new IdentifierTextField(this._bAcceptDot, true);
        this._nameField.setColumns(30);
        mainPanel.add((Component)this._nameField, "North");
        mainPanel.add((Component)new JPanel(), "Center");
        contentPane.add((Component)mainPanel, "Center");
        JPanel south = new JPanel(new BorderLayout());
        south.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        JPanel filler = new JPanel();
        south.add((Component)filler, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        LabButton btnOk = new LabButton("OK");
        btnOk.setMnemonic('O');
        btnOk.addActionListener(e -> {
            this._name = this._nameField.getText();
            this.close();
        });
        buttonPanel.add(btnOk);
        this.getRootPane().setDefaultButton(btnOk);
        LabButton btnCancel = new LabButton("Cancel");
        btnCancel.addActionListener(e -> this.close());
        buttonPanel.add(btnCancel);
        south.add((Component)buttonPanel, "East");
        contentPane.add((Component)south, "South");
        this.mapCancelKeystroke("Cancel", this::close);
        this.pack();
        EditorUtilities.centerWindowInFrame(this, this.getOwner());
    }

    public String getClassName() {
        return this._name;
    }

    private void close() {
        this.dispose();
    }
}

