/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.LabFrame;
import editor.util.EditorUtilities;
import editor.util.SmartMenuItem;
import gw.util.PathUtil;
import java.awt.event.ActionEvent;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ReopenExperimentPopup
implements MenuListener {
    private JMenu _menu;

    private ReopenExperimentPopup(JMenu reopenExperiment) {
        this._menu = reopenExperiment;
        reopenExperiment.addMenuListener(this);
    }

    public static void initialize(JMenu reopenExperiment) {
        new ReopenExperimentPopup(reopenExperiment);
    }

    private void addNewItem(String name, String icon, final Runnable action) {
        SmartMenuItem item = new SmartMenuItem(new AbstractAction(name, EditorUtilities.loadIcon(icon)){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.run();
            }
        });
        this._menu.add(item);
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this._menu.removeAll();
        this.addExperimentMenuItems();
        this.addClearList();
    }

    private void addClearList() {
        List<String> experiments = LabFrame.instance().getExperiments();
        if (experiments.size() > 1) {
            this._menu.addSeparator();
            this.addNewItem("Clear List", "images/close.png", () -> {
                ArrayList<String> newList = new ArrayList<String>();
                newList.add((String)experiments.get(0));
                LabFrame.instance().setExperiments(newList);
            });
        } else {
            SmartMenuItem empty = new SmartMenuItem(new AbstractAction("<empty>", EditorUtilities.loadIcon("images/empty16x16.gif")){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            empty.setEnabled(false);
            this._menu.add(empty);
        }
    }

    private void addExperimentMenuItems() {
        List<String> experiments = LabFrame.instance().getExperiments();
        for (int i = 1; i < experiments.size(); ++i) {
            String exp = experiments.get(i);
            Path dir = PathUtil.create((String)exp, (String[])new String[0]);
            if (!PathUtil.exists((Path)dir, (LinkOption[])new LinkOption[0])) continue;
            String label = PathUtil.getName((Path)dir) + " - [" + exp + "]";
            this.addNewItem(label, "images/g_16.png", () -> LabFrame.instance().getGosuPanel().openExperiment(PathUtil.create((String)exp, (String[])new String[0])));
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }
}

