/*
 * Decompiled with CFR 0.152.
 */
package editor.run;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import editor.run.AbstractOutOfProcessExecutor;
import editor.run.FqnRunConfig;
import editor.run.RunState;
import editor.settings.CompilerSettings;
import editor.util.PlatformUtil;
import gw.lang.Gosu;
import java.io.File;
import java.util.Map;

public class OutOfProcessDebug
extends AbstractOutOfProcessExecutor<FqnRunConfig> {
    public OutOfProcessDebug() {
        super(RunState.Debug);
    }

    @Override
    protected String exec() throws Exception {
        String progArgs;
        VirtualMachineManager vmm = Bootstrap.virtualMachineManager();
        LaunchingConnector conn = vmm.defaultConnector();
        Map<String, Connector.Argument> defaultArguments = conn.defaultArguments();
        String jreHome = ((FqnRunConfig)this.getRunConfig()).getJreForProcessOrDefault(defaultArguments.get("home").value());
        defaultArguments.get("home").setValue(jreHome);
        String string = progArgs = ((FqnRunConfig)this.getRunConfig()).getProgArgs() == null ? "" : ((FqnRunConfig)this.getRunConfig()).getProgArgs();
        if (CompilerSettings.isStaticCompile()) {
            defaultArguments.get("main").setValue(((FqnRunConfig)this.getRunConfig()).getFqn().replace('.', '/') + " " + progArgs);
        } else {
            defaultArguments.get("main").setValue(Gosu.class.getName().replace('.', '/') + " -fqn " + ((FqnRunConfig)this.getRunConfig()).getFqn() + " " + progArgs);
        }
        String vmArgs = ((FqnRunConfig)this.getRunConfig()).getVmArgs() == null ? "" : ((FqnRunConfig)this.getRunConfig()).getVmArgs();
        defaultArguments.get("options").setValue(vmArgs + " -cp \"" + this.makeClasspath(this.getGosuPanel(), true) + "\"");
        this.printLabMessage(this.makeDebuggingMessage(defaultArguments));
        this.setVm(conn.launch(defaultArguments));
        this.setProcess(this.getVm().process());
        this.getGosuPanel().pipeInput();
        this.getGosuPanel().makeDebugger(this.getVm());
        this.waitFor();
        return String.valueOf("Process finished with exit code " + this.getProcess().exitValue());
    }

    private String makeDebuggingMessage(Map<String, Connector.Argument> vmArgs) {
        StringBuilder sb = new StringBuilder();
        String java = vmArgs.get("home").value() + File.separator + "bin" + File.separator + "java" + (PlatformUtil.isWindows() ? ".exe" : "");
        String javaArgs = vmArgs.get("options").value();
        String target = vmArgs.get("main").value();
        sb.append(java).append(' ').append(javaArgs).append(' ').append(target).append('\n');
        sb.append("Debugging: ").append(((FqnRunConfig)this.getRunConfig()).getName()).append("...\n");
        return sb.toString();
    }
}

