/*
 * Decompiled with CFR 0.152.
 */
package editor.run;

import editor.run.AbstractOutOfProcessExecutor;
import editor.run.FqnRunConfig;
import editor.run.RunState;
import editor.settings.CompilerSettings;
import gw.lang.Gosu;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class OutOfProcessRun
extends AbstractOutOfProcessExecutor<FqnRunConfig> {
    public OutOfProcessRun() {
        super(RunState.Run);
    }

    @Override
    protected String exec() throws Exception {
        String javaHome = ((FqnRunConfig)this.getRunConfig()).getJreForProcessOrDefault();
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = this.makeClasspath(this.getGosuPanel());
        ArrayList<String> args = new ArrayList<String>();
        args.add(javaBin);
        args.addAll(((FqnRunConfig)this.getRunConfig()).makeVmArgs());
        args.add("-classpath");
        args.add(classpath);
        if (CompilerSettings.isStaticCompile()) {
            args.add(((FqnRunConfig)this.getRunConfig()).getFqn().replace(',', '/'));
        } else {
            args.add(Gosu.class.getName().replace('.', '/'));
            args.add("-fqn");
            args.add(((FqnRunConfig)this.getRunConfig()).getFqn());
        }
        args.addAll(((FqnRunConfig)this.getRunConfig()).makeProgArgs());
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(((FqnRunConfig)this.getRunConfig()).getWorkingDirForProcess().toFile());
        this.printLabMessage(this.makeRunningMessage(((FqnRunConfig)this.getRunConfig()).getName(), pb.command()));
        this.setProcess(pb.start());
        this.getGosuPanel().pipeInput();
        this.waitFor();
        return String.valueOf("Process finished with exit code " + this.getProcess().exitValue());
    }

    private String makeRunningMessage(String fqn, List<String> command) {
        StringBuilder sb = new StringBuilder();
        for (String part : command) {
            sb.append(part).append(' ');
        }
        sb.append('\n');
        sb.append("Running: ").append(fqn).append("...\n");
        return sb.toString();
    }
}

