/*
 * Decompiled with CFR 0.152.
 */
package editor.run;

import editor.AbstractTreeCellRenderer;
import editor.IHandleCancel;
import editor.LabFrame;
import editor.Scheme;
import editor.run.IRunConfig;
import editor.run.IRunConfigFactory;
import editor.run.IRunConfigParameters;
import editor.run.ProgramRunConfig;
import editor.run.ProgramRunConfigFactory;
import editor.run.RemoteRunConfig;
import editor.run.RemoteRunConfigFactory;
import editor.run.RunConfigTree;
import editor.run.RunState;
import editor.splitpane.CollapsibleSplitPane;
import editor.tabpane.ITab;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.tabpane.ToolContainer;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.IEditableLabel;
import editor.util.LabButton;
import editor.util.LabToolbarButton;
import editor.util.ToolBar;
import gw.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;

public class RunConfigDialog
extends JDialog
implements IHandleCancel {
    private final Experiment _experiment;
    private final RunState _runState;
    private JButton _btnSave;
    private JButton _btnRun;
    private JTree _tree;
    private ITab _configTab;
    private JPanel _configPanel;
    private List<IRunConfig> _addedConfigs;
    private List<IRunConfig> _removedConfigs;
    private List<IRunConfig> _modifiedConfigs;
    private Map<IRunConfig, Pair<IRunConfigParameters, JComponent>> _mapRunConfigs;
    private IRunConfig _runMe;
    private AbstractButton _btnPlus;
    private AbstractButton _btnMinus;

    public RunConfigDialog(Experiment experiment, RunState runState) {
        super(LabFrame.instance(), "Run Configurations", true);
        this._experiment = experiment;
        this._runState = runState;
        this._addedConfigs = new ArrayList<IRunConfig>();
        this._removedConfigs = new ArrayList<IRunConfig>();
        this._modifiedConfigs = new ArrayList<IRunConfig>();
        this._mapRunConfigs = new HashMap<IRunConfig, Pair<IRunConfigParameters, JComponent>>();
        this.configUi();
    }

    protected void configUi() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        contentPane.setLayout(new BorderLayout());
        this._configPanel = new JPanel(new BorderLayout());
        TabPane configTabPane = new TabPane(TabPosition.TOP, 7);
        this._configTab = configTabPane.addTab("Config", null, this._configPanel);
        JPanel buttonPanel = this.makeButtonPanel();
        CollapsibleSplitPane splitPane = new CollapsibleSplitPane(0, this.makeTreePanel(), configTabPane);
        this.add((Component)splitPane, "Center");
        splitPane.setPosition(30.0);
        contentPane.add((Component)splitPane, "Center");
        JPanel south = new JPanel(new BorderLayout());
        south.setBackground(Scheme.active().getMenu());
        south.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        JPanel filler = new JPanel();
        filler.setBackground(Scheme.active().getMenu());
        south.add((Component)filler, "Center");
        south.add((Component)buttonPanel, "East");
        contentPane.add((Component)south, "South");
        contentPane.setBackground(Scheme.active().getMenu());
        this.mapCancelKeystroke("Cancel", this::close);
        this.setSize(800, 500);
        EditorUtilities.centerWindowInFrame(this, this.getOwner());
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(Scheme.active().getMenu());
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.addRunButton(buttonPanel);
        this.addSeparator(buttonPanel);
        this.addSaveButton(buttonPanel);
        this.addSeparator(buttonPanel);
        LabButton btnCancel = new LabButton("Cancel");
        btnCancel.addActionListener(e -> this.close());
        buttonPanel.add(btnCancel);
        return buttonPanel;
    }

    private void addSeparator(JPanel buttonPanel) {
        JPanel separator = new JPanel();
        separator.setBackground(Scheme.active().getMenu());
        separator.setMinimumSize(new Dimension(8, 8));
        buttonPanel.add(separator);
    }

    private void addSaveButton(JPanel buttonPanel) {
        this._btnSave = new LabButton("Save");
        this._btnSave.setMnemonic('S');
        this._btnSave.addActionListener(e -> {
            this.save();
            this.close();
        });
        buttonPanel.add(this._btnSave);
        this.getRootPane().setDefaultButton(this._btnSave);
        this._btnSave.setEnabled(false);
    }

    private void addRunButton(JPanel buttonPanel) {
        this._btnRun = new LabButton(this._runState.name());
        this._btnRun.setMnemonic(this._runState.name().charAt(0));
        this._btnRun.addActionListener(e -> {
            this._runMe = this.getSelectedTree().getRunConfig();
            this.save();
            this.close();
        });
        buttonPanel.add(this._btnRun);
        this.getRootPane().setDefaultButton(this._btnRun);
        this._btnRun.setEnabled(false);
    }

    public IRunConfig getConfigToRun() {
        return this._runMe;
    }

    private void showConfigPanel() {
        RunConfigTree selection = this.getSelectedTree();
        if (selection == null) {
            return;
        }
        this._configPanel.removeAll();
        IRunConfig runConfig = selection.getRunConfig();
        if (runConfig != null) {
            Pair pair = this._mapRunConfigs.get(runConfig);
            if (pair == null) {
                IRunConfigFactory factory = selection.getParent().getFactory();
                IRunConfigParameters copyParams = this.copyParams(runConfig, factory);
                pair = new Pair((Object)copyParams, (Object)runConfig.makePanel(copyParams, cp -> this.runConfigChanged((IRunConfigParameters)cp)));
                this._mapRunConfigs.put(runConfig, (Pair<IRunConfigParameters, JComponent>)pair);
                EventQueue.invokeLater(() -> this.modifiedConfig(runConfig));
            }
            this._configPanel.add((Component)pair.getSecond(), "Center");
        } else {
            JComponent emptySelection = this.makeEmptyPanel();
            this._configPanel.add((Component)emptySelection, "Center");
            this._configPanel.revalidate();
        }
        this._configPanel.repaint();
    }

    private void runConfigChanged(IRunConfigParameters params) {
        for (Map.Entry<IRunConfig, Pair<IRunConfigParameters, JComponent>> e : this._mapRunConfigs.entrySet()) {
            if (e.getValue().getFirst() != params) continue;
            RunConfigTree tree = ((RunConfigTree)this._tree.getModel().getRoot()).find(e.getKey());
            ((DefaultTreeModel)this._tree.getModel()).nodeChanged(tree);
            break;
        }
    }

    private IRunConfigParameters copyParams(IRunConfig runConfig, IRunConfigFactory factory) {
        Object params;
        if (!this._addedConfigs.contains(runConfig)) {
            params = factory.makeParameters();
            runConfig.getParams().copy(params);
        } else {
            params = runConfig.getParams();
        }
        return params;
    }

    private JComponent makeEmptyPanel() {
        try {
            JLabel label = new JLabel("<html>Use <img src=" + this.getClass().getResource("/images/plus.png").toURI().toURL() + "/> and <img src=" + this.getClass().getResource("/images/minus.png").toURI().toURL() + "/> to add and remove new Run Configurations.  You can also open a file and run or debug it directly to automatically create a new Run Configuration.");
            label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)label, "North");
            return panel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JComponent makeTreePanel() {
        DefaultTreeModel model = new DefaultTreeModel(this.makeRunConfigTree());
        this._tree = new JTree(model);
        this._tree.setBackground(Scheme.active().getWindow());
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.setRowHeight(22);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setVisibleRowCount(20);
        this._tree.setCellRenderer(new RunConfigTreeCellRenderer(this._tree));
        this._tree.addTreeSelectionListener(new SelectionHandler());
        JScrollPane scroller = new JScrollPane(this._tree);
        scroller.setBorder(BorderFactory.createEmptyBorder());
        this.expandAll();
        this.selectMruRunConfig();
        TabPane tabPane = new TabPane(TabPosition.TOP, 7);
        tabPane.addTab("Configurations", null, scroller);
        ToolContainer toolbar = tabPane.getToolContainer();
        this.addTools(toolbar.getToolBar());
        return tabPane;
    }

    private void addTools(ToolBar tb) {
        int i = 0;
        this._btnPlus = this.makeButton(new AddConfigAction());
        tb.add((Component)this._btnPlus, i++);
        this._btnMinus = this.makeButton(new RemoveConfigAction());
        tb.add((Component)this._btnMinus, i);
    }

    private LabToolbarButton makeButton(Action action) {
        LabToolbarButton item = new LabToolbarButton(null, null, 2, 0);
        item.setAction(action);
        return item;
    }

    private void selectMruRunConfig() {
        IRunConfig runConfig = this._experiment.getMruRunConfig();
        if (runConfig == null) {
            return;
        }
        RunConfigTree tree = ((RunConfigTree)this._tree.getModel().getRoot()).find(runConfig);
        if (tree != null) {
            tree.select(this._tree);
        }
    }

    private RunConfigTree makeRunConfigTree() {
        RunConfigTree root = new RunConfigTree();
        RunConfigTree program = new RunConfigTree(ProgramRunConfigFactory.instance(), root);
        root.addChild(program);
        RunConfigTree remote = new RunConfigTree(RemoteRunConfigFactory.instance(), root);
        root.addChild(remote);
        for (IRunConfig rc : this._experiment.getRunConfigs()) {
            if (rc instanceof ProgramRunConfig) {
                program.addChild(new RunConfigTree(rc, program));
                continue;
            }
            if (!(rc instanceof RemoteRunConfig)) continue;
            remote.addChild(new RunConfigTree(rc, remote));
        }
        return root;
    }

    public void expandAll() {
        this.expandAll(0, this._tree.getRowCount());
    }

    void expandAll(int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            this._tree.expandRow(i);
        }
        if (this._tree.getRowCount() != rowCount) {
            this.expandAll(rowCount, this._tree.getRowCount());
        }
    }

    private void save() {
        this._modifiedConfigs.forEach(e -> {
            Pair<IRunConfigParameters, JComponent> pair = this._mapRunConfigs.get(e);
            e.setParams((IRunConfigParameters)pair.getFirst());
        });
        this._addedConfigs.forEach(this._experiment::addRunConfig);
        this._removedConfigs.forEach(this._experiment::removeRunConfig);
        this._experiment.setMruRunConfig(this._runMe);
        this._experiment.save();
    }

    private void close() {
        this.dispose();
    }

    public RunConfigTree getSelectedTree() {
        return (RunConfigTree)this._tree.getLastSelectedPathComponent();
    }

    private void addedConfig(IRunConfig runConfig) {
        this._addedConfigs.add(runConfig);
        this.enableSave();
    }

    private void removedConfig(IRunConfig runConfig) {
        this._modifiedConfigs.remove(runConfig);
        if (!this._addedConfigs.remove(runConfig)) {
            this._removedConfigs.add(runConfig);
        }
        this.enableSave();
    }

    private void modifiedConfig(IRunConfig runConfig) {
        if (!this._addedConfigs.contains(runConfig)) {
            this._modifiedConfigs.add(runConfig);
        }
        this.enableSave();
    }

    private void enableSave() {
        this._btnSave.setEnabled(!this._modifiedConfigs.isEmpty() || !this._removedConfigs.isEmpty() || !this._addedConfigs.isEmpty());
    }

    private class RemoveConfigAction
    extends AbstractAction {
        public RemoveConfigAction() {
            super("Remove", EditorUtilities.loadIcon("images/minus.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                RunConfigTree selection = RunConfigDialog.this.getSelectedTree();
                selection.deleteViaModel(RunConfigDialog.this._tree, selection);
                EventQueue.invokeLater(() -> RunConfigDialog.this.removedConfig(selection.getRunConfig()));
                RunConfigDialog.this.selectMruRunConfig();
                if (RunConfigDialog.this.getSelectedTree() == null) {
                    RunConfigTree tree = (RunConfigTree)RunConfigDialog.this._tree.getModel().getRoot();
                    tree.getChildAt(0).select(RunConfigDialog.this._tree);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            RunConfigTree selection = RunConfigDialog.this.getSelectedTree();
            return selection != null && selection.isTerminal();
        }
    }

    private class AddConfigAction
    extends AbstractAction {
        public AddConfigAction() {
            super("Add", EditorUtilities.loadIcon("images/plus.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                RunConfigTree selection = RunConfigDialog.this.getSelectedTree();
                if (selection.isTerminal()) {
                    selection = selection.getParent();
                }
                IRunConfigFactory factory = selection.getFactory();
                Object params = factory.makeParameters();
                params.setName("Unnamed");
                Object runConfig = factory.newRunConfig(params);
                RunConfigDialog.this.addedConfig(runConfig);
                RunConfigTree newNode = new RunConfigTree((IRunConfig)runConfig, selection);
                selection.insertViaModel(RunConfigDialog.this._tree, newNode, 0);
                newNode.select(RunConfigDialog.this._tree);
            }
        }

        @Override
        public boolean isEnabled() {
            RunConfigTree selection = RunConfigDialog.this.getSelectedTree();
            return selection != null;
        }
    }

    private class SelectionHandler
    implements TreeSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            RunConfigDialog.this.showConfigPanel();
            RunConfigTree selection = RunConfigDialog.this.getSelectedTree();
            RunConfigDialog.this._btnRun.setEnabled(selection != null && selection.getRunConfig() != null && !this.isRunningOrDebugging() && this.canRunOrDebug(selection.getRunConfig()));
            if (selection != null) {
                if (selection.isTerminal()) {
                    selection = selection.getParent();
                }
                ((IEditableLabel)RunConfigDialog.this._configTab.getLabel()).setDisplayName(selection.getFactory().getName());
            }
            EventQueue.invokeLater(() -> {
                RunConfigDialog.this._btnPlus.setEnabled(RunConfigDialog.this._btnPlus.getAction().isEnabled());
                RunConfigDialog.this._btnMinus.setEnabled(RunConfigDialog.this._btnMinus.getAction().isEnabled());
            });
        }

        private boolean isRunningOrDebugging() {
            return LabFrame.instance().getGosuPanel().isRunning() || LabFrame.instance().getGosuPanel().isDebugging();
        }

        private boolean canRunOrDebug(IRunConfig runConfig) {
            return RunConfigDialog.this._runState == RunState.Run ? runConfig.isRunnable() : runConfig.isDebuggable();
        }
    }

    public class RunConfigTreeCellRenderer
    extends AbstractTreeCellRenderer<RunConfigTree> {
        public RunConfigTreeCellRenderer(JTree tree) {
            super(tree);
        }

        @Override
        public void configure() {
            RunConfigTree node = (RunConfigTree)this.getNode();
            if (node == null) {
                return;
            }
            this.setBorder(new EmptyBorder(0, 3, 0, 3));
            IRunConfig runConfig = node.getRunConfig();
            if (runConfig != null) {
                Pair pair = (Pair)RunConfigDialog.this._mapRunConfigs.get(runConfig);
                String name = pair != null ? ((IRunConfigParameters)pair.getFirst()).getName() : runConfig.getName();
                if (RunConfigDialog.this._experiment.getMruRunConfig() != null && RunConfigDialog.this._experiment.getMruRunConfig().equals(runConfig)) {
                    this.setText(name);
                } else {
                    this.setText("<html><font color=#808080>" + name + "</font>");
                }
            } else {
                IRunConfigFactory factory = node.getFactory();
                if (factory != null) {
                    this.setText("<html><b>" + factory.getName() + "</b>");
                }
            }
            this.setIcon(node.getIcon());
        }
    }
}

