/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.IContextMenuHandler;
import editor.LabFrame;
import editor.search.SearchTree;
import editor.util.SmartMenuItem;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class SearchTreeContextMenu
implements IContextMenuHandler<SearchTree> {
    @Override
    public JPopupMenu getContextMenu(SearchTree search) {
        JPopupMenu menu = new JPopupMenu();
        if (((SearchTree.SearchTreeNode)search.getNode()).hasTarget()) {
            menu.add(new SmartMenuItem(new OpenAction(search)));
            menu.add(new JSeparator());
        }
        menu.add(new SmartMenuItem(new ClipCopyAction(search.getText())));
        return menu;
    }

    @Override
    public void displayContextMenu(SearchTree search, int x, int y, Component eventSource) {
        search.getTree().requestFocus();
        this.getContextMenu(search).show(search.getTree(), x, y);
    }

    class ClipCopyAction
    extends AbstractAction
    implements ClipboardOwner {
        String _search;

        public ClipCopyAction(String search) {
            super("Copy");
            this.putValue("MnemonicKey", new Integer(67));
            this._search = search;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = LabFrame.instance().getGosuPanel().getClipboard();
            clipboard.setContents(new StringSelection(this._search), this);
        }
    }

    class OpenAction
    extends AbstractAction
    implements ClipboardOwner {
        SearchTree _search;

        public OpenAction(SearchTree search) {
            super("Open");
            this.putValue("MnemonicKey", new Integer(79));
            this._search = search;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((SearchTree.SearchTreeNode)this._search.getNode()).jumpToTarget();
        }
    }
}

