/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.LabButtonUI;
import editor.Scheme;
import editor.actions.UpdateNotifier;
import gw.util.GosuObjectUtil;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class LabButton
extends JButton {
    public LabButton(String text, Icon icon) {
        super(text, icon);
        this.setUI(LabButtonUI.createUI(this));
        this.addMouseListener(this.createMouseListener());
    }

    public LabButton(Action action) {
        this();
        EventQueue.invokeLater(() -> this.setAction(action));
        UpdateNotifier.instance().addActionComponent(this);
    }

    public LabButton(Icon icon) {
        this(null, icon);
    }

    public LabButton(String text) {
        this(text, null);
    }

    public LabButton() {
        this(null, null);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setBackground(this.getParent().getBackground());
    }

    protected MouseListener createMouseListener() {
        return new MouseAdapter(){
            Color _bkColor;

            @Override
            public void mouseEntered(MouseEvent e) {
                if (LabButton.this.isEnabled()) {
                    this._bkColor = LabButton.this.getBackground();
                    if (LabButton.this.getModel().isArmed()) {
                        LabButton.this.setBackground(Scheme.active().getXpHighlightSelectedColor());
                    } else {
                        LabButton.this.setBackground(Scheme.active().getXpHighlightColor());
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LabButton.this.setBackground(this._bkColor != null ? this._bkColor : LabButton.this.getParent().getBackground());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                LabButton.this.setBackground(Scheme.active().getXpHighlightSelectedColor());
            }
        };
    }

    @Override
    public void setAction(Action a) {
        super.setAction(a);
        UpdateNotifier.instance().addActionComponent(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        JComponent separator = (JComponent)this.getClientProperty("_separatorComp");
        if (separator != null) {
            separator.setVisible(bVisible);
        }
    }

    @Override
    public String getToolTipText() {
        if (this.getAction() != null) {
            String value;
            String tip = GosuObjectUtil.toString((Object)this.getAction().getValue("ShortDescription"));
            if (tip == null || tip.isEmpty()) {
                tip = GosuObjectUtil.toString((Object)this.getAction().getValue("Name"));
            }
            if ((value = (String)this.getAction().getValue("AcceleratorKey")) != null && !value.isEmpty()) {
                tip = tip + " (" + value + ")";
            }
            return tip;
        }
        return super.getToolTipText();
    }
}

