/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.CopyBuffer;
import editor.EditorHost;
import editor.EditorHostTextPane;
import editor.GosuEditor;
import editor.PasteBufferSelectDialog;
import editor.util.EditorUtilities;
import editor.util.IReplaceWordCallback;
import gw.util.GosuObjectUtil;
import gw.util.GosuStringUtil;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;

public class TextComponentUtil {
    private static final Set<String> SIGNIFICANT_CHARS = new HashSet<String>(Arrays.asList(".", "#", ";", ")", "(", "\""));
    private static final String SHOW_PASTE_BUFFER = "show-paste-buffer";

    public static int findCharacterPositionOnLine(int startPosition, String string, char charToFind, Direction d) {
        int i = startPosition;
        char curr = string.charAt(i);
        while (curr != charToFind) {
            if (curr == '\n' && charToFind != '\n') {
                return -1;
            }
            if (i < 0 || i >= string.length()) {
                return -1;
            }
            curr = string.charAt(i += d == Direction.FORWARD ? 1 : -1);
        }
        return i;
    }

    public static String getWordAtCaret(JTextComponent editor) {
        try {
            int iCaretPos = editor.getCaretPosition();
            int iStart = TextComponentUtil.getWordStart(editor, iCaretPos);
            int iEnd = TextComponentUtil.getWordEnd(editor, iCaretPos);
            return editor.getText(iStart, iEnd - iStart);
        }
        catch (BadLocationException e) {
            return TextComponentUtil.getPartialWordBeforeCaret(editor);
        }
    }

    public static String getPartialWordBeforeCaret(JTextComponent editor) {
        return TextComponentUtil.getPartialWordBeforePos(editor, editor.getCaretPosition());
    }

    public static String getPartialWordBeforePos(JTextComponent editor, int iPos) {
        try {
            int iNonWhitespace = TextComponentUtil.findNonWhitespacePositionBefore(editor.getText(), iPos - 1);
            int iStart = TextComponentUtil.getWordStart(editor, iNonWhitespace);
            return editor.getText(iStart, iPos - iStart).trim();
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public static Dimension getWordDimensionAtCaret(JTextComponent editor) {
        try {
            int iCaretPos = editor.getCaretPosition();
            int iStart = TextComponentUtil.getWordStart(editor, iCaretPos);
            int iEnd = TextComponentUtil.getWordEnd(editor, iCaretPos);
            editor.getText(iStart, iEnd - iStart);
            return new Dimension(iStart, iEnd);
        }
        catch (BadLocationException e) {
            return TextComponentUtil.getWordDimensionBeforeCaret(editor);
        }
    }

    public static Dimension getWordDimensionBeforeCaret(JTextComponent editor) {
        try {
            int iEnd = editor.getCaretPosition();
            int iStart = TextComponentUtil.getPreviousWord(editor, iEnd);
            editor.getText(iStart, iEnd - iStart);
            return new Dimension(iStart, iEnd);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public static Dimension getMemberDimensionAtCaret(JTextComponent editor) {
        String strPath = TextComponentUtil.getWordAtCaret(editor);
        if (strPath == null || strPath.length() == 0) {
            return null;
        }
        Dimension dimWordAtCaret = TextComponentUtil.getWordDimensionAtCaret(editor);
        int iCaretPos = editor.getCaretPosition();
        String strFirstPart = strPath.substring(0, iCaretPos - dimWordAtCaret.width);
        int iFirstDot = strFirstPart.lastIndexOf(46);
        iFirstDot = iFirstDot < 0 ? 0 : iFirstDot + 1;
        int iLastDot = strPath.indexOf(46, iCaretPos - dimWordAtCaret.width);
        iLastDot = iLastDot < 0 ? strPath.length() : iLastDot;
        dimWordAtCaret.height = dimWordAtCaret.width + iLastDot;
        dimWordAtCaret.width += iFirstDot;
        return dimWordAtCaret;
    }

    public static String getMemberAtCaret(JTextComponent editor) {
        String strPath = TextComponentUtil.getWordAtCaret(editor);
        if (strPath == null || strPath.length() == 0) {
            return null;
        }
        Dimension dimWordAtCaret = TextComponentUtil.getWordDimensionAtCaret(editor);
        int iCaretPos = editor.getCaretPosition();
        String strFirstPart = strPath.substring(0, iCaretPos - dimWordAtCaret.width);
        int iFirstDot = strFirstPart.lastIndexOf(46);
        iFirstDot = iFirstDot < 0 ? 0 : iFirstDot + 1;
        int iLastDot = strPath.indexOf(46, iCaretPos - dimWordAtCaret.width);
        iLastDot = iLastDot < 0 ? strPath.length() : iLastDot;
        return strPath.substring(iFirstDot, iLastDot);
    }

    public static void selectWordAtCaret(JTextComponent editor) {
        int iStart = 0;
        int iEnd = 0;
        try {
            int iCaretPos = editor.getCaretPosition();
            iStart = TextComponentUtil.getWordStart(editor, iCaretPos);
            iEnd = TextComponentUtil.getWordEnd(editor, iCaretPos);
        }
        catch (BadLocationException e) {
            try {
                iEnd = editor.getCaretPosition();
                iStart = TextComponentUtil.getPreviousWord(editor, iEnd);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (iStart < iEnd) {
            editor.select(iStart, iEnd);
        }
    }

    public static void replaceWordAtClosestDot(JTextComponent editor, String strText) {
        Dimension dim = TextComponentUtil.getWordDimensionAtCaret(editor);
        try {
            String strReplace = editor.getText(dim.width, dim.height - dim.width);
            if (strReplace == null || strReplace.length() > 0 && !Character.isJavaIdentifierStart(strReplace.charAt(0))) {
                dim = TextComponentUtil.getWordDimensionBeforeCaret(editor);
            }
        }
        catch (BadLocationException e) {
            dim = TextComponentUtil.getWordDimensionBeforeCaret(editor);
        }
        if (dim == null) {
            try {
                int iLength = editor.getDocument().getLength();
                editor.getDocument().insertString(iLength - 1, strText, null);
                return;
            }
            catch (BadLocationException be2) {
                EditorUtilities.handleUncaughtException("", be2);
                return;
            }
        }
        try {
            String strWholePath = editor.getText(dim.width, dim.height - dim.width);
            if (strWholePath != null && strWholePath.length() > 0) {
                int iDotIndex = strWholePath.lastIndexOf(46, editor.getCaretPosition() - dim.width - 1);
                if (iDotIndex < 0) {
                    iDotIndex = strWholePath.lastIndexOf(35, editor.getCaretPosition() - dim.width - 1);
                }
                if (iDotIndex < 0 && dim.width != 0 && (editor.getText(dim.width - 1, 1).equals(".") || editor.getText(dim.width - 1, 1).equals("#"))) {
                    --dim.width;
                    strWholePath = editor.getText(dim.width, dim.height - dim.width);
                    iDotIndex = 0;
                }
                if (iDotIndex >= 0 && iDotIndex != strWholePath.length() - 1) {
                    int nextDotIndex = strWholePath.indexOf(46, iDotIndex + 1);
                    if (nextDotIndex < 0 && (nextDotIndex = strWholePath.indexOf(35, iDotIndex + 1)) < 0) {
                        nextDotIndex = dim.height - dim.width;
                    }
                    editor.select(dim.width + iDotIndex + 1, dim.width + nextDotIndex);
                }
            }
            strText = strText == null ? "" : strText;
            int initialSelectionStart = editor.getSelectionStart();
            editor.replaceSelection(strText);
            EditorUtilities.settleEventQueue();
            TextComponentUtil.selectFirstArg(strText, initialSelectionStart, editor);
        }
        catch (BadLocationException be) {
            EditorUtilities.handleUncaughtException("", be);
        }
    }

    private static void selectFirstArg(String strText, int initialSelectionStart, JTextComponent editor) throws BadLocationException {
        int firstParen = strText.indexOf("(");
        if (firstParen >= 0 && firstParen < strText.indexOf(")")) {
            int startPos = initialSelectionStart + firstParen + 1;
            editor.setCaretPosition(startPos);
        }
    }

    public static int replaceWordAtCaret(JTextComponent editor, String strText) {
        TextComponentUtil.selectWordAtCaret(editor);
        int selectionStart = editor.getSelectionStart();
        editor.replaceSelection(strText == null ? "" : strText);
        return selectionStart;
    }

    public static int replaceWordBeforeCaret(JTextComponent editor, String strText) {
        int iStart = 0;
        int iEnd = 0;
        try {
            iEnd = editor.getCaretPosition();
            iStart = TextComponentUtil.getPreviousWord(editor, iEnd);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (iStart < iEnd) {
            editor.select(iStart, iEnd);
        }
        int initialSelectionStart = editor.getSelectionStart();
        editor.replaceSelection(strText == null ? "" : strText);
        return initialSelectionStart;
    }

    public static void replaceWordAtCaretNice(JTextComponent editor, String strText) {
        String strWordAtCaret = TextComponentUtil.getWordAtCaret(editor);
        if (strWordAtCaret != null && strWordAtCaret.length() > 0 && Character.isLetterOrDigit(strWordAtCaret.charAt(0))) {
            TextComponentUtil.replaceWordAtCaret(editor, strText);
            return;
        }
        String strWordBeforeCaret = TextComponentUtil.getPartialWordBeforeCaret(editor);
        if (strWordBeforeCaret != null && strWordBeforeCaret.length() > 0 && Character.isLetterOrDigit(strWordBeforeCaret.charAt(0))) {
            TextComponentUtil.replaceWordBeforeCaret(editor, strText);
            return;
        }
        editor.replaceSelection(strText == null ? "" : strText);
    }

    public static void replaceWordAtCaretDynamic(JTextComponent editor, String strText, IReplaceWordCallback replaceWordCallback, boolean selectFirstArg, boolean replaceWholeWord) {
        TextComponentUtil.performCompoundUndableEdit(editor, () -> {
            int initialSelectionStart;
            String strWordAtCaret = TextComponentUtil.getWordAtCaret(editor);
            int caretPosition = editor.getCaretPosition();
            if (strWordAtCaret != null && strWordAtCaret.length() > 0 && replaceWordCallback.shouldReplace(strWordAtCaret)) {
                String text;
                int wordEnd;
                try {
                    initialSelectionStart = TextComponentUtil.getWordStart(editor, caretPosition);
                    wordEnd = replaceWholeWord ? TextComponentUtil.getWordEnd(editor, initialSelectionStart) : caretPosition;
                }
                catch (BadLocationException e) {
                    initialSelectionStart = caretPosition;
                    try {
                        wordEnd = replaceWholeWord ? TextComponentUtil.getWordEnd(editor, initialSelectionStart) : caretPosition;
                    }
                    catch (BadLocationException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                editor.setSelectionStart(initialSelectionStart);
                editor.setSelectionEnd(wordEnd);
                String insertText = strText;
                if (replaceWholeWord && insertText.endsWith("()") && (text = editor.getText()).length() > wordEnd && text.charAt(wordEnd) == '(') {
                    insertText = insertText.substring(0, insertText.length() - 2);
                }
                editor.replaceSelection(insertText);
            } else {
                String strWordBeforeCaret = TextComponentUtil.getPartialWordBeforeCaret(editor);
                if (strWordBeforeCaret != null && strWordBeforeCaret.length() > 0 && replaceWordCallback.shouldReplace(strWordBeforeCaret)) {
                    if (strWordBeforeCaret.endsWith(" ")) {
                        initialSelectionStart = caretPosition;
                        try {
                            editor.getDocument().insertString(initialSelectionStart, strText, null);
                        }
                        catch (BadLocationException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        initialSelectionStart = TextComponentUtil.replaceWordBeforeCaret(editor, strText);
                    }
                } else {
                    String strSeparationSpace = strWordAtCaret != null && strWordAtCaret.length() > 0 && Character.isJavaIdentifierPart(strWordAtCaret.charAt(0)) ? " " : "";
                    initialSelectionStart = editor.getSelectionStart();
                    editor.replaceSelection(strText == null ? "" : strText + strSeparationSpace);
                }
            }
            if (selectFirstArg && strText != null) {
                EditorUtilities.settleEventQueue();
                try {
                    EditorHost hostPane;
                    TextComponentUtil.selectFirstArg(strText, initialSelectionStart, editor);
                    if (editor instanceof EditorHostTextPane && (hostPane = ((EditorHostTextPane)editor).getEditor()) instanceof GosuEditor) {
                        EventQueue.invokeLater(() -> ((GosuEditor)hostPane).displayParameterInfoPopup(editor.getCaretPosition()));
                    }
                }
                catch (BadLocationException e) {
                    EditorUtilities.handleUncaughtException(e);
                }
            }
        });
    }

    public static void replaceWordAtCaretDynamicAndRemoveEmptyParens(JTextComponent editor, String strText, IReplaceWordCallback replaceWordCallback, boolean selectFirstArg, boolean replaceWholeWord) {
        TextComponentUtil.performCompoundUndableEdit(editor, () -> {
            try {
                int caret = editor.getCaretPosition();
                if (editor.getDocument().getLength() >= caret + 2 && editor.getText(caret, 2).equals("()")) {
                    editor.setSelectionStart(caret);
                    editor.setSelectionEnd(caret + 2);
                    editor.replaceSelection("");
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            TextComponentUtil.replaceWordAtCaretDynamic(editor, strText, replaceWordCallback, selectFirstArg, replaceWholeWord);
        });
    }

    private static void performCompoundUndableEdit(JTextComponent editor, Runnable edit) {
        CompoundEdit undoAtom = null;
        if (editor instanceof EditorHostTextPane) {
            undoAtom = ((EditorHostTextPane)editor).getEditor().getUndoManager().beginUndoAtom("Duplicate Line");
        }
        try {
            edit.run();
        }
        finally {
            if (undoAtom != null) {
                ((EditorHostTextPane)editor).getEditor().getUndoManager().endUndoAtom(undoAtom);
            }
        }
    }

    public static int getWordStart(JTextComponent editor, int iOffset) throws BadLocationException {
        int iStart;
        String text = editor.getText();
        for (iStart = iOffset = TextComponentUtil.maybeAdjustOffsetToNextWord(text, iOffset); iStart > 0 && Character.isJavaIdentifierPart(text.charAt(iStart)); --iStart) {
        }
        if (iStart != iOffset) {
            ++iStart;
        }
        return iStart;
    }

    public static int getWordEnd(JTextComponent editor, int iOffset) throws BadLocationException {
        int iEnd;
        String text = editor.getText();
        for (iEnd = iOffset = TextComponentUtil.maybeAdjustOffsetToNextWord(text, iOffset); iEnd < text.length() && Character.isJavaIdentifierPart(text.charAt(iEnd)); ++iEnd) {
        }
        if (iEnd == iOffset && !Character.isWhitespace(text.charAt(iEnd))) {
            ++iEnd;
        }
        return iEnd;
    }

    private static int maybeAdjustOffsetToNextWord(String text, int iOffset) throws BadLocationException {
        if (text.length() < iOffset) {
            throw new BadLocationException("Index out of bounds. Offset: " + iOffset + "  Length: " + text.length(), iOffset);
        }
        if (iOffset > 0 && !text.isEmpty() && (text.length() == iOffset || Character.isWhitespace(text.charAt(iOffset)))) {
            if (Character.isWhitespace(text.charAt(iOffset - 1))) {
                while (iOffset < text.length()) {
                    if (!Character.isWhitespace(text.charAt(iOffset))) {
                        return iOffset;
                    }
                    ++iOffset;
                }
            }
            --iOffset;
        }
        return iOffset;
    }

    private static int getPreviousWord(JTextComponent editor, int iOffset) throws BadLocationException {
        String text = editor.getText();
        int iStart = TextComponentUtil.getWordStart(editor, iOffset);
        for (iOffset = iStart - 1; iOffset >= 0 && Character.isWhitespace(text.charAt(iOffset)); --iOffset) {
        }
        if (iOffset < 0) {
            return iStart;
        }
        return TextComponentUtil.getWordStart(editor, iOffset);
    }

    public static int adjustForLineComment(JTextComponent editor, int iStart) throws BadLocationException {
        Document doc = editor.getDocument();
        Element root = doc.getDefaultRootElement();
        Element line = root.getElement(root.getElementIndex(iStart));
        int iLineOffset = line.getStartOffset();
        int iLength = iStart - iLineOffset;
        if (iLength <= 0) {
            return iStart;
        }
        String strLine = doc.getText(iLineOffset, iLength);
        if (strLine.contains("//")) {
            return iLineOffset;
        }
        return iStart;
    }

    public static boolean isNonWhitespaceBetween(JTextComponent editor, int iStart, int iEnd) {
        if (iStart > iEnd) {
            int iTemp = iEnd;
            iEnd = iStart;
            iStart = iTemp;
        }
        try {
            String strText = editor.getText(iStart, iEnd - iStart);
            return strText.trim().length() > 0;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static boolean isAdditionalSymbol(String currWord, String strPossibleAdditionalSymbol, String symbol) {
        return GosuObjectUtil.equals((Object)currWord, (Object)symbol) && !GosuStringUtil.isEmpty((String)strPossibleAdditionalSymbol) && Character.isLetterOrDigit(strPossibleAdditionalSymbol.charAt(0)) || GosuObjectUtil.equals((Object)strPossibleAdditionalSymbol, (Object)symbol) && !GosuStringUtil.isEmpty((String)currWord) && Character.isLetterOrDigit(currWord.charAt(0));
    }

    public static int[] getLineStartAndEndPositions(String text, int initialCaretPosition) {
        return new int[]{TextComponentUtil.getLineStart(text, initialCaretPosition), TextComponentUtil.getLineEnd(text, initialCaretPosition)};
    }

    public static int getLineStart(String text, int initialCaretPosition) {
        int pos;
        for (pos = Math.min(Math.max(0, initialCaretPosition), text.length()); pos > 0 && text.charAt(pos - 1) != '\n'; --pos) {
        }
        return pos;
    }

    public static int getLineEnd(String text, int initialCaretPosition) {
        int pos;
        for (pos = Math.min(Math.max(0, initialCaretPosition), text.length()); pos < text.length() && text.charAt(pos) != '\n'; ++pos) {
        }
        return pos;
    }

    public static void deleteWordAtCaret(JTextComponent editor) throws BadLocationException {
        int caretPosition = editor.getCaretPosition();
        String s = TextComponentUtil.findPreviousTextChunk(caretPosition, editor.getText());
        editor.getDocument().remove(caretPosition - s.length(), s.length());
    }

    protected static String findPreviousTextChunk(int startPosition, String text) {
        if (startPosition <= 0) {
            return "";
        }
        if (startPosition > text.length()) {
            return "";
        }
        boolean foundNonWhitespace = false;
        boolean foundNewline = false;
        int endPosition = startPosition;
        while (startPosition > 0) {
            String s = text.substring(startPosition - 1, startPosition);
            if (SIGNIFICANT_CHARS.contains(s)) {
                if (startPosition != endPosition && foundNonWhitespace) break;
                --startPosition;
                break;
            }
            if (!GosuStringUtil.isWhitespace((String)s)) {
                foundNonWhitespace = true;
                if (foundNewline) {
                    break;
                }
            } else {
                if (foundNonWhitespace) break;
                if ("\n".equals(s)) {
                    foundNewline = true;
                }
            }
            --startPosition;
        }
        return text.substring(startPosition, endPosition);
    }

    public static int getLineAtPosition(JTextComponent editor, int position) {
        if (position <= 0) {
            return 1;
        }
        String s = editor.getText();
        if (position > s.length()) {
            position = s.length();
        }
        try {
            return GosuStringUtil.countMatches((String)editor.getText(0, position), (String)"\n") + 1;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getColumnAtPosition(JTextComponent editor, int caretPosition) {
        if (editor.getDocument().getLength() == 0) {
            return 0;
        }
        if (caretPosition >= editor.getDocument().getLength() - 1) {
            caretPosition = editor.getDocument().getLength() - 1;
        }
        while (caretPosition < 0) {
            try {
                String s = editor.getDocument().getText(caretPosition, 1);
                if ("\n".equals(s)) break;
                --caretPosition;
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        return caretPosition;
    }

    public static int getWhiteSpaceLineStartBefore(String script, int start) {
        int nextLineEnd;
        int previousLineStart;
        boolean whitespace;
        int startLine = TextComponentUtil.getLineStart(script, start);
        if (startLine > 0 && (whitespace = GosuStringUtil.isWhitespace((String)script.substring(previousLineStart = TextComponentUtil.getLineStart(script, nextLineEnd = startLine - 1), nextLineEnd)))) {
            return previousLineStart;
        }
        return -1;
    }

    public static int getWhiteSpaceLineStartAfter(String script, int end) {
        int nextLineEnd;
        int nextLineStart;
        boolean whitespace;
        int endLine = TextComponentUtil.getLineEnd(script, end);
        if (endLine < script.length() - 1 && (whitespace = GosuStringUtil.isWhitespace((String)script.substring(nextLineStart = endLine + 1, nextLineEnd = TextComponentUtil.getLineEnd(script, nextLineStart))))) {
            return nextLineStart;
        }
        return -1;
    }

    public static int getWhiteSpaceOrCommentLineStartBefore(String script, int start) {
        int startLine = TextComponentUtil.getLineStart(script, start);
        if (startLine > 0) {
            boolean whitespace;
            int nextLineEnd = startLine - 1;
            int previousLineStart = TextComponentUtil.getLineStart(script, nextLineEnd);
            String line = script.substring(previousLineStart, nextLineEnd);
            boolean bl = whitespace = GosuStringUtil.isWhitespace((String)line) || line.trim().startsWith("//");
            if (whitespace) {
                return previousLineStart;
            }
        }
        return -1;
    }

    public static int getWhiteSpaceOrCommentLineStartAfter(String script, int end) {
        int endLine = TextComponentUtil.getLineEnd(script, end);
        if (endLine < script.length() - 1) {
            boolean whitespace;
            int nextLineStart = endLine + 1;
            int nextLineEnd = TextComponentUtil.getLineEnd(script, nextLineStart);
            String line = script.substring(nextLineStart, nextLineEnd);
            boolean bl = whitespace = GosuStringUtil.isWhitespace((String)line) || line.trim().startsWith("//");
            if (whitespace) {
                return nextLineStart;
            }
        }
        return -1;
    }

    public static int getDeepestWhiteSpaceLineStartAfter(String script, int offset) {
        if (offset < 0) {
            return offset;
        }
        int i = offset;
        int lineStartAfter;
        while ((lineStartAfter = TextComponentUtil.getWhiteSpaceLineStartAfter(script, i)) != -1) {
            i = lineStartAfter;
        }
        return i;
    }

    public static int findNonWhitespacePositionAfter(String script, int position) {
        if (position < 0) {
            return position;
        }
        while (position < script.length() && Character.isWhitespace(script.charAt(position))) {
            ++position;
        }
        return position;
    }

    public static int findNonWhitespacePositionBefore(String script, int position) {
        if (position > script.length() - 1) {
            return position;
        }
        while (position > 0 && Character.isWhitespace(script.charAt(position))) {
            --position;
        }
        return position;
    }

    public static int getNextWordPostition(int pos, String source, boolean consumeWhitespaceFirst) {
        if (pos < source.length()) {
            if (consumeWhitespaceFirst) {
                while (pos < source.length() && Character.isWhitespace(source.charAt(pos)) && source.charAt(pos) != '\n') {
                    ++pos;
                }
            }
            int initialCharClass = TextComponentUtil.getCharClass(source.charAt(pos));
            while (pos < source.length() && TextComponentUtil.getCharClass(source.charAt(pos)) == initialCharClass) {
                ++pos;
            }
            if (!consumeWhitespaceFirst) {
                while (pos < source.length() && Character.isWhitespace(source.charAt(pos)) && source.charAt(pos) != '\n') {
                    ++pos;
                }
            }
            return pos;
        }
        return -1;
    }

    private static int getCharClass(char c) {
        if (GosuStringUtil.isAsciiAlphanumeric((char)c)) {
            return 0;
        }
        if (Character.isWhitespace(c)) {
            return 1;
        }
        return 2;
    }

    public static void fixTextComponentKeyMap(JTextComponent editor) {
        KeyMapController keyMapController = new KeyMapController(editor);
        keyMapController.bindKeyToAction(EditorUtilities.CONTROL_KEY_NAME + " X", new CustomCutAction());
        keyMapController.bindKeyToAction(EditorUtilities.CONTROL_KEY_NAME + " C", new CustomCopyAction());
        keyMapController.bindKeyToAction(36, "caret-begin-line", (AbstractAction)new CustomHomeAction());
        keyMapController.bindKeyToAction(39, EditorUtilities.CONTROL_KEY_MASK, "caret-next-word", new JumpRightAction());
        keyMapController.bindKeyToAction(KeyStroke.getKeyStroke(39, EditorUtilities.CONTROL_KEY_MASK | 0x40), "selection-next-word", (AbstractAction)new SelectRightAction());
        keyMapController.bindKeyToAction(KeyStroke.getKeyStroke(37, EditorUtilities.CONTROL_KEY_MASK), "caret-previous-word", (AbstractAction)new JumpLeftAction());
        keyMapController.bindKeyToAction(KeyStroke.getKeyStroke(37, EditorUtilities.CONTROL_KEY_MASK | 0x40), "selection-previous-word", (AbstractAction)new SelectLeftAction());
        keyMapController.bindKeyToAction(KeyStroke.getKeyStroke(86, EditorUtilities.CONTROL_KEY_MASK | 0x40), SHOW_PASTE_BUFFER, (AbstractAction)new ShowPasteBufferAction());
    }

    public static void expandSelectionIfNeeded(JTextComponent editor) {
        if (GosuStringUtil.isEmpty((String)editor.getSelectedText())) {
            TextComponentUtil.selectLineAtCaret(editor);
        }
    }

    public static void selectLineAtCaret(JTextComponent editor) {
        int lineStart = TextComponentUtil.getLineStart(editor.getText(), editor.getCaretPosition());
        int lineEnd = TextComponentUtil.getLineEnd(editor.getText(), editor.getCaretPosition());
        if (lineEnd < editor.getText().length()) {
            ++lineEnd;
        }
        editor.getCaret().setDot(lineEnd);
        editor.getCaret().moveDot(lineStart);
    }

    public static void selectRight(JTextComponent editor) {
        String source = editor.getText();
        int pos = editor.getCaretPosition();
        if ((pos = TextComponentUtil.getNextWordPostition(pos, source, false)) != -1) {
            editor.getCaret().moveDot(pos);
        }
    }

    public static void jumpRight(JTextComponent editor) {
        String source = editor.getText();
        int pos = editor.getCaretPosition();
        if ((pos = TextComponentUtil.getNextWordPostition(pos, source, false)) != -1) {
            editor.setCaretPosition(pos);
        }
    }

    public static void jumpLeft(JTextComponent editor) {
        String source = GosuStringUtil.reverse((String)editor.getText());
        int pos = source.length() - editor.getCaretPosition();
        if ((pos = TextComponentUtil.getNextWordPostition(pos, source, true)) != -1) {
            editor.setCaretPosition(source.length() - pos);
        }
    }

    public static void selectLeft(JTextComponent editor) {
        String source = GosuStringUtil.reverse((String)editor.getText());
        int pos = source.length() - editor.getCaretPosition();
        if ((pos = TextComponentUtil.getNextWordPostition(pos, source, true)) != -1) {
            editor.getCaret().moveDot(source.length() - pos);
        }
    }

    public static void handleHomeKey(JTextComponent editor) {
        int dot = editor.getCaretPosition();
        try {
            int start;
            String text = editor.getText();
            int initialCaretPosition = editor.getCaretPosition();
            int lineStart = TextComponentUtil.getLineStart(text, initialCaretPosition);
            int lineEnd = TextComponentUtil.getLineEnd(text, initialCaretPosition);
            for (start = lineStart; GosuStringUtil.isWhitespace((String)editor.getDocument().getText(start, 1)) && start < lineEnd; ++start) {
            }
            if (dot == start) {
                editor.setCaretPosition(lineStart);
            } else {
                editor.setCaretPosition(start);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void showPasteBufferDialogForComponent(JTextComponent component) {
        PasteBufferSelectDialog dialog = new PasteBufferSelectDialog(component);
        dialog.setVisible(true);
    }

    public static void unindentLineAtCaret(JTextComponent editor) throws BadLocationException {
        int start = editor.getSelectionStart();
        int end = editor.getSelectionEnd();
        String text = editor.getText();
        if (start != end && end > 0 && text.charAt(end - 1) == '\n') {
            --end;
        }
        int lineStart = TextComponentUtil.getLineStart(text, start);
        int lineEnd = TextComponentUtil.getLineEnd(text, end);
        editor.setSelectionStart(lineStart);
        editor.setSelectionEnd(lineEnd);
        Object[] selectedLines = text.substring(lineStart, lineEnd).split("\n");
        int originalLinePosition = lineStart;
        for (int i = 0; i < selectedLines.length; ++i) {
            int originalLength = selectedLines[i].length();
            for (int tab = 2; tab > 0 && ((String)selectedLines[i]).length() > 0 && Character.isWhitespace(((String)selectedLines[i]).charAt(0)); --tab) {
                selectedLines[i] = ((String)selectedLines[i]).substring(1);
                if (originalLinePosition < start) {
                    --start;
                }
                if (originalLinePosition >= end) continue;
                --end;
            }
            originalLinePosition += originalLength + 1;
        }
        editor.replaceSelection(GosuStringUtil.join((Object[])selectedLines, (char)'\n'));
        editor.setSelectionStart(start);
        editor.setSelectionEnd(end);
    }

    public static String getIdentifierAtCaret(EditorHostTextPane editor) {
        String wordAtCaret = TextComponentUtil.getWordAtCaret(editor);
        if (TextComponentUtil.isValidIdentifier(wordAtCaret, false)) {
            return wordAtCaret;
        }
        String wordBeforeCaret = TextComponentUtil.getPartialWordBeforeCaret(editor);
        if (TextComponentUtil.isValidIdentifier(wordBeforeCaret, false)) {
            return wordBeforeCaret;
        }
        return "";
    }

    public static boolean isValidIdentifier(CharSequence seqId, boolean acceptDot) {
        if (seqId.length() == 0 || !Character.isJavaIdentifierStart(seqId.charAt(0))) {
            return false;
        }
        int iLen = seqId.length();
        for (int i = 1; i < iLen; ++i) {
            if (acceptDot && (seqId.charAt(i) == '.' || seqId.charAt(i) == '#') || Character.isJavaIdentifierPart(seqId.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String makeValidIdentifier(String str, boolean acceptDot, boolean bAcceptUnderscore) {
        StringBuilder rtn = new StringBuilder(str);
        while (rtn.length() > 0 && (!Character.isJavaIdentifierStart(rtn.charAt(0)) || !bAcceptUnderscore && rtn.charAt(0) == '_')) {
            rtn.deleteCharAt(0);
        }
        int i = 1;
        while (i < rtn.length()) {
            char c = rtn.charAt(i);
            if (acceptDot && (c == '.' || c == '#')) {
                ++i;
                continue;
            }
            if (!Character.isJavaIdentifierPart(c) || !bAcceptUnderscore && c == '_') {
                rtn.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return rtn.toString();
    }

    private static class KeyMapController {
        private JTextComponent _textComponent;

        public KeyMapController(JTextComponent textComponent) {
            this._textComponent = textComponent;
        }

        public void bindKeyToAction(String keystrokeDescription, AbstractAction action) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(keystrokeDescription);
            Object actionMapKey = this.getActionMapKey(keyStroke);
            this.bindActionKeyToAction(actionMapKey, action);
        }

        public void bindKeyToAction(KeyStroke keyStroke, String actionMapKey, AbstractAction action) {
            this.bindKeyStrokeToActionMapKey(keyStroke, actionMapKey);
            this.bindActionKeyToAction(actionMapKey, action);
        }

        public void bindActionKeyToAction(Object actionMapKey, AbstractAction action) {
            this._textComponent.getActionMap().put(actionMapKey, action);
        }

        private Object getActionMapKey(KeyStroke keyStroke) {
            return this._textComponent.getInputMap().get(keyStroke);
        }

        private void bindKeyStrokeToActionMapKey(KeyStroke keyStroke, String actionMapKey) {
            this._textComponent.getInputMap().put(keyStroke, actionMapKey);
        }

        public void bindKeyToAction(int keyCode, String actionMapKey, AbstractAction action) {
            this.bindKeyToAction(keyCode, 0, actionMapKey, action);
        }

        public void bindKeyToAction(int keyCode, int keyMask, String actionMapKey, AbstractAction action) {
            this.bindKeyToAction(KeyStroke.getKeyStroke(keyCode, keyMask), actionMapKey, action);
        }

        private int flipControlToMeta(int keyMask) {
            if ((keyMask & EditorUtilities.CONTROL_KEY_MASK) == 0) {
                return keyMask;
            }
            return keyMask & ~EditorUtilities.CONTROL_KEY_MASK | 0x100;
        }

        private String flipControlToMeta(String keyStrokeDescription) {
            return GosuStringUtil.replace((String)keyStrokeDescription, (String)"control", (String)"meta");
        }
    }

    private static class ShowPasteBufferAction
    extends AbstractAction {
        public ShowPasteBufferAction() {
            super(TextComponentUtil.SHOW_PASTE_BUFFER);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = (JTextComponent)e.getSource();
            TextComponentUtil.showPasteBufferDialogForComponent(component);
        }
    }

    private static class SelectLeftAction
    extends AbstractAction {
        public SelectLeftAction() {
            super("selection-previous-word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentUtil.selectLeft((JTextComponent)e.getSource());
        }
    }

    private static class JumpLeftAction
    extends AbstractAction {
        public JumpLeftAction() {
            super("caret-previous-word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentUtil.jumpLeft((JTextComponent)e.getSource());
        }
    }

    private static class SelectRightAction
    extends AbstractAction {
        public SelectRightAction() {
            super("selection-next-word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentUtil.selectRight((JTextComponent)e.getSource());
        }
    }

    private static class JumpRightAction
    extends AbstractAction {
        public JumpRightAction() {
            super("caret-next-word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentUtil.jumpRight((JTextComponent)e.getSource());
        }
    }

    private static class CustomHomeAction
    extends AbstractAction {
        public CustomHomeAction() {
            super("caret-begin-line");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentUtil.handleHomeKey((JTextComponent)e.getSource());
        }
    }

    private static class CustomCopyAction
    extends DefaultEditorKit.CopyAction {
        private CustomCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent comp = (JTextComponent)e.getSource();
            TextComponentUtil.expandSelectionIfNeeded(comp);
            super.actionPerformed(e);
            CopyBuffer.instance().captureState();
        }
    }

    private static class CustomCutAction
    extends DefaultEditorKit.CutAction {
        private CustomCutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent comp = (JTextComponent)e.getSource();
            TextComponentUtil.expandSelectionIfNeeded(comp);
            super.actionPerformed(e);
            CopyBuffer.instance().captureState();
        }
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

