/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.util.EditorUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.swing.JRootPane;

public final class WaitCursorRunner {
    private static final WaitCursorRunner WAIT_CURSOR_RUNNER = new WaitCursorRunner();
    private WeakHashMap<JRootPane, RefCounter> _waitCursorMap = new WeakHashMap();
    private WeakHashMap<Component, JRootPane> _rootPaneMap = new WeakHashMap();
    private boolean _bWait;
    private WeakReference<Component> _c;

    private WaitCursorRunner() {
    }

    static Component showWaitCursor(boolean bWait) {
        if (!EventQueue.isDispatchThread()) {
            return null;
        }
        WaitCursorRunner.WAIT_CURSOR_RUNNER._bWait = bWait;
        WaitCursorRunner.WAIT_CURSOR_RUNNER._c = null;
        return WAIT_CURSOR_RUNNER.run();
    }

    static void showWaitCursor(boolean bWait, Component c) {
        if (!EventQueue.isDispatchThread()) {
            return;
        }
        WaitCursorRunner.WAIT_CURSOR_RUNNER._bWait = bWait;
        WaitCursorRunner.WAIT_CURSOR_RUNNER._c = new WeakReference<Component>(c);
        WAIT_CURSOR_RUNNER.run();
    }

    public Component run() {
        Window win;
        JRootPane rootPane;
        if (this._c != null && (rootPane = this._rootPaneMap.get(this._c.get())) != null) {
            this.showWaitCursorNow(this._bWait, rootPane);
            return rootPane;
        }
        Window focus = this._c == null ? EditorUtilities.getActiveWindow() : (Component)this._c.get();
        JRootPane rootPane2 = EditorUtilities.rootPaneForComponent(focus = focus == null ? EditorUtilities.getFocusedWindow() : focus);
        if (rootPane2 == null && (rootPane2 = EditorUtilities.rootPaneForComponent(focus = (focus = EditorUtilities.getActiveWindow()) == null ? EditorUtilities.getFocusedWindow() : focus)) == null) {
            return null;
        }
        if (!this._bWait && !rootPane2.isShowing() && (win = EditorUtilities.windowForComponent(rootPane2)) != null && (win = win.getOwner()) != null) {
            rootPane2 = EditorUtilities.rootPaneForComponent(win);
        }
        this._rootPaneMap.put(focus, rootPane2);
        this.showWaitCursorNow(this._bWait, rootPane2);
        return rootPane2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void showWaitCursorNow(boolean bWait, JRootPane rootPane) {
        if (rootPane == null) {
            return;
        }
        RefCounter refCounter = this._waitCursorMap.get(rootPane);
        try {
            Component glassPane = rootPane.getGlassPane();
            if (bWait && refCounter == null) {
                Cursor cursorWait = Cursor.getPredefinedCursor(3);
                rootPane.setCursor(cursorWait);
                glassPane.setCursor(cursorWait);
                glassPane.setVisible(true);
                glassPane.invalidate();
                refCounter = new RefCounter();
                this._waitCursorMap.put(rootPane, refCounter);
            } else if (!(bWait || refCounter != null && refCounter._iRefCount != 1)) {
                Cursor cursorDefault = Cursor.getPredefinedCursor(0);
                glassPane.setVisible(false);
                glassPane.setCursor(cursorDefault);
                rootPane.setCursor(cursorDefault);
                glassPane.invalidate();
                this._waitCursorMap.remove(rootPane);
            }
            if (refCounter == null) return;
            refCounter._iRefCount = refCounter._iRefCount + (bWait ? 1 : -1);
        }
        catch (Exception e) {
            try {
                EditorUtilities.handleUncaughtException(e);
                if (refCounter == null) return;
                refCounter._iRefCount = refCounter._iRefCount + (bWait ? 1 : -1);
            }
            catch (Throwable throwable) {
                if (refCounter == null) throw throwable;
                refCounter._iRefCount = refCounter._iRefCount + (bWait ? 1 : -1);
                if (refCounter._iRefCount >= 0) throw throwable;
                this._waitCursorMap.remove(rootPane);
                throw throwable;
            }
            if (refCounter._iRefCount >= 0) return;
            this._waitCursorMap.remove(rootPane);
            return;
        }
        if (refCounter._iRefCount >= 0) return;
        this._waitCursorMap.remove(rootPane);
        return;
    }

    static final class RefCounter {
        public int _iRefCount;

        RefCounter() {
        }
    }
}

