/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.Scheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public abstract class AbstractListCellRenderer<T>
extends JLabel
implements ListCellRenderer<T> {
    private boolean _bSelected;
    private T _node;
    private Supplier<JComponent> _list;
    private int _index;
    private boolean _bRenderAsIfFocused;

    public AbstractListCellRenderer(JComponent list) {
        this(list, false);
    }

    public AbstractListCellRenderer(JComponent list, boolean bRenderAsIfFocused) {
        this(() -> list, bRenderAsIfFocused);
    }

    public AbstractListCellRenderer(Supplier<JComponent> list) {
        this(list, false);
    }

    public AbstractListCellRenderer(Supplier<JComponent> list, boolean bRenderAsIfFocused) {
        this._list = list;
        this._bRenderAsIfFocused = bRenderAsIfFocused;
    }

    @Override
    public Component getListCellRendererComponent(JList tree, Object value, int index, boolean bSelected, boolean cellHasFocus) {
        if (value != null) {
            this._node = value;
            this._bSelected = bSelected;
            this._index = index;
            this.configure();
        }
        return this;
    }

    protected T getNode() {
        return this._node;
    }

    public int getIndex() {
        return this._index;
    }

    public void update() {
        this._list.get().repaint();
    }

    public abstract void configure();

    @Override
    public void paint(Graphics g) {
        Color bkColor;
        boolean bFocus;
        boolean bl = bFocus = this._bRenderAsIfFocused || KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == this._list.get();
        if (this._bSelected) {
            bkColor = this._list.get().isEnabled() && bFocus ? Scheme.active().getActiveCaption() : Scheme.active().getControl();
        } else {
            bkColor = this._list.get().getBackground();
            if (bkColor == null) {
                bkColor = this.getBackground();
            }
        }
        if (bkColor != null) {
            g.setColor(bkColor);
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            if (this._bSelected) {
                g.setColor(this._list.get().isEnabled() && bFocus ? Scheme.active().getXpBorderColor() : Scheme.active().getFieldBorderColor());
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            g.setColor(bkColor);
        }
        this.setForeground(Scheme.active().getWindowText());
        super.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (dim != null) {
            dim = new Dimension(dim.width + 3, dim.height);
        }
        return dim;
    }
}

