/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuPanel;
import editor.IHandleCancel;
import editor.LabFrame;
import editor.Scheme;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.LabButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class ClasspathDialog
extends JDialog
implements IHandleCancel {
    private JTextPane _pathsList;
    private JTextPane _backingSourceList;
    private File _dir;

    public ClasspathDialog(File dir) {
        super((JFrame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), "Dependencies", true);
        this._dir = dir;
        this.configUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ClasspathDialog.this.dispose();
            }
        });
    }

    protected void configUI() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBackground(Scheme.active().getMenu());
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        contentPane.setLayout(new BorderLayout());
        GridBagLayout gridBag = new GridBagLayout();
        JPanel mainPanel = new JPanel(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Scheme.active().getScrollbarBorderColor()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel label = new JLabel("<html>Need to use classes outside your experiment? Configure a '<b>" + File.pathSeparator + "</b>' separated list of directories and/or jar files containing Gosu or Java classes your experiment uses.");
        label.setBorder(new EmptyBorder(2, 0, 0, 0));
        int iY = 0;
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 10, 0);
        mainPanel.add((Component)label, c);
        label = new JLabel("Dependencies", EditorUtilities.loadIcon("images/folder.png"), 2);
        label.setBorder(new EmptyBorder(0, 0, 2, 0));
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 2, 0);
        mainPanel.add((Component)label, c);
        this._pathsList = new JTextPane();
        JScrollPane scroller = new JScrollPane(this._pathsList);
        this.setPathsList();
        this._pathsList.setBorder(BorderFactory.createEmptyBorder());
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.insets = new Insets(0, 0, 10, 0);
        mainPanel.add((Component)scroller, c);
        LabButton btnPaths = new LabButton("...");
        btnPaths.setToolTipText("Find a directory or Jar file");
        btnPaths.addActionListener(e -> this.updatePaths(this._pathsList));
        c.anchor = 11;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 4, 2, 0);
        mainPanel.add((Component)btnPaths, c);
        label = new JLabel("<html>If you have source files corresponding with any of the above dependencies, you can add those here.  They are useful for debugging, code navigation, etc.");
        label.setBorder(new EmptyBorder(2, 0, 0, 0));
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 10, 0);
        mainPanel.add((Component)label, c);
        label = new JLabel("Dependency Sources (optional)", EditorUtilities.loadIcon("images/folder.png"), 2);
        label.setBorder(new EmptyBorder(0, 0, 2, 0));
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 2, 0);
        mainPanel.add((Component)label, c);
        this._backingSourceList = new JTextPane();
        scroller = new JScrollPane(this._backingSourceList);
        this.setBackingSourceList();
        this._backingSourceList.setBorder(BorderFactory.createEmptyBorder());
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.insets = new Insets(0, 0, 10, 0);
        mainPanel.add((Component)scroller, c);
        btnPaths = new LabButton("...");
        btnPaths.setToolTipText("Find a directory or Jar file");
        btnPaths.addActionListener(e -> this.updatePaths(this._backingSourceList));
        c.anchor = 11;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 4, 2, 0);
        mainPanel.add((Component)btnPaths, c);
        contentPane.add((Component)mainPanel, "Center");
        JPanel south = new JPanel(new BorderLayout());
        south.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        south.setBackground(Scheme.active().getMenu());
        JPanel filler = new JPanel();
        filler.setBackground(Scheme.active().getMenu());
        south.add((Component)filler, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        LabButton btnFind = new LabButton("OK");
        btnFind.setMnemonic('O');
        btnFind.addActionListener(e -> {
            this.save();
            this.close();
        });
        buttonPanel.add(btnFind);
        this.getRootPane().setDefaultButton(btnFind);
        LabButton btnCancel = new LabButton("Cancel");
        btnCancel.addActionListener(e -> this.close());
        buttonPanel.add(btnCancel);
        buttonPanel.setBackground(Scheme.active().getMenu());
        south.add((Component)buttonPanel, "East");
        contentPane.add((Component)south, "South");
        this.mapCancelKeystroke("Cancel", this::close);
        this.setSize(600, 400);
        EditorUtilities.centerWindowInFrame(this, this.getOwner());
    }

    private void setPathsList() {
        String strPaths = "";
        List<String> paths = LabFrame.instance().getGosuPanel().getExperimentView().getExperiment().getSourcePath();
        for (int i = 0; i < paths.size(); ++i) {
            String strPath = paths.get(i);
            strPaths = strPaths + strPath + (i == paths.size() - 1 ? "" : File.pathSeparator + "\n");
        }
        this._pathsList.setText(strPaths);
    }

    private void setBackingSourceList() {
        String strPaths = "";
        List<String> paths = LabFrame.instance().getGosuPanel().getExperimentView().getExperiment().getBackingSourcePath();
        for (int i = 0; i < paths.size(); ++i) {
            String strPath = paths.get(i);
            strPaths = strPaths + strPath + (i == paths.size() - 1 ? "" : File.pathSeparator + "\n");
        }
        this._backingSourceList.setText(strPaths);
    }

    private void save() {
        List<File> classpath = this.saveClassPath(this._pathsList.getText());
        List<File> backingSourcePath = this.saveClassPath(this._backingSourceList.getText());
        this.savePathsAndReopenExperiment(classpath, backingSourcePath);
    }

    private List<File> saveClassPath(String strPaths) {
        StringTokenizer tokenizer = new StringTokenizer(strPaths, File.pathSeparator + "\n\r\t");
        ArrayList<String> paths = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String strPath = tokenizer.nextToken();
            paths.add(strPath.trim());
        }
        ArrayList<File> pathFiles = new ArrayList<File>();
        for (String strPath : paths) {
            pathFiles.add(new File(strPath).getAbsoluteFile());
        }
        return pathFiles;
    }

    private void savePathsAndReopenExperiment(List<File> pathFiles, List<File> backingSourcePath) {
        GosuPanel gosuPanel = LabFrame.instance().getGosuPanel();
        Experiment experiment = gosuPanel.getExperimentView().getExperiment();
        List<String> sourcePaths = pathFiles.stream().map(File::getAbsolutePath).collect(Collectors.toList());
        experiment.setSourcePath(sourcePaths);
        List<String> backingSourcePaths = backingSourcePath.stream().map(File::getAbsolutePath).collect(Collectors.toList());
        experiment.setBackingSourcePath(backingSourcePaths);
        gosuPanel.openExperiment(experiment.getExperimentDir());
    }

    private void updatePaths(JTextPane target) {
        JFileChooser fc = new JFileChooser(this.getCurrentDir());
        fc.setDialogTitle("Add Paths");
        fc.setDialogType(0);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".zip") || f.getName().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return "Directories or Archive Files";
            }
        });
        int returnVal = fc.showOpenDialog(EditorUtilities.frameForComponent(this));
        if (returnVal == 0) {
            String strExisting = target.getText().trim();
            if (strExisting.endsWith(File.pathSeparator)) {
                strExisting = strExisting.substring(0, strExisting.length() - 1);
            }
            for (File f : fc.getSelectedFiles()) {
                strExisting = strExisting + File.pathSeparatorChar + "\n" + f.getAbsolutePath();
            }
            this._dir = fc.getCurrentDirectory();
            target.setText(strExisting);
        }
    }

    private File getCurrentDir() {
        return this._dir;
    }

    private void close() {
        this.dispose();
    }
}

