/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.sun.jdi.StackFrame;
import editor.EditorHost;
import editor.FileTree;
import editor.FileTreeUtil;
import editor.GosuEditor;
import editor.GosuPanel;
import editor.LabFrame;
import editor.actions.GenericAction;
import editor.debugger.Breakpoint;
import editor.debugger.BreakpointManager;
import editor.debugger.BreakpointsDialog;
import editor.debugger.Debugger;
import editor.debugger.EvaluateDialog;
import editor.run.IRunConfig;
import editor.run.RunConfigDialog;
import editor.run.RunState;
import editor.search.LocalSearchDialog;
import editor.search.LocalVarFeatureInfo;
import editor.search.SearchDialog;
import editor.search.SearchPanel;
import editor.search.UsageSearcher;
import editor.search.UsageTarget;
import editor.settings.CompilerSettings;
import editor.settings.SettingsDialog;
import editor.undo.AtomicUndoManager;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.SmartMenuItem;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IType;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class CommonMenus {
    public static JMenuItem makeCut(Supplier<EditorHost> editor) {
        SmartMenuItem cutItem = new SmartMenuItem(new CutActionHandler(editor));
        cutItem.setMnemonic('t');
        cutItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " X"));
        return cutItem;
    }

    public static JMenuItem makeCopy(Supplier<EditorHost> editor) {
        SmartMenuItem copyItem = new SmartMenuItem(new CopyActionHandler(editor));
        copyItem.setMnemonic('C');
        copyItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " C"));
        return copyItem;
    }

    public static JMenuItem makePaste(Supplier<EditorHost> editor) {
        SmartMenuItem pasteItem = new SmartMenuItem(new PasteActionHandler(editor));
        pasteItem.setMnemonic('P');
        pasteItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " V"));
        return pasteItem;
    }

    public static JMenuItem makePasteJavaAsGosu(final Supplier<GosuEditor> editor) {
        return new SmartMenuItem(new AbstractAction("Paste Java as Gosu"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GosuEditor)editor.get()).clipPaste(CommonMenus.getGosuPanel().getClipboard(), true);
            }

            @Override
            public boolean isEnabled() {
                return editor.get() != null;
            }
        });
    }

    public static JMenuItem makeFindUsages(Supplier<FileTree> tree) {
        SmartMenuItem completeItem = new SmartMenuItem(new FindUsagesInPathActionHandler(tree));
        completeItem.setMnemonic('U');
        completeItem.setAccelerator(KeyStroke.getKeyStroke("alt F7"));
        return completeItem;
    }

    public static JMenuItem makeFindUsagesInFile() {
        SmartMenuItem completeItem = new SmartMenuItem(new FindUsagesInFileActionHandler());
        completeItem.setMnemonic('F');
        completeItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " F7"));
        return completeItem;
    }

    public static JMenuItem makeHighlightFindUsagesInFile() {
        SmartMenuItem completeItem = new SmartMenuItem(new HighlightUsagesInFileActionHandler());
        completeItem.setMnemonic('H');
        completeItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " shift F7"));
        return completeItem;
    }

    public static JMenuItem makeNextOccurrent(Supplier<SearchPanel> search) {
        SmartMenuItem completeItem = new SmartMenuItem(new NextOccurrenceActionHandler(search));
        completeItem.setMnemonic('X');
        completeItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " alt DOWN"));
        return completeItem;
    }

    public static JMenuItem makePrevOccurrent(Supplier<SearchPanel> search) {
        SmartMenuItem completeItem = new SmartMenuItem(new PrevOccurrenceActionHandler(search));
        completeItem.setMnemonic('V');
        completeItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " alt UP"));
        return completeItem;
    }

    public static JMenuItem makeCodeComplete(final Supplier<GosuEditor> editor) {
        SmartMenuItem completeItem = new SmartMenuItem(new AbstractAction("Complete Code"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GosuEditor)editor.get()).handleCompleteCode();
            }

            @Override
            public boolean isEnabled() {
                return editor.get() != null;
            }
        });
        completeItem.setMnemonic('L');
        completeItem.setAccelerator(KeyStroke.getKeyStroke("control SPACE"));
        return completeItem;
    }

    public static JMenuItem makeParameterInfo(final Supplier<GosuEditor> editor) {
        SmartMenuItem paraminfoItem = new SmartMenuItem(new AbstractAction("Parameter Info"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((GosuEditor)editor.get()).isCompletionPopupShowing()) {
                    ((GosuEditor)editor.get()).displayParameterInfoPopup(((GosuEditor)editor.get()).getEditor().getCaretPosition());
                }
            }

            @Override
            public boolean isEnabled() {
                return editor.get() != null;
            }
        });
        paraminfoItem.setMnemonic('P');
        paraminfoItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " P"));
        return paraminfoItem;
    }

    public static JMenuItem makeExpressionType(final Supplier<GosuEditor> editor) {
        SmartMenuItem typeItem = new SmartMenuItem(new AbstractAction("Expression Type"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GosuEditor)editor.get()).displayTypeInfoAtCurrentLocation();
            }

            @Override
            public boolean isEnabled() {
                return editor.get() != null;
            }
        });
        typeItem.setMnemonic('T');
        typeItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " T"));
        return typeItem;
    }

    public static JMenuItem makeGotoDeclaration(final Supplier<GosuEditor> editor) {
        SmartMenuItem navigate = new SmartMenuItem(new AbstractAction("Goto Declaration"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GosuEditor)editor.get()).gotoDeclaration();
            }

            @Override
            public boolean isEnabled() {
                return editor.get() != null;
            }
        });
        navigate.setMnemonic('D');
        navigate.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " B"));
        return navigate;
    }

    public static JMenuItem makeShowFileInTree(final Supplier<EditorHost> editor) {
        SmartMenuItem navigate = new SmartMenuItem(new AbstractAction("Select File in Tree"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((EditorHost)editor.get()).showFileInTree();
            }
        });
        navigate.setMnemonic('F');
        navigate.setAccelerator(KeyStroke.getKeyStroke("alt F1"));
        return navigate;
    }

    public static JMenuItem makeQuickDocumentation(final Supplier<GosuEditor> editor) {
        SmartMenuItem quickDoc = new SmartMenuItem(new AbstractAction("Quick Documentation"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GosuEditor)editor.get()).displayJavadocHelp(((GosuEditor)editor.get()).getDeepestLocationAtCaret());
            }

            @Override
            public boolean isEnabled() {
                return editor.get() != null;
            }
        });
        quickDoc.setMnemonic('Q');
        quickDoc.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " Q"));
        return quickDoc;
    }

    public static JMenuItem makeViewBytecode() {
        SmartMenuItem item = new SmartMenuItem(new AbstractAction("View Bytecode"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonMenus.getGosuPanel().dumpBytecode();
            }
        });
        item.setMnemonic('y');
        return item;
    }

    public static JMenuItem makeViewCompile() {
        SmartMenuItem item = new SmartMenuItem(new AbstractAction("Compile"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonMenus.getGosuPanel().compile(Collections.singleton(CommonMenus.getGosuPanel().getCurrentEditor().getParsedClass()));
            }
        });
        item.setMnemonic('i');
        return item;
    }

    public static JMenuItem makeRun(final Supplier<IRunConfig> runConfig) {
        SmartMenuItem item = new SmartMenuItem((Action)new ClearAndRunActionHandler(runConfig)){

            @Override
            public String getText() {
                IRunConfig rc = (IRunConfig)runConfig.get();
                return rc == null ? "Run" : "Run '" + rc.getName() + "'";
            }
        };
        item.setMnemonic('R');
        item.setAccelerator(KeyStroke.getKeyStroke("F5"));
        return item;
    }

    public static JMenuItem makeDebug(final Supplier<IRunConfig> runConfig) {
        SmartMenuItem item = new SmartMenuItem((Action)new ClearAndDebugActionHandler(runConfig)){

            @Override
            public String getText() {
                IRunConfig rc = (IRunConfig)runConfig.get();
                return rc == null ? "Debug" : "Debug '" + rc.getName() + "'";
            }
        };
        item.setMnemonic('D');
        item.setAccelerator(KeyStroke.getKeyStroke("alt F5"));
        return item;
    }

    public static JMenuItem makeRunConfig() {
        SmartMenuItem item = new SmartMenuItem(new RunConfigActionHandler());
        item.setMnemonic('C');
        item.setAccelerator(KeyStroke.getKeyStroke("shift F5"));
        return item;
    }

    public static JMenuItem makeDebugConfig() {
        SmartMenuItem item = new SmartMenuItem(new DebugConfigActionHandler());
        item.setMnemonic('G');
        item.setAccelerator(KeyStroke.getKeyStroke("alt shift F5"));
        return item;
    }

    public static JMenuItem makeStop(Supplier<GosuPanel> gosuPanel) {
        SmartMenuItem item = new SmartMenuItem(new StopActionHandler(gosuPanel::get));
        item.setMnemonic('S');
        item.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " F2"));
        return item;
    }

    public static JMenuItem makeToggleBreakpoint(final Supplier<BreakpointManager> bpm, final Supplier<GosuEditor> editor) {
        SmartMenuItem item = new SmartMenuItem(new AbstractAction("Toggle Breakpoint", EditorUtilities.loadIcon("images/debug_linebreakpoint.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int lineAtCaret = ((GosuEditor)editor.get()).getLineNumberAtCaret();
                ((BreakpointManager)bpm.get()).toggleLineBreakpoint((EditorHost)editor.get(), ((GosuEditor)editor.get()).getScriptPart().getContainingTypeName(), ((GosuEditor)editor.get()).getTypeAtLine(lineAtCaret), lineAtCaret);
            }

            @Override
            public boolean isEnabled() {
                return editor.get() != null && ((BreakpointManager)bpm.get()).canAddBreakpoint((EditorHost)editor.get(), ((GosuEditor)editor.get()).getLineNumberAtCaret());
            }
        });
        item.setMnemonic('B');
        item.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " F8"));
        return item;
    }

    public static JMenuItem makeStepOver(Supplier<Debugger> debugger) {
        SmartMenuItem item = new SmartMenuItem(new StepOverActionHandler(debugger));
        item.setMnemonic('O');
        item.setAccelerator(KeyStroke.getKeyStroke("F8"));
        return item;
    }

    public static JMenuItem makeStepInto(Supplier<Debugger> debugger) {
        SmartMenuItem item = new SmartMenuItem(new StepIntoActionHandler(debugger));
        item.setMnemonic('V');
        item.setAccelerator(KeyStroke.getKeyStroke("F7"));
        return item;
    }

    public static JMenuItem makeStepOut(Supplier<Debugger> debugger) {
        SmartMenuItem item = new SmartMenuItem(new StepOutActionHandler(debugger));
        item.setMnemonic('T');
        item.setAccelerator(KeyStroke.getKeyStroke("shift F8"));
        return item;
    }

    public static JMenuItem makeRunToCursor(Supplier<Debugger> debugger, Supplier<BreakpointManager> bpm, Supplier<GosuEditor> editor) {
        SmartMenuItem item = new SmartMenuItem(new RunToCursorActionHandler(debugger, bpm, editor));
        item.setMnemonic('S');
        item.setAccelerator(KeyStroke.getKeyStroke("alt F9"));
        return item;
    }

    public static JMenuItem makeDropFrame(Supplier<Debugger> debugger, Supplier<StackFrame> frame) {
        SmartMenuItem item = new SmartMenuItem(new DropFrameActionHandler(debugger, frame));
        item.setMnemonic('F');
        return item;
    }

    public static JMenuItem makePause(Supplier<Debugger> debugger) {
        SmartMenuItem item = new SmartMenuItem(new PauseActionHandler(debugger));
        item.setMnemonic('P');
        return item;
    }

    public static JMenuItem makeResume(Supplier<Debugger> debugger) {
        SmartMenuItem item = new SmartMenuItem(new ResumeActionHandler(debugger));
        item.setMnemonic('G');
        item.setAccelerator(KeyStroke.getKeyStroke("F9"));
        return item;
    }

    public static JMenuItem makeEvaluateExpression(Supplier<Debugger> debugger) {
        SmartMenuItem item = new SmartMenuItem(new EvaluateExpressionActionHandler(debugger));
        item.setMnemonic('E');
        item.setAccelerator(KeyStroke.getKeyStroke("alt F8"));
        return item;
    }

    public static JMenuItem makeShowExecutionPoint(Supplier<Debugger> debugger) {
        SmartMenuItem item = new SmartMenuItem(new ShowExecPointActionHandler(debugger));
        item.setMnemonic('P');
        item.setAccelerator(KeyStroke.getKeyStroke("alt F10"));
        return item;
    }

    public static JMenuItem makeViewBreakpoints(Supplier<Breakpoint> bp) {
        SmartMenuItem item = new SmartMenuItem(new ViewBreakpointsActionHandler(bp));
        item.setMnemonic('B');
        return item;
    }

    public static JMenuItem makeMuteBreakpoints(Supplier<BreakpointManager> bpm) {
        SmartMenuItem item = new SmartMenuItem(new MuteBreakpointsActionHandler(bpm));
        item.setMnemonic('M');
        return item;
    }

    public static JMenuItem makeClear(final Supplier<GosuPanel> gosuPanel) {
        SmartMenuItem clearItem = new SmartMenuItem(new AbstractAction("Clear Console"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GosuPanel)gosuPanel.get()).showConsole(true);
                ((GosuPanel)gosuPanel.get()).clearOutput();
            }

            @Override
            public boolean isEnabled() {
                return ((GosuPanel)gosuPanel.get()).getConsolePanel() != null;
            }
        });
        clearItem.setMnemonic('C');
        clearItem.setAccelerator(KeyStroke.getKeyStroke("alt C"));
        return clearItem;
    }

    private static GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }

    private static Experiment getExperiment() {
        return CommonMenus.getGosuPanel().getExperiment();
    }

    private static FileTree getOrMakeLocalFileTree() {
        Path file = CommonMenus.getGosuPanel().getCurrentFile();
        FileTree tree = FileTreeUtil.getRoot().find(file);
        if (tree == null) {
            tree = FileTreeUtil.makeExternalFileTree(file, CommonMenus.getGosuPanel().getCurrentEditor().getParsedClass().getName());
        }
        return tree;
    }

    public static class RunToCursorActionHandler
    extends AbstractAction {
        private final Supplier<Debugger> _debugger;
        private final Supplier<BreakpointManager> _bpm;
        private final Supplier<GosuEditor> _editor;

        public RunToCursorActionHandler(Supplier<Debugger> debugger, Supplier<BreakpointManager> bpm, Supplier<GosuEditor> editor) {
            super("Run to Cursor", EditorUtilities.loadIcon("images/debug_runtocursor.png"));
            this._bpm = bpm;
            this._editor = editor;
            this._debugger = debugger;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                this._bpm.get().runToCursor(this._editor.get());
            }
        }

        @Override
        public boolean isEnabled() {
            return this._debugger.get() != null && this._debugger.get().isSuspended() && this._editor.get() != null && this._bpm.get().canAddBreakpoint(this._editor.get(), this._editor.get().getLineNumberAtCaret());
        }
    }

    public static class ShowExecPointActionHandler
    extends AbstractAction {
        private final Supplier<Debugger> _debugger;

        public ShowExecPointActionHandler(Supplier<Debugger> debugger) {
            super("Show Execution Point", EditorUtilities.loadIcon("images/debug_showexecpoint.png"));
            this._debugger = debugger;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                CommonMenus.getGosuPanel().jumptToBreakpoint(this._debugger.get().getSuspendedLocation(), true);
            }
        }

        @Override
        public boolean isEnabled() {
            return this._debugger.get() != null && this._debugger.get().isSuspended();
        }
    }

    public static class EvaluateExpressionActionHandler
    extends AbstractAction {
        private final Supplier<Debugger> _debugger;

        public EvaluateExpressionActionHandler(Supplier<Debugger> debugger) {
            super("Evaluate Expression", EditorUtilities.loadIcon("images/tester.png"));
            this._debugger = debugger;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                String expr = "";
                EditorHost editor = CommonMenus.getGosuPanel().getCurrentEditor();
                if (editor != null) {
                    String selection = editor.getEditor().getSelectedText();
                    expr = selection == null ? expr : selection;
                }
                new EvaluateDialog(expr).setVisible(true);
            }
        }

        @Override
        public boolean isEnabled() {
            return this._debugger.get() != null && this._debugger.get().isSuspended();
        }
    }

    public static class DropFrameActionHandler
    extends AbstractAction {
        private final Supplier<Debugger> _debugger;
        private final Supplier<StackFrame> _frame;

        public DropFrameActionHandler(Supplier<Debugger> debugger, Supplier<StackFrame> frame) {
            super("Drop Frame", EditorUtilities.loadIcon("images/debug_dropframe.png"));
            this._debugger = debugger;
            this._frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                this._debugger.get().dropToFrame(this._frame.get());
            }
        }

        @Override
        public boolean isEnabled() {
            return this._debugger.get() != null && this._debugger.get().isSuspended();
        }
    }

    public static class StepOutActionHandler
    extends AbstractAction {
        private final Supplier<Debugger> _debugger;

        public StepOutActionHandler(Supplier<Debugger> debugger) {
            super("Step Out", EditorUtilities.loadIcon("images/debug_stepout.png"));
            this._debugger = debugger;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                this._debugger.get().stepOut();
            }
        }

        @Override
        public boolean isEnabled() {
            return this._debugger.get() != null && this._debugger.get().isSuspended();
        }
    }

    public static class StepIntoActionHandler
    extends AbstractAction {
        private final Supplier<Debugger> _debugger;

        public StepIntoActionHandler(Supplier<Debugger> debugger) {
            super("Step Into", EditorUtilities.loadIcon("images/debug_stepinto.png"));
            this._debugger = debugger;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                this._debugger.get().stepInto();
            }
        }

        @Override
        public boolean isEnabled() {
            return this._debugger.get() != null && this._debugger.get().isSuspended();
        }
    }

    public static class StepOverActionHandler
    extends AbstractAction {
        private final Supplier<Debugger> _debugger;

        public StepOverActionHandler(Supplier<Debugger> debugger) {
            super("Step Over", EditorUtilities.loadIcon("images/debug_stepover.png"));
            this._debugger = debugger;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                this._debugger.get().stepOver();
            }
        }

        @Override
        public boolean isEnabled() {
            return this._debugger.get() != null && this._debugger.get().isSuspended();
        }
    }

    public static class MuteBreakpointsActionHandler
    extends GenericAction {
        private final Supplier<BreakpointManager> _bpm;

        public MuteBreakpointsActionHandler(Supplier<BreakpointManager> bpm) {
            super("_muteBreakpoints", "Mute Breakpoints", "images/disabled_breakpoint.png", '\u0000', null, null, null);
            this._bpm = bpm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._bpm.get().setMuted(!this._bpm.get().isMuted());
        }

        @Override
        public boolean isSelected() {
            return this._bpm.get().isMuted();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public static class ShipItActionHandler
    extends AbstractAction {
        public ShipItActionHandler() {
            super("ShipIt...", EditorUtilities.loadIcon("images/shipit.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonMenus.getGosuPanel().shipIt();
        }
    }

    public static class RebuildActionHandler
    extends AbstractAction {
        public RebuildActionHandler() {
            super("Rebuild");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonMenus.getGosuPanel().rebuild();
        }
    }

    public static class CompileActionHandler
    extends AbstractAction {
        private final Supplier<FileTree> _fileTree;

        public CompileActionHandler(Supplier<FileTree> fileTree) {
            super("Compile");
            this._fileTree = fileTree;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashSet<IType> types = new HashSet<IType>();
            this._fileTree.get().traverse(ft -> {
                IType type = ft.getType();
                if (type != null) {
                    types.add(type);
                }
                return true;
            });
            if (!types.isEmpty()) {
                CommonMenus.getGosuPanel().compile(types);
            }
        }
    }

    public static class MakeActionHandler
    extends AbstractAction {
        public MakeActionHandler() {
            super("Make", EditorUtilities.loadIcon("images/compile.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonMenus.getGosuPanel().make();
        }
    }

    public static class GoForwardActionHandler
    extends AbstractAction {
        public GoForwardActionHandler() {
            super("Forward", EditorUtilities.loadIcon("images/forward.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonMenus.getGosuPanel().goForward();
        }

        @Override
        public boolean isEnabled() {
            return CommonMenus.getGosuPanel() != null && CommonMenus.getGosuPanel().canGoForward();
        }
    }

    public static class GoBackActionHandler
    extends AbstractAction {
        public GoBackActionHandler() {
            super("Back", EditorUtilities.loadIcon("images/back.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonMenus.getGosuPanel().goBackward();
        }

        @Override
        public boolean isEnabled() {
            return CommonMenus.getGosuPanel() != null && CommonMenus.getGosuPanel().canGoBackward();
        }
    }

    public static class HighlightUsagesInFileActionHandler
    extends AbstractAction {
        public HighlightUsagesInFileActionHandler() {
            super("Highlight Usages in File");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            ((GosuEditor)CommonMenus.getGosuPanel().getCurrentEditor()).highlightUsagesOfFeatureUnderCaret();
        }

        @Override
        public boolean isEnabled() {
            return this.findCurrentFile() instanceof GosuEditor;
        }

        private EditorHost findCurrentFile() {
            return CommonMenus.getGosuPanel() == null ? null : CommonMenus.getGosuPanel().getCurrentEditor();
        }
    }

    public static class FindUsagesInFileActionHandler
    extends AbstractAction {
        public FindUsagesInFileActionHandler() {
            super("Find Usages in File");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            CommonMenus.getGosuPanel().save();
            CommonMenus.getGosuPanel().getCurrentEditor().parseAndWaitForParser();
            UsageTarget target = UsageTarget.makeTargetFromCaret();
            if (target == null) {
                JOptionPane.showMessageDialog(LabFrame.instance(), "Please select a valid usage target in the editor", "Gosu Lab", 1);
            } else {
                new UsageSearcher(target, true, false).search(CommonMenus.getOrMakeLocalFileTree());
            }
        }

        @Override
        public boolean isEnabled() {
            return this.findCurrentFile() instanceof GosuEditor;
        }

        private EditorHost findCurrentFile() {
            return CommonMenus.getGosuPanel() == null ? null : CommonMenus.getGosuPanel().getCurrentEditor();
        }
    }

    public static class PrevOccurrenceActionHandler
    extends AbstractAction {
        private final Supplier<SearchPanel> _search;

        public PrevOccurrenceActionHandler(Supplier<SearchPanel> search) {
            super("Previous Occurrence");
            this._search = search;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                this._search.get().gotoPreviousItem();
            }
        }

        @Override
        public boolean isEnabled() {
            return this._search.get() != null;
        }
    }

    public static class NextOccurrenceActionHandler
    extends AbstractAction {
        private final Supplier<SearchPanel> _search;

        public NextOccurrenceActionHandler(Supplier<SearchPanel> search) {
            super("Next Occurrence");
            this._search = search;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                this._search.get().gotoNextItem();
            }
        }

        @Override
        public boolean isEnabled() {
            return this._search.get() != null;
        }
    }

    public static class FindUsagesInPathActionHandler
    extends AbstractAction {
        private final Supplier<FileTree> _dir;

        public FindUsagesInPathActionHandler(Supplier<FileTree> dir) {
            super("Find Usages");
            this._dir = dir;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            CommonMenus.getGosuPanel().save();
            CommonMenus.getGosuPanel().getCurrentEditor().parseAndWaitForParser();
            UsageTarget target = UsageTarget.makeTargetFromCaret();
            if (target == null) {
                JOptionPane.showMessageDialog(LabFrame.instance(), "Please select a valid usage target in the editor", "Gosu Lab", 1);
            } else {
                FileTree tree = this._dir.get();
                IFeatureInfo fi = target.getRootFeatureInfo();
                if (fi instanceof LocalVarFeatureInfo || fi instanceof IAttributedFeatureInfo && ((IAttributedFeatureInfo)fi).isPrivate()) {
                    tree = CommonMenus.getOrMakeLocalFileTree();
                }
                new UsageSearcher(target, true, false).search(tree);
            }
        }

        @Override
        public boolean isEnabled() {
            EditorHost editor = CommonMenus.getGosuPanel() == null ? null : CommonMenus.getGosuPanel().getCurrentEditor();
            return editor instanceof GosuEditor;
        }
    }

    public static class ReplaceInPathActionHandler
    extends AbstractAction {
        private final Supplier<FileTree> _dir;

        public ReplaceInPathActionHandler(Supplier<FileTree> dir) {
            super("Replace in path...");
            this._dir = dir;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonMenus.getGosuPanel().saveIfDirty();
            SearchDialog searchDialog = new SearchDialog(this._dir.get(), true);
            searchDialog.setVisible(true);
        }

        @Override
        public boolean isEnabled() {
            return this._dir.get() != null && this._dir.get().getFileOrDir() != null;
        }
    }

    public static class FindInPathActionHandler
    extends AbstractAction {
        private final Supplier<FileTree> _dir;

        public FindInPathActionHandler(Supplier<FileTree> dir) {
            super("Find in path...");
            this._dir = dir;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonMenus.getGosuPanel().saveIfDirty();
            SearchDialog searchDialog = new SearchDialog(this._dir.get(), false);
            searchDialog.setVisible(true);
        }

        @Override
        public boolean isEnabled() {
            return this._dir.get() != null && this._dir.get().getFileOrDir() != null;
        }
    }

    public static class ReplaceActionHandler
    extends AbstractAction {
        private final Supplier<EditorHost> _editor;

        public ReplaceActionHandler(Supplier<EditorHost> editor) {
            super("Replace...", EditorUtilities.loadIcon("images/replace.png"));
            this._editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new LocalSearchDialog(CommonMenus.getOrMakeLocalFileTree(), true).setVisible(true);
        }

        @Override
        public boolean isEnabled() {
            return this._editor.get() != null;
        }
    }

    public static class FindActionHandler
    extends AbstractAction {
        private final Supplier<EditorHost> _editor;

        public FindActionHandler(Supplier<EditorHost> editor) {
            super("Find...", EditorUtilities.loadIcon("images/Find.png"));
            this._editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new LocalSearchDialog(CommonMenus.getOrMakeLocalFileTree(), false).setVisible(true);
        }

        @Override
        public boolean isEnabled() {
            return this._editor.get() != null;
        }
    }

    public static class PasteActionHandler
    extends AbstractAction {
        private final Supplier<EditorHost> _editor;

        public PasteActionHandler(Supplier<EditorHost> editor) {
            super("Paste", EditorUtilities.loadIcon("images/Paste.png"));
            this._editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._editor.get().clipPaste(CommonMenus.getGosuPanel().getClipboard(), false);
        }

        @Override
        public boolean isEnabled() {
            return this._editor.get() != null;
        }
    }

    public static class CopyActionHandler
    extends AbstractAction {
        private final Supplier<EditorHost> _editor;

        public CopyActionHandler(Supplier<EditorHost> editor) {
            super("Copy", EditorUtilities.loadIcon("images/Copy.png"));
            this._editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._editor.get().clipCopy(CommonMenus.getGosuPanel().getClipboard());
        }

        @Override
        public boolean isEnabled() {
            return this._editor.get() != null;
        }
    }

    public static class CutActionHandler
    extends AbstractAction {
        private final Supplier<EditorHost> _editor;

        public CutActionHandler(Supplier<EditorHost> editor) {
            super("Cut", EditorUtilities.loadIcon("images/Cut.png"));
            this._editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._editor.get().clipCut(CommonMenus.getGosuPanel().getClipboard());
        }

        @Override
        public boolean isEnabled() {
            return this._editor.get() != null;
        }
    }

    public static class RedoActionHandler
    extends AbstractAction {
        public RedoActionHandler() {
            super("Redo", EditorUtilities.loadIcon("images/Redo.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CommonMenus.getGosuPanel().getUndoManager().canRedo()) {
                CommonMenus.getGosuPanel().getUndoManager().redo();
            }
        }

        @Override
        public boolean isEnabled() {
            AtomicUndoManager undoManager = CommonMenus.getGosuPanel() != null ? CommonMenus.getGosuPanel().getUndoManager() : null;
            return undoManager != null && undoManager.canRedo();
        }
    }

    public static class UndoActionHandler
    extends AbstractAction {
        public UndoActionHandler() {
            super("Undo", EditorUtilities.loadIcon("images/Undo.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CommonMenus.getGosuPanel().getUndoManager().canUndo()) {
                CommonMenus.getGosuPanel().getUndoManager().undo();
            }
        }

        @Override
        public boolean isEnabled() {
            AtomicUndoManager undoManager = CommonMenus.getGosuPanel() != null ? CommonMenus.getGosuPanel().getUndoManager() : null;
            return undoManager != null && undoManager.canUndo();
        }
    }

    public static class SettingsActionHandler
    extends AbstractAction {
        public SettingsActionHandler() {
            super("Settings...", EditorUtilities.loadIcon("images/settings.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new SettingsDialog().setVisible(true);
        }
    }

    public static class SaveActionHandler
    extends AbstractAction {
        public SaveActionHandler() {
            super("Save All", EditorUtilities.loadIcon("images/save.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LabFrame.instance().getGosuPanel().save();
        }
    }

    public static class OpenProjectActionHandler
    extends AbstractAction {
        public OpenProjectActionHandler() {
            super("Open Project...", EditorUtilities.loadIcon("images/folder.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LabFrame.instance().getGosuPanel().openExperiment();
        }
    }

    public static class ViewBreakpointsActionHandler
    extends AbstractAction {
        private final Supplier<Breakpoint> _bp;

        public ViewBreakpointsActionHandler(Supplier<Breakpoint> bp) {
            super("View Breakpoints...", EditorUtilities.loadIcon("images/debug_breakpoints.png"));
            this._bp = bp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakpointsDialog.getOrCreate(this._bp.get()).setVisible(true);
        }
    }

    public static class ResumeActionHandler
    extends AbstractAction {
        private Supplier<Debugger> _debugger;

        public ResumeActionHandler(Supplier<Debugger> debugger) {
            super("Resume", EditorUtilities.loadIcon("images/resume.png"));
            this._debugger = debugger;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                this._debugger.get().resumeExecution();
            }
        }

        @Override
        public boolean isEnabled() {
            return this._debugger.get() != null && (this._debugger.get().isSuspended() || this._debugger.get().isPaused());
        }
    }

    public static class PauseActionHandler
    extends AbstractAction {
        private Supplier<Debugger> _debugger;

        public PauseActionHandler(Supplier<Debugger> debugger) {
            super("Pause", EditorUtilities.loadIcon("images/pause.png"));
            this._debugger = debugger;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                this._debugger.get().pause();
                CommonMenus.getGosuPanel().showDebugger(true);
            }
        }

        @Override
        public boolean isEnabled() {
            return this._debugger.get() != null && !this._debugger.get().isSuspended() && !this._debugger.get().isPaused();
        }
    }

    public static class StopActionHandler
    extends AbstractAction {
        private Supplier<GosuPanel> _gosuPanel;

        public StopActionHandler(Supplier<GosuPanel> gosuPanel) {
            super("Stop", EditorUtilities.loadIcon("images/rule_stop_execution.png"));
            this._gosuPanel = gosuPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                this.killProcess();
            }
        }

        @Override
        public boolean isEnabled() {
            GosuPanel gosuPanel = this._gosuPanel.get();
            if (gosuPanel == null) {
                return false;
            }
            return gosuPanel.isRunning() || gosuPanel.isDebugging();
        }

        private void killProcess() {
            GosuPanel gosuPanel = this._gosuPanel.get();
            if (gosuPanel == null) {
                return;
            }
            gosuPanel.killProcess();
        }
    }

    public static class DebugConfigActionHandler
    extends AbstractAction {
        DebugConfigActionHandler() {
            super("Debug...", EditorUtilities.loadIcon("images/debugconfig.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RunConfigDialog dlg = new RunConfigDialog(CommonMenus.getExperiment(), RunState.Debug);
            dlg.setVisible(true);
            IRunConfig configToRun = dlg.getConfigToRun();
            if (configToRun != null) {
                new ClearAndDebugActionHandler(() -> configToRun).actionPerformed(null);
            }
        }
    }

    public static class RunConfigActionHandler
    extends AbstractAction {
        RunConfigActionHandler() {
            super("Run...", EditorUtilities.loadIcon("images/runconfig.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RunConfigDialog dlg = new RunConfigDialog(CommonMenus.getExperiment(), RunState.Run);
            dlg.setVisible(true);
            IRunConfig configToRun = dlg.getConfigToRun();
            if (configToRun != null) {
                new ClearAndRunActionHandler(() -> configToRun).actionPerformed(null);
            }
        }
    }

    public static class ClearAndDebugActionHandler
    extends AbstractRunActionHandler {
        public ClearAndDebugActionHandler(Supplier<IRunConfig> program) {
            super("Debug", EditorUtilities.loadIcon("images/debug.png"), program);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            IRunConfig runConfig = this.getRunConfig();
            if (runConfig != null && runConfig.isValid() && runConfig.isDebuggable()) {
                if (this.prepareToExecute()) {
                    CommonMenus.getGosuPanel().debug(runConfig);
                }
            } else {
                new DebugConfigActionHandler().actionPerformed(e);
            }
        }
    }

    public static class ClearAndRunActionHandler
    extends AbstractRunActionHandler {
        public ClearAndRunActionHandler(Supplier<IRunConfig> runConfig) {
            super("Run", EditorUtilities.loadIcon("images/run.png"), runConfig);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            IRunConfig runConfig = this.getRunConfig();
            if (runConfig != null && runConfig.isValid() && runConfig.isRunnable()) {
                if (this.prepareToExecute()) {
                    CommonMenus.getGosuPanel().execute(runConfig);
                }
            } else {
                new RunConfigActionHandler().actionPerformed(e);
            }
        }
    }

    public static abstract class AbstractRunActionHandler
    extends AbstractAction {
        protected final Supplier<IRunConfig> _runConfig;

        AbstractRunActionHandler(String title, Icon icon, Supplier<IRunConfig> runConfig) {
            super(title, icon);
            this._runConfig = runConfig;
        }

        protected IRunConfig getRunConfig() {
            return this._runConfig.get();
        }

        protected boolean prepareToExecute() {
            GosuPanel gosuPanel = CommonMenus.getGosuPanel();
            if (CompilerSettings.isStaticCompile() && !gosuPanel.make()) {
                return false;
            }
            if (!CompilerSettings.isStaticCompile() || !gosuPanel.getMessagesPanel().hasErrors()) {
                gosuPanel.showConsole(true);
                gosuPanel.clearOutput();
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            GosuPanel gosuPanel = CommonMenus.getGosuPanel();
            return gosuPanel != null && !gosuPanel.isRunning() && !gosuPanel.isDebugging();
        }
    }
}

