/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorHost;
import editor.ITabHistoryContext;
import editor.ITabHistoryHandler;
import editor.LabFrame;
import editor.util.EditorUtilities;
import gw.util.PathUtil;
import java.nio.file.Path;
import javax.swing.Icon;

public class EditorTabHistoryHandler
implements ITabHistoryHandler {
    @Override
    public ITabHistoryContext makeTabContext(EditorHost tab) {
        return new EditorTabContext(tab);
    }

    @Override
    public void selectTab(ITabHistoryContext tabContext) {
        if (tabContext == null) {
            return;
        }
        LabFrame.instance().selectTab(tabContext.getContentId());
    }

    @Override
    public void closeTab(ITabHistoryContext tabContext) {
        if (tabContext == null) {
            return;
        }
        LabFrame.instance().closeTab(tabContext.getContentId());
    }

    static class EditorTabContext
    implements ITabHistoryContext {
        private Path _contentId;

        public EditorTabContext(EditorHost editor) {
            this._contentId = (Path)editor.getClientProperty("_file");
        }

        @Override
        public String getDisplayName() {
            return PathUtil.getName((Path)this._contentId);
        }

        @Override
        public Icon getIcon(int iTypeFlags) {
            return EditorUtilities.findIcon(this._contentId);
        }

        @Override
        public boolean represents(EditorHost editor) {
            return editor != null && this._contentId.equals(editor.getClientProperty("_file"));
        }

        @Override
        public boolean equals(ITabHistoryContext other) {
            return this.equals((Object)other);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EditorTabContext that = (EditorTabContext)o;
            return this._contentId.equals(that._contentId);
        }

        @Override
        public int hashCode() {
            int result = this._contentId.hashCode();
            return result;
        }

        @Override
        public Path getContentId() {
            return this._contentId;
        }
    }
}

