/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.util.EditorUtilities;
import editor.util.ModalEventQueue;
import java.util.ArrayList;
import java.util.List;

class GosuEventQueue
extends ModalEventQueue {
    private static GosuEventQueue INSTANCE;
    private long _lErrMsgTime;
    private final List<Runnable> _idleListeners = new ArrayList<Runnable>();

    public static GosuEventQueue instance() {
        if (INSTANCE == null) {
            INSTANCE = new GosuEventQueue();
        }
        return INSTANCE;
    }

    private GosuEventQueue() {
        super(() -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleListener(Runnable l) {
        List<Runnable> list = this._idleListeners;
        synchronized (list) {
            this._idleListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIdleListener(Runnable l) {
        List<Runnable> list = this._idleListeners;
        synchronized (list) {
            return this._idleListeners.remove(l);
        }
    }

    @Override
    protected void handleUncaughtException(Throwable t) {
        if (System.currentTimeMillis() - this._lErrMsgTime > 5000L) {
            EditorUtilities.handleUncaughtException(t);
        }
        this._lErrMsgTime = System.currentTimeMillis();
    }

    @Override
    protected void executeIdleTasks() {
        for (int i = 0; i < this._idleListeners.size(); ++i) {
            Runnable task;
            try {
                task = this._idleListeners.get(i);
            }
            catch (Exception e) {
                break;
            }
            task.run();
        }
        super.executeIdleTasks();
    }
}

