/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractListCellRenderer;
import editor.AbstractPopup;
import editor.PopupListModel;
import editor.Scheme;
import editor.util.ContainerMoverSizer;
import editor.util.ContainerSizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;

public class ListPopup
extends AbstractPopup {
    private JList _list;
    protected PopupListModel _model;
    private EditorKeyListener _editorKeyListener;
    private UndoableEditListener _docListener;

    public ListPopup(JTextComponent editor, PopupListModel model) {
        super(editor);
        this._model = model;
        this.initLayout();
    }

    @Override
    public void show(Component invoker, int x, int y) {
        String strFilter = this.getModel().getFilterPrefix();
        if (strFilter != null && strFilter.length() > 0 && this._list.getModel().getSize() == 1) {
            this.fireNodeChanged(new ChangeEvent(this._model.getInsertionTextFrom(this._list.getModel().getElementAt(0))));
            this.setVisible(false);
            return;
        }
        super.show(invoker, x, y);
    }

    @Override
    public void setValue(Object value) {
        this._list.setSelectedValue(value, true);
    }

    public PopupListModel getModel() {
        return this._model;
    }

    public JList getJList() {
        return this._list;
    }

    protected void initLayout() {
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        JPanel pane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        CompoundBorder border = BorderFactory.createCompoundBorder(UIManager.getBorder("PopupMenu.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ContainerMoverSizer content = new ContainerMoverSizer(border);
        content.setLayout(new BorderLayout());
        PopupListModel listModel = this._model;
        int iY = 0;
        if (listModel != null && listModel.getModelUpdatedOrFilteredByPredicate().size() > 0) {
            JComponent caption = this.getCaptionComponent(listModel);
            c.anchor = 17;
            c.fill = 2;
            c.gridx = 0;
            c.gridy = iY++;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            pane.add((Component)caption, c);
        }
        this._list = new JList(listModel);
        this._list.addMouseListener(new MouseHandler());
        this._list.setCellRenderer(this.makeCellRenderer());
        this._list.getSelectionModel().setSelectionMode(0);
        this._list.setVisibleRowCount(10);
        JScrollPane scrollPane = new JScrollPane(this._list);
        scrollPane.setBorder(UIManager.getBorder("TextField.border"));
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        pane.add((Component)scrollPane, c);
        content.add((Component)pane, "Center");
        JPanel sizerPanel = new JPanel(new BorderLayout());
        sizerPanel.add((Component)new JPanel(), "Center");
        sizerPanel.add((Component)new ContainerSizer(), "East");
        content.add((Component)sizerPanel, "South");
        this.add(content);
        this._editorKeyListener = new EditorKeyListener();
        if (this.getEditor() != null) {
            this._editorKeyListener = new EditorKeyListener();
            this._docListener = e -> this.filterDisplay();
        }
    }

    public JComponent getCaptionComponent(PopupListModel listModel) {
        JLabel labelTypeName = new JLabel(listModel.getTypeName());
        labelTypeName.setOpaque(true);
        labelTypeName.setBackground(Scheme.active().getControl());
        labelTypeName.setFont(labelTypeName.getFont().deriveFont(1));
        labelTypeName.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        JPanel sortedByPanel = this.getSortedByPanel();
        if (sortedByPanel == null) {
            return labelTypeName;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)labelTypeName, "West");
        panel.add((Component)sortedByPanel, "East");
        return panel;
    }

    protected JPanel getSortedByPanel() {
        return null;
    }

    @Override
    public void refresh() {
        this._model = (PopupListModel)this._model.getFilteredModel(this._model.getFilterPrefix());
        this._list.setModel(this._model);
        this._list.setSelectedIndex(this._model.getSize() > 0 ? 0 : -1);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void registerListeners() {
        this.unregisterListeners();
        this.getEditor().addKeyListener(this._editorKeyListener);
        this.getEditor().getDocument().addUndoableEditListener(this._docListener);
    }

    @Override
    protected void unregisterListeners() {
        this.getEditor().getDocument().removeUndoableEditListener(this._docListener);
        this.getEditor().removeKeyListener(this._editorKeyListener);
    }

    @Override
    protected String filterDisplay() {
        String strPrefix = super.filterDisplay();
        this._list.setModel((PopupListModel)this._model.getFilteredModel(strPrefix));
        this._list.setSelectedIndex(0);
        this._list.revalidate();
        this._list.repaint();
        return strPrefix;
    }

    public void fireSelectionAndDismiss() {
        Object selection = this._list.getSelectedValue();
        if (selection != null) {
            this.fireNodeChanged(new ChangeEvent(this._model.getInsertionTextFrom(selection)));
            this.setVisible(false);
        }
    }

    protected ListCellRenderer makeCellRenderer() {
        return new DefaultCellRenderer(this._list);
    }

    public void selectElement(int i) {
        this._list.setSelectedIndex(i);
        this.fireSelectionAndDismiss();
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int iIndex = ListPopup.this._list.locationToIndex(e.getPoint());
            if (iIndex < 0) {
                return;
            }
            ListPopup.this._list.setSelectedIndex(iIndex);
            ListPopup.this.fireSelectionAndDismiss();
        }
    }

    class EditorKeyListener
    extends KeyAdapter {
        EditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 224 || e.getKeyCode() == 37 || e.getKeyCode() == 226) {
                Action selectPrevious = ListPopup.this._list.getActionMap().get("selectPreviousRow");
                selectPrevious.actionPerformed(new ActionEvent(ListPopup.this._list, 0, "selectPreviousRow"));
                e.consume();
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 225 || e.getKeyCode() == 39 || e.getKeyCode() == 227) {
                Action selectNext = ListPopup.this._list.getActionMap().get("selectNextRow");
                selectNext.actionPerformed(new ActionEvent(ListPopup.this._list, 0, "selectNextRow"));
                e.consume();
            } else if (e.getKeyCode() == 33) {
                Action scrollUpChangeSelection = ListPopup.this._list.getActionMap().get("scrollUp");
                scrollUpChangeSelection.actionPerformed(new ActionEvent(ListPopup.this._list, 0, "scrollUp"));
                e.consume();
            } else if (e.getKeyCode() == 34) {
                Action scrollDownChangeSelection = ListPopup.this._list.getActionMap().get("scrollDown");
                scrollDownChangeSelection.actionPerformed(new ActionEvent(ListPopup.this._list, 0, "scrollDown"));
                e.consume();
            } else if (e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 9) {
                ListPopup.this.fireSelectionAndDismiss();
                e.consume();
            } else if (e.getKeyCode() == 27) {
                ListPopup.this.setVisible(false);
                e.consume();
            }
        }
    }

    public class DefaultCellRenderer
    extends AbstractListCellRenderer {
        public DefaultCellRenderer(JComponent list) {
            super(list, true);
        }

        @Override
        public void configure() {
            this.setText(ListPopup.this._model.getDisplayText(this.getNode()));
        }
    }
}

