/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.util.EditorUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class SmartFixPopup
extends JPopupMenu {
    private JComponent _editor;

    public SmartFixPopup(String displayText) {
        this.initUI(displayText);
    }

    private void initUI(String displayText) {
        JLabel label = new JLabel(displayText);
        JPanel panel = new JPanel(true);
        label.setFont(label.getFont().deriveFont(1));
        panel.setBackground(new Color(181, 208, 251));
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        panel.add(label);
        this.add(panel);
    }

    public void show(JComponent editor, Rectangle offsetRectangle) {
        this._editor = editor;
        if (this._editor.isShowing()) {
            this.show(this._editor, offsetRectangle.x, offsetRectangle.y - 25);
        }
    }

    @Override
    public void setVisible(boolean bVisible) {
        Component focusOwner = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        super.setVisible(bVisible);
        if (bVisible && this._editor != null) {
            if (focusOwner == null || EditorUtilities.findAncestor(focusOwner, GosuEditor.class) == null) {
                this._editor.requestFocus();
            } else {
                focusOwner.requestFocus();
            }
        }
    }
}

