/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractPathCompletionHandler;
import editor.GosuEditor;
import editor.InitializerCompletionHandler;
import editor.SymbolPopup;
import editor.TypePopup;
import editor.util.EditorUtilities;
import editor.util.TextComponentUtil;
import gw.lang.GosuShop;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IParseTree;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.Keyword;
import gw.lang.reflect.IEnumType;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.GosuTypes;
import gw.util.GosuObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SymbolCompletionHandler
extends AbstractPathCompletionHandler {
    @Override
    public boolean handleCompletePath(ISymbolTable transientSymTable) {
        boolean isAtAsPosition;
        boolean bDotAtCaret;
        GosuEditor gsEditor = this.getGosuEditor();
        boolean bl = bDotAtCaret = GosuObjectUtil.equals((Object)TextComponentUtil.getWordAtCaret(gsEditor.getEditor()), (Object)".") || GosuObjectUtil.equals((Object)TextComponentUtil.getPartialWordBeforeCaret(gsEditor.getEditor()), (Object)".") || GosuObjectUtil.equals((Object)TextComponentUtil.getWordAtCaret(gsEditor.getEditor()), (Object)":") || GosuObjectUtil.equals((Object)TextComponentUtil.getPartialWordBeforeCaret(gsEditor.getEditor()), (Object)":");
        if (bDotAtCaret) {
            return false;
        }
        IParseTree locationAtCaret = gsEditor.getDeepestLocationAtCaret();
        if (locationAtCaret != null && InitializerCompletionHandler.isInitializerStart(locationAtCaret.getParsedElement())) {
            return false;
        }
        String strMemberPath = this.getSingleNameAtCaret();
        strMemberPath = strMemberPath != null ? strMemberPath.trim() : null;
        String wordBeforeCaret = TextComponentUtil.getPartialWordBeforeCaret(this.getGosuEditor().getEditor());
        boolean bl2 = isAtAsPosition = wordBeforeCaret != null && wordBeforeCaret.trim().equals(Keyword.KW_as.toString());
        if (gsEditor.isAltDown() || isAtAsPosition) {
            return this.displayTypesPopup(strMemberPath);
        }
        ArrayList<ISymbol> listSymbols = new ArrayList<ISymbol>(transientSymTable.getSymbols().values());
        this.filterUnwantedSymbols(listSymbols);
        IType expectedType = this.addValuesForType(listSymbols);
        ISymbol[] symbols = listSymbols.toArray(new ISymbol[listSymbols.size()]);
        SymbolPopup valuePopup = new SymbolPopup(symbols, strMemberPath, gsEditor, expectedType);
        valuePopup.addNodeChangeListener(e -> {
            String word = (String)e.getSource();
            if (word.endsWith("()")) {
                TextComponentUtil.replaceWordAtCaretDynamicAndRemoveEmptyParens(gsEditor.getEditor(), word, gsEditor.getReplaceWordCallback(), true, valuePopup.isReplaceWholeWord());
            } else {
                TextComponentUtil.replaceWordAtCaretDynamic(gsEditor.getEditor(), word, gsEditor.getReplaceWordCallback(), true, valuePopup.isReplaceWholeWord());
            }
            gsEditor.getEditor().requestFocus();
            EditorUtilities.fixSwingFocusBugWhenPopupCloses(gsEditor);
            gsEditor.getEditor().repaint();
        });
        gsEditor.setCompletionPopup(valuePopup);
        gsEditor.displayCompletionPopup(gsEditor.getEditor().getCaretPosition());
        if (!valuePopup.isShowing() && !valuePopup.wasAutoDismissed()) {
            return this.displayTypesPopup(strMemberPath);
        }
        return false;
    }

    private IType addValuesForType(List<ISymbol> listSymbols) {
        IType expectedType = this.getGosuEditor().findExpectedTypeErrorAtCaret();
        if (expectedType != null && expectedType.isEnum()) {
            int[] i = new int[]{0};
            ((IEnumType)expectedType).getEnumConstants().forEach(e -> {
                int n = i[0];
                i[0] = n + 1;
                listSymbols.add(n, GosuShop.createSymbol((CharSequence)e, (IType)expectedType, null));
            });
        }
        return expectedType;
    }

    private void filterUnwantedSymbols(Collection<ISymbol> listSymbols) {
        ArrayList<ISymbol> deleteSyms = new ArrayList<ISymbol>();
        for (ISymbol s : listSymbols) {
            if (s.getType() == GosuTypes.DEF_CTOR_TYPE() || s instanceof IDynamicFunctionSymbol && ((IDynamicFunctionSymbol)s).isConstructor()) {
                deleteSyms.add(s);
                continue;
            }
            if (!(s instanceof IDynamicFunctionSymbol) || !s.getName().startsWith("@")) continue;
            deleteSyms.add(s);
        }
        listSymbols.removeAll(deleteSyms);
    }

    boolean displayTypesPopup(String strPrefix) {
        TypePopup popup = new TypePopup(strPrefix, this.getGosuEditor(), this.isAnnotationsOnly());
        this.getGosuEditor().setCompletionPopup(popup);
        boolean addUsesAutomatically = this.getGosuEditor().acceptsUses();
        popup.addNodeChangeListener(e -> {
            String strQualifedType = (String)e.getSource();
            String strRelativeType = TypePopup.getRelativeTypeName(strQualifedType);
            String strPartialType = strQualifedType;
            if (strPartialType.contains(TextComponentUtil.getWordAtCaret(this.getGosuEditor().getEditor()))) {
                strPartialType = strPartialType.substring(strPartialType.indexOf(TextComponentUtil.getWordAtCaret(this.getGosuEditor().getEditor())));
            }
            if (addUsesAutomatically) {
                this.getGosuEditor().addToUses(strQualifedType);
            }
            if (!addUsesAutomatically || !GosuObjectUtil.equals((Object)TextComponentUtil.getPartialWordBeforeCaret(this.getGosuEditor().getEditor()), (Object)strRelativeType)) {
                TextComponentUtil.replaceWordAtCaretDynamic(this.getGosuEditor().getEditor(), addUsesAutomatically ? strRelativeType : strPartialType, this.getGosuEditor().getReplaceWordCallback(), false, popup.isReplaceWholeWord());
            }
            this.getGosuEditor().getEditor().requestFocus();
            EditorUtilities.fixSwingFocusBugWhenPopupCloses(this.getGosuEditor());
            this.getGosuEditor().getEditor().repaint();
        });
        this.getGosuEditor().displayCompletionPopup(this.getGosuEditor().getEditor().getCaretPosition());
        return true;
    }

    protected boolean isAnnotationsOnly() {
        return false;
    }
}

