/*
 * Decompiled with CFR 0.152.
 */
package editor;

import gw.lang.GosuShop;
import gw.lang.parser.IGosuValidator;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IParserState;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.resources.Res;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;

public class TypeNameValidator
implements IGosuValidator {
    private final IType _expectedType;
    private final ITypeUsesMap _typeUsesMap;

    public TypeNameValidator(IType expectedType) {
        this(expectedType, null);
    }

    public TypeNameValidator(IType expectedType, ITypeUsesMap typeUsesMap) {
        this._expectedType = expectedType;
        this._typeUsesMap = typeUsesMap;
    }

    public void validate(IParsedElement rootParsedElement, String scriptSrc) {
        IType actualType = this.getType(scriptSrc);
        if (actualType == null) {
            rootParsedElement.addParseException((IParseIssue)new ParseException((IParserState)GosuShop.createStandardParserState((IParsedElement)rootParsedElement, (String)scriptSrc, (boolean)true), Res.MSG_INVALID_TYPE, new Object[]{scriptSrc}));
        } else if (!this._expectedType.isAssignableFrom(actualType)) {
            rootParsedElement.addParseException((IParseIssue)new ParseException((IParserState)GosuShop.createStandardParserState((IParsedElement)rootParsedElement, (String)scriptSrc, (boolean)true), Res.MSG_TYPE_MISMATCH, new Object[]{this._expectedType.getDisplayName(), actualType.getDisplayName()}));
        }
    }

    private IType getType(String name) {
        Object type;
        try {
            type = TypeSystem.getByFullName((String)name);
        }
        catch (Exception e) {
            type = this._typeUsesMap != null ? this._typeUsesMap.resolveType(name) : null;
        }
        return type;
    }
}

