/*
 * Decompiled with CFR 0.152.
 */
package editor.debugger;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Value;
import editor.FileTree;
import editor.FileTreeUtil;
import editor.LabFrame;
import editor.debugger.DebuggerExpression;
import editor.search.StringUtil;
import editor.util.EditorUtilities;
import gw.lang.parser.IParseTree;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.json.IJsonIO;
import gw.util.concurrent.LocklessLazyVar;
import javax.swing.JOptionPane;

public class Breakpoint
implements IJsonIO {
    public static final LocklessLazyVar<Breakpoint> ANY_EXCEPTION = new LocklessLazyVar<Breakpoint>(){

        protected Breakpoint init() {
            Breakpoint anyException = new Breakpoint("java.lang.Throwable", true, true, true);
            anyException.setActive(false);
            return anyException;
        }
    };
    private String _fqn;
    private String _fqnDeclaring;
    private int _line;
    private String _expr;
    private boolean _active;
    private boolean _static;
    private boolean _suspend;
    private boolean _bRunScript;
    private String _runScript;
    private boolean _caughtException;
    private boolean _uncaughtException;
    private transient int _offset;
    private transient String _fileName;
    private transient String _immediateClass;
    private transient LocklessLazyVar<DebuggerExpression> _debuggerExpr;
    private transient LocklessLazyVar<DebuggerExpression> _debuggerRunScript;

    public Breakpoint(String fqnException, boolean notifyCaught, boolean notifyUncaught) {
        this(fqnException, notifyCaught, notifyUncaught, false);
    }

    public Breakpoint(String fqnException, boolean notifyCaught, boolean notifyUncaught, boolean staticBp) {
        this(fqnException, fqnException, 0, null);
        this._caughtException = notifyCaught;
        this._uncaughtException = notifyUncaught;
        this._static = staticBp;
    }

    public Breakpoint(String fqn, String fqnDeclaring, int line) {
        this(fqn, fqnDeclaring, line, null);
    }

    public Breakpoint(String fqn, String fqnDeclaring, int line, String expr) {
        this._fqn = fqn;
        this._fqnDeclaring = fqnDeclaring;
        this._line = line;
        this._active = true;
        this._expr = expr;
        this._suspend = true;
        this._debuggerExpr = LocklessLazyVar.make(() -> new DebuggerExpression(this._expr, this.isLineBreakpoint() ? this._fqn : null, this._immediateClass, this._offset));
        this._debuggerRunScript = LocklessLazyVar.make(() -> new DebuggerExpression(this._runScript, this.isLineBreakpoint() ? this._fqn : null, this._immediateClass, this._offset));
    }

    private Breakpoint() {
    }

    private String makeJavaName(String fqn, String fqnDeclaring) {
        if (fqn.length() >= fqnDeclaring.length()) {
            return fqnDeclaring;
        }
        return fqn + fqnDeclaring.substring(fqn.length()).replace('.', '$');
    }

    public boolean isLineBreakpoint() {
        return this._line > 0;
    }

    public boolean isExceptionBreakpoint() {
        return !this.isLineBreakpoint();
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public String getTitle() {
        if (this._line <= 0) {
            return this == ANY_EXCEPTION.get() ? "Any exception" : this._fqn;
        }
        return "Line " + this._line + " in " + this.getFileName();
    }

    private String getFileName() {
        FileTree fileTree;
        if (this._line > 0 && this._fileName == null && (fileTree = FileTreeUtil.find(this._fqn)) != null) {
            this._fileName = fileTree.getName();
        }
        return this._fileName;
    }

    public String getFqn() {
        return this._fqn;
    }

    public String getDeclaringFqn() {
        return this._fqnDeclaring;
    }

    public String getDeclaringFqn_Java() {
        return this.makeJavaName(this.getFqn(), this.getDeclaringFqn());
    }

    public int getLine() {
        return this._line;
    }

    public int getOffset() {
        this.locate();
        return this._offset;
    }

    public String getExpression() {
        return this._expr;
    }

    public void setExpression(String expr) {
        this._expr = expr;
        this._debuggerExpr.clear();
    }

    public boolean isActiveWhenMuted() {
        return false;
    }

    public boolean isTemporary() {
        return false;
    }

    public boolean condition() {
        String expr;
        boolean suspend;
        String runScript;
        if (this.isRunScriptOn() && (runScript = this.getRunScript()) != null && runScript.length() > 0) {
            try {
                ((DebuggerExpression)this._debuggerRunScript.get()).evaluate(LabFrame.instance().getGosuPanel().getDebugger());
            }
            catch (InvocationException e) {
                return this.promptToSuspend();
            }
        }
        if ((suspend = this.isSuspend()) && (expr = this.getExpression()) != null && !expr.isEmpty()) {
            boolean canEvaluateCondition;
            boolean bl = canEvaluateCondition = this.isLineBreakpoint() && this.locate();
            if (canEvaluateCondition) {
                try {
                    Value value = ((DebuggerExpression)this._debuggerExpr.get()).evaluate(LabFrame.instance().getGosuPanel().getDebugger());
                    if (!(value instanceof BooleanValue)) {
                        return this.promptToSuspend();
                    }
                    BooleanValue result = (BooleanValue)value;
                    suspend = result == null || result.value();
                }
                catch (InvocationException e) {
                    return this.promptToSuspend();
                }
            }
        }
        return suspend;
    }

    private boolean promptToSuspend() {
        boolean[] shouldSuspend = new boolean[]{true};
        EditorUtilities.invokeInDispatchThread(() -> {
            shouldSuspend[0] = 0 == JOptionPane.showConfirmDialog(LabFrame.instance(), "<html>Trouble evaluating debugger expression.<br>Stop at breakpoint?", "Gosu Lab", 0);
        });
        return shouldSuspend[0];
    }

    private boolean locate() {
        if (this._immediateClass != null) {
            return true;
        }
        if (this._line <= 0) {
            return false;
        }
        IGosuClass topLevelClass = (IGosuClass)TypeSystem.getByFullName((String)this._fqn);
        this._offset = StringUtil.getLineOffset(topLevelClass.getSource(), this._line);
        topLevelClass.isValid();
        IParseTree loc = topLevelClass.getClassStatement().getLocation().getDeepestLocation(this._offset, false);
        if (loc == null) {
            return false;
        }
        int i = 0;
        while (loc != null && loc.getOffset() < this._offset) {
            loc = topLevelClass.getClassStatement().getLocation().getDeepestLocation(this._offset + ++i, true);
        }
        if (loc == null) {
            return false;
        }
        this._offset = loc.getOffset();
        this._immediateClass = loc.getParsedElement().getGosuClass().getName();
        return true;
    }

    public boolean isStatic() {
        return this._static;
    }

    public void setStatic(boolean aStatic) {
        this._static = aStatic;
    }

    public boolean isSuspend() {
        return this._suspend;
    }

    public void setSuspend(boolean suspend) {
        this._suspend = suspend;
    }

    public boolean isRunScriptOn() {
        return this._bRunScript;
    }

    public void setRunScriptOn(boolean bRunScript) {
        this._bRunScript = bRunScript;
    }

    public String getRunScript() {
        return this._runScript;
    }

    public void setRunScript(String runScript) {
        this._runScript = runScript;
        this._debuggerRunScript.clear();
    }

    public boolean isCaughtException() {
        return this._caughtException;
    }

    public void setCaughtException(boolean caughtException) {
        this._caughtException = caughtException;
    }

    public boolean isUncaughtException() {
        return this._uncaughtException;
    }

    public void setUncaughtException(boolean uncaughtException) {
        this._uncaughtException = uncaughtException;
    }
}

