/*
 * Decompiled with CFR 0.152.
 */
package editor.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import editor.LabFrame;
import editor.MessagesPanel;
import editor.Scheme;
import editor.debugger.DebugPanel;
import editor.debugger.ValueKind;
import editor.util.EditorUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class VarTree
implements MutableTreeNode {
    private final String _name;
    private final String _type;
    private final Value _value;
    private VarTree _parent;
    private List<VarTree> _children;

    public VarTree(DebugPanel.StackFrameRef ref) {
        this._name = null;
        this._type = null;
        this._value = null;
        this._children = Collections.emptyList();
        if (ref == null) {
            return;
        }
        StackFrame frame = ref.getRef();
        ObjectReference thisObj = frame.thisObject();
        if (thisObj != null) {
            this.insert(new VarTree("this", thisObj.referenceType().name(), thisObj));
        }
        try {
            frame = ref.getRef();
            Map<LocalVariable, Value> values = frame.getValues(frame.visibleVariables());
            for (LocalVariable v : frame.visibleVariables()) {
                this.insert(new VarTree(v.name(), v.typeName(), values.get(v)));
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    public VarTree(String name, String type, Value value) {
        this(name, type, value, true);
    }

    private VarTree(String name, String type, Value value, boolean bExpand) {
        this._name = name;
        this._type = type;
        this._value = value;
        this._children = Collections.emptyList();
        if (bExpand) {
            this.expand();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public Value getValue() {
        return this._value;
    }

    private void expand() {
        if (this._children == Collections.emptyList()) {
            this._children = new ArrayList<VarTree>();
            this.showValue(this._value);
        }
    }

    private void showValue(Value value) {
        switch (VarTree.getValueKind(value)) {
            case Null: {
                break;
            }
            case Primitive: {
                break;
            }
            case Array: {
                this.showArrayElements((ArrayReference)value);
                break;
            }
            case Object: {
                ObjectReference ref = (ObjectReference)value;
                ReferenceType type = ref.referenceType();
                this.showFields(ref, type);
                break;
            }
            case Collection: {
                ObjectReference ref = (ObjectReference)value;
                ReferenceType type = ref.referenceType();
                Method toArray = (Method)type.methodsByName("toArray").stream().filter(e -> e.argumentTypeNames().size() == 0).collect(Collectors.toList()).get(0);
                ThreadReference thread = LabFrame.instance().getGosuPanel().getDebugger().getSuspendedThread();
                try {
                    ArrayReference elements = (ArrayReference)ref.invokeMethod(thread, toArray, Collections.emptyList(), 0);
                    this.showValue(elements);
                    break;
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            case Map: {
                ObjectReference ref = (ObjectReference)value;
                ReferenceType type = ref.referenceType();
                Method toArray = (Method)type.methodsByName("entrySet").stream().filter(e -> e.argumentTypeNames().size() == 0).collect(Collectors.toList()).get(0);
                ThreadReference thread = LabFrame.instance().getGosuPanel().getDebugger().getSuspendedThread();
                try {
                    ObjectReference entries = (ObjectReference)ref.invokeMethod(thread, toArray, Collections.emptyList(), 0);
                    this.showValue(entries);
                    break;
                }
                catch (Exception e3) {
                    throw new RuntimeException(e3);
                }
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    static ValueKind getValueKind(Value value) {
        if (value == null) {
            return ValueKind.Null;
        }
        if (value instanceof PrimitiveValue) {
            return ValueKind.Primitive;
        }
        if (value instanceof ArrayReference) {
            return ValueKind.Array;
        }
        ClassType classType = (ClassType)((ObjectReference)value).referenceType();
        List interfaces = classType.allInterfaces().stream().map(ReferenceType::name).collect(Collectors.toList());
        if (interfaces.contains("java.util.Collection")) {
            return ValueKind.Collection;
        }
        if (interfaces.contains("java.util.Map")) {
            return ValueKind.Map;
        }
        return ValueKind.Object;
    }

    private void showFields(ObjectReference ref, ReferenceType type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        List<Field> allFields = type.allFields();
        for (Field field : allFields) {
            if (field.isFinal() && field.isStatic()) continue;
            fields.add(field);
        }
        if (!fields.isEmpty()) {
            Map<Field, Value> mapFields = ref.getValues(fields);
            for (Field field : allFields) {
                if (!mapFields.containsKey(field)) continue;
                this.insert(new VarTree(field.name(), field.typeName(), mapFields.get(field), false));
            }
        }
    }

    private void showArrayElements(ArrayReference ref) {
        List<Value> elems = ref.getValues();
        for (int i = 0; i < elems.size(); ++i) {
            Value elem = elems.get(i);
            if (elem == null) continue;
            this.insert(new VarTree("[<font color=#" + EditorUtilities.hex(Scheme.active().debugVarRedText()) + ">" + i + "</font>]", elem.type().name(), elem, false));
        }
    }

    public boolean isTerminal() {
        return !this.isRoot() && (this._value == null || !(this._value instanceof ObjectReference));
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public List<VarTree> getChildren() {
        this.expand();
        return this._children;
    }

    public void insert(MutableTreeNode child) {
        this.insert(child, this.getChildCount());
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        if (this._children.isEmpty()) {
            this._children = new ArrayList<VarTree>();
        }
        this._children.add(index, (VarTree)child);
        child.setParent(this);
    }

    public void addViaModel(MutableTreeNode child) {
        ((DefaultTreeModel)this.getTree().getModel()).insertNodeInto(child, this, this.getChildCount());
    }

    public void insertViaModel(MutableTreeNode child, int index) {
        ((DefaultTreeModel)this.getTree().getModel()).insertNodeInto(child, this, index);
    }

    @Override
    public void remove(int index) {
        this.remove(this.getChildren().get(index));
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.getChildren().remove(node);
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public void removeFromParent() {
        this._parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this._parent = (VarTree)newParent;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.getChildren().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public VarTree getParent() {
        return this._parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isTerminal();
    }

    @Override
    public boolean isLeaf() {
        return this.isTerminal();
    }

    public Enumeration children() {
        final Iterator<VarTree> iter = this.getChildren().iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    public String toString() {
        return "Name: " + this._name + "\n Type: " + this._type + "\n Value: " + this._value;
    }

    public void select() {
        JTree tree = this.getMessagesPanel().getTree();
        TreePath path = this.getPath();
        tree.expandPath(path);
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public TreePath getPath() {
        List<VarTree> path = this.makePath(new ArrayList<VarTree>());
        return new TreePath(path.toArray(new VarTree[path.size()]));
    }

    private List<VarTree> makePath(List<VarTree> path) {
        if (this.getParent() != null) {
            this.getParent().makePath(path);
        }
        path.add(this);
        return path;
    }

    private MessagesPanel getMessagesPanel() {
        return LabFrame.instance().getGosuPanel().getMessagesPanel();
    }

    public Icon getIcon() {
        return this.findIcon();
    }

    private Icon findIcon() {
        return this._value instanceof ArrayReference ? EditorUtilities.loadIcon("images/array.png") : (this._value == null || this._value instanceof ObjectReference ? EditorUtilities.loadIcon("images/object.png") : EditorUtilities.loadIcon("images/primitive.png"));
    }

    public JTree getTree() {
        return LabFrame.instance().getGosuPanel().getMessagesPanel().getTree();
    }

    public static boolean hasSuperClass(ReferenceType referenceType, String typeName) {
        if (referenceType == null) {
            return false;
        }
        if (referenceType.name().equals(typeName)) {
            return true;
        }
        if (!(referenceType instanceof ClassType)) {
            return false;
        }
        return VarTree.hasSuperClass(((ClassType)referenceType).superclass(), typeName);
    }
}

