/*
 * Decompiled with CFR 0.152.
 */
package editor.run;

import editor.run.IRunConfig;
import editor.run.IRunConfigFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RunConfigTree
implements MutableTreeNode {
    private IRunConfig _runConfig;
    private IRunConfigFactory _factory;
    private RunConfigTree _parent;
    private List<RunConfigTree> _children;

    public RunConfigTree() {
        this._children = Collections.emptyList();
    }

    public RunConfigTree(IRunConfigFactory factory, RunConfigTree parent) {
        this._parent = parent;
        this._factory = factory;
        this._children = Collections.emptyList();
    }

    public RunConfigTree(IRunConfig runConfig, RunConfigTree parent) {
        this._parent = parent;
        this._runConfig = runConfig;
        this._children = Collections.emptyList();
    }

    public IRunConfig getRunConfig() {
        return this._runConfig;
    }

    public IRunConfigFactory getFactory() {
        return this._factory;
    }

    public boolean isTerminal() {
        return this.getRunConfig() != null;
    }

    public List<RunConfigTree> getChildren() {
        return this._children;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        if (this._children.isEmpty()) {
            this._children = new ArrayList<RunConfigTree>();
        }
        this._children.add(index, (RunConfigTree)child);
        child.setParent(this);
    }

    public void addChild(RunConfigTree child) {
        this.insert(child, this._children.size());
    }

    public void addViaModel(JTree tree, MutableTreeNode child) {
        ((DefaultTreeModel)tree.getModel()).insertNodeInto(child, this, this.getChildCount());
    }

    public void insertViaModel(JTree tree, MutableTreeNode child, int index) {
        ((DefaultTreeModel)tree.getModel()).insertNodeInto(child, this, index);
    }

    public void deleteViaModel(JTree tree, MutableTreeNode child) {
        ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(child);
    }

    @Override
    public void remove(int index) {
        this.remove(this.getChildren().get(index));
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.getChildren().remove(node);
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public void removeFromParent() {
        this._parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this._parent = (RunConfigTree)newParent;
    }

    @Override
    public RunConfigTree getChildAt(int childIndex) {
        return this.getChildren().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public RunConfigTree getParent() {
        return this._parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isTerminal();
    }

    @Override
    public boolean isLeaf() {
        return this.isTerminal();
    }

    public Enumeration children() {
        final Iterator<RunConfigTree> iter = this.getChildren().iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    public String toString() {
        return this._runConfig != null ? this._runConfig.getName() : (this._factory != null ? this._factory.getName() : "<root>");
    }

    public void select(JTree tree) {
        TreePath path = this.getPath();
        tree.expandPath(path);
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public TreePath getPath() {
        List<RunConfigTree> path = this.makePath(new ArrayList<RunConfigTree>());
        return new TreePath(path.toArray(new RunConfigTree[path.size()]));
    }

    private List<RunConfigTree> makePath(List<RunConfigTree> path) {
        if (this.getParent() != null) {
            this.getParent().makePath(path);
        }
        path.add(this);
        return path;
    }

    public RunConfigTree find(IRunConfig runConfig) {
        if (runConfig.equals(this.getRunConfig())) {
            return this;
        }
        for (RunConfigTree tree : this.getChildren()) {
            RunConfigTree found = tree.find(runConfig);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Icon getIcon() {
        return this._runConfig != null ? this._runConfig.getIcon() : (this._factory != null ? this._factory.getIcon() : null);
    }
}

