/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.ClearablePanel;
import editor.GosuPanel;
import editor.LabFrame;
import editor.LabTreeCellRenderer;
import editor.Scheme;
import editor.search.SearchTree;
import editor.search.SearchTreeContextMenu;
import editor.util.EditorUtilities;
import editor.util.LabButton;
import editor.util.LabToolbarButton;
import editor.util.ToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.MatteBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SearchPanel
extends ClearablePanel {
    private JTree _tree;
    private JPanel _replaceButtonPanel;
    private String _replacePattern;
    private JButton _btnReplaceAll;
    private JButton _btnReplaceSelected;

    public SearchPanel() {
        this.setLayout(new BorderLayout());
        this.configUi();
    }

    private void configUi() {
        this._tree = new JTree();
        this._tree.setModel(new DefaultTreeModel(new SearchTree(this._tree)));
        this._tree.setBackground(Scheme.active().getWindow());
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.setRowHeight(22);
        this._tree.getSelectionModel().setSelectionMode(4);
        this._tree.setVisibleRowCount(20);
        this._tree.setCellRenderer(new LabTreeCellRenderer(this._tree));
        this._tree.addMouseListener(new MouseHandler());
        this._tree.addKeyListener(new TreeKeyHandler());
        this._tree.addTreeSelectionListener(new TreeSelectionHandler());
        JScrollPane scroller = new JScrollPane(this._tree);
        scroller.setBorder(new MatteBorder(0, 1, 1, 1, Scheme.active().getScrollbarBorderColor()));
        this.add((Component)scroller, "Center");
        this.add((Component)this.makeToolbar(), "West");
        this.addReplaceButtonsPanel();
    }

    private JComponent makeToolbar() {
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.setBackground(Scheme.active().getMenu());
        toolbarPanel.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        ToolBar toolbar = new ToolBar(1);
        LabToolbarButton item = new LabToolbarButton(new AbstractAction("Rerun", EditorUtilities.loadIcon("images/rerun.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        toolbar.add(item);
        item = new LabToolbarButton(new AbstractAction("Close", EditorUtilities.loadIcon("images/close.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.getGosuPanel().showSearches(false);
            }
        });
        toolbar.add(item);
        item = new LabToolbarButton(new AbstractAction("Expand All", EditorUtilities.loadIcon("images/expandall.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.expandAll();
            }
        });
        toolbar.add(item);
        item = new LabToolbarButton(new AbstractAction("Collapse All", EditorUtilities.loadIcon("images/collapseall.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.getTree().collapseRow(0);
            }
        });
        toolbar.add(item);
        item = new LabToolbarButton(new AbstractAction("Previous", EditorUtilities.loadIcon("images/up.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.gotoPreviousItem();
            }
        });
        toolbar.add(item);
        item = new LabToolbarButton(new AbstractAction("Next", EditorUtilities.loadIcon("images/down.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.gotoNextItem();
            }
        });
        toolbar.add(item);
        toolbarPanel.add((Component)toolbar, "Center");
        return toolbarPanel;
    }

    public void gotoPreviousItem() {
        SearchTree parent;
        int index;
        TreePath selectionPath = this._tree.getSelectionPath();
        SearchTree tree = selectionPath != null ? (SearchTree)selectionPath.getLastPathComponent() : (SearchTree)this.getTree().getModel().getRoot();
        Object data = tree.getNode();
        tree = data != null && data.hasTarget() ? ((index = (parent = (SearchTree)tree.getParent()).getIndex(tree)) != 0 ? (SearchTree)parent.getChildAt(index - 1) : this.findLastLeaf(this.findPrevAncestorSibling(tree))) : this.findLastLeaf(tree);
        if (tree != null) {
            tree.select();
            ((SearchTree.SearchTreeNode)tree.getNode()).jumpToTarget();
        }
    }

    public void gotoNextItem() {
        SearchTree parent;
        int index;
        TreePath selectionPath = this._tree.getSelectionPath();
        SearchTree tree = selectionPath != null ? (SearchTree)selectionPath.getLastPathComponent() : (SearchTree)this.getTree().getModel().getRoot();
        Object data = tree.getNode();
        tree = data != null && data.hasTarget() ? ((index = (parent = (SearchTree)tree.getParent()).getIndex(tree)) < parent.getChildCount() - 1 ? (SearchTree)parent.getChildAt(index + 1) : this.findFirstLeaf(this.findNextAncestorSibling(tree))) : this.findFirstLeaf(tree);
        if (tree != null) {
            tree.select();
            ((SearchTree.SearchTreeNode)tree.getNode()).jumpToTarget();
        }
    }

    private SearchTree findFirstLeaf(SearchTree tree) {
        if (tree == null) {
            return null;
        }
        Object data = tree.getNode();
        if (data != null && data.hasTarget()) {
            return tree;
        }
        if (tree.getChildCount() > 0) {
            for (SearchTree child : tree.getChildren()) {
                SearchTree leaf = this.findFirstLeaf(child);
                if (leaf == null) continue;
                return leaf;
            }
        }
        return null;
    }

    private SearchTree findLastLeaf(SearchTree tree) {
        if (tree == null) {
            return null;
        }
        Object data = tree.getNode();
        if (data != null && data.hasTarget()) {
            return tree;
        }
        if (tree.getChildCount() > 0) {
            List children = tree.getChildren();
            for (int i = children.size() - 1; i >= 0; --i) {
                SearchTree child = (SearchTree)children.get(i);
                SearchTree leaf = this.findLastLeaf(child);
                if (leaf == null) continue;
                return leaf;
            }
        }
        return null;
    }

    private SearchTree findNextAncestorSibling(SearchTree tree) {
        SearchTree parent = (SearchTree)tree.getParent();
        if (parent == null) {
            return null;
        }
        int index = parent.getIndex(tree);
        if (index < parent.getChildCount() - 1) {
            return (SearchTree)parent.getChildAt(index + 1);
        }
        return this.findNextAncestorSibling(parent);
    }

    private SearchTree findPrevAncestorSibling(SearchTree tree) {
        SearchTree parent = (SearchTree)tree.getParent();
        if (parent == null) {
            return null;
        }
        int index = parent.getIndex(tree);
        if (index > 0) {
            return (SearchTree)parent.getChildAt(index - 1);
        }
        return this.findPrevAncestorSibling(parent);
    }

    private GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }

    private void addReplaceButtonsPanel() {
        this._replaceButtonPanel = new JPanel(new BorderLayout());
        this._replaceButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
        JPanel filler = new JPanel();
        this._replaceButtonPanel.add((Component)filler, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this._btnReplaceAll = new LabButton("Replace All");
        this._btnReplaceAll.setMnemonic('A');
        this._btnReplaceAll.addActionListener(e -> this.replaceAll());
        buttonPanel.add(this._btnReplaceAll);
        this._btnReplaceSelected = new LabButton("Replace Selected");
        this._btnReplaceSelected.addActionListener(e -> this.replaceSelected());
        buttonPanel.add(this._btnReplaceSelected);
        this._replaceButtonPanel.add((Component)buttonPanel, "West");
    }

    void setReplacePattern(String pattern) {
        this._replacePattern = pattern;
    }

    private void replaceSelected() {
        this._btnReplaceAll.setEnabled(false);
        this._btnReplaceSelected.setEnabled(false);
        int count = this._tree.getSelectionModel().getSelectionCount();
        if (count == 0) {
            return;
        }
        ArrayList<SearchTree> list = new ArrayList<SearchTree>(count);
        for (TreePath path : this._tree.getSelectionModel().getSelectionPaths()) {
            SearchTree selection = (SearchTree)path.getLastPathComponent();
            list.add(selection);
        }
        list.sort((l, r) -> {
            SearchTree.SearchTreeNode node;
            if (l.getParent() == r.getParent() && (node = (SearchTree.SearchTreeNode)l.getNode()) != null && node.getLocation() != null && node.getFile() == ((SearchTree.SearchTreeNode)r.getNode()).getFile()) {
                return ((SearchTree.SearchTreeNode)r.getNode()).getLocation()._iOffset - node.getLocation()._iOffset;
            }
            return 0;
        });
        for (SearchTree selection : list) {
            selection.replace(this._replacePattern);
        }
    }

    private void replaceAll() {
        this._btnReplaceAll.setEnabled(false);
        this._btnReplaceSelected.setEnabled(false);
        SearchTree root = (SearchTree)this._tree.getModel().getRoot();
        root.replace(this._replacePattern);
    }

    public JTree getTree() {
        return this._tree;
    }

    public void showReplace(boolean show) {
        if (show) {
            this._btnReplaceAll.setEnabled(true);
            this._btnReplaceSelected.setEnabled(true);
            if (this._replaceButtonPanel.getParent() == null) {
                this.add((Component)this._replaceButtonPanel, "South");
            }
        } else if (!show && this._replaceButtonPanel.getParent() != null) {
            this.remove(this._replaceButtonPanel);
        }
        this.revalidate();
    }

    @Override
    public void clear() {
        this._tree.setModel(new DefaultTreeModel(new SearchTree(this._tree)));
    }

    @Override
    public void dispose() {
        this.getGosuPanel().showSearches(false);
    }

    public SearchTree getSelectedTree() {
        return (SearchTree)this._tree.getLastSelectedPathComponent();
    }

    public void add(SearchTree message) {
        SearchTree root = (SearchTree)this._tree.getModel().getRoot();
        root.addViaModel(message);
    }

    public void expandAll() {
        this.expandAll(0, this._tree.getRowCount());
    }

    void expandAll(int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            this._tree.expandRow(i);
        }
        if (this._tree.getRowCount() != rowCount) {
            this.expandAll(rowCount, this._tree.getRowCount());
        }
    }

    private class TreeSelectionHandler
    implements TreeSelectionListener {
        private TreeSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!e.isAddedPath()) {
                return;
            }
            int count = SearchPanel.this._tree.getSelectionCount();
            if (count <= 1) {
                return;
            }
            SearchTree newSelection = (SearchTree)e.getPath().getLastPathComponent();
            List<SearchTree> selections = this.getSelections();
            this.removeAncestors((SearchTree)newSelection.getParent(), selections);
            Iterator<SearchTree> iter = selections.iterator();
            while (iter.hasNext()) {
                SearchTree child = iter.next();
                if (newSelection == child || !this.removeDescendant(newSelection, child)) continue;
                iter.remove();
            }
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            for (SearchTree sel : selections) {
                paths.add(sel.getPath());
            }
            SearchPanel.this._tree.getSelectionModel().setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
        }

        private boolean removeDescendant(SearchTree newSelection, SearchTree csr) {
            if (csr == null) {
                return false;
            }
            if (csr == newSelection) {
                return true;
            }
            return this.removeDescendant(newSelection, (SearchTree)csr.getParent());
        }

        private void removeAncestors(SearchTree selection, List<SearchTree> selections) {
            if (selection == null) {
                return;
            }
            if (selections.contains(selection)) {
                selections.remove(selection);
            }
            this.removeAncestors((SearchTree)selection.getParent(), selections);
        }

        private List<SearchTree> getSelections() {
            ArrayList<SearchTree> list = new ArrayList<SearchTree>();
            for (TreePath path : SearchPanel.this._tree.getSelectionModel().getSelectionPaths()) {
                SearchTree selection = (SearchTree)path.getLastPathComponent();
                list.add(selection);
            }
            return list;
        }
    }

    private class TreeKeyHandler
    implements KeyListener {
        private TreeKeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            SearchTree selection;
            if (e.getKeyCode() == 10 && (selection = SearchPanel.this.getSelectedTree()) != null && selection.isTerminal()) {
                ((SearchTree.SearchTreeNode)selection.getNode()).jumpToTarget();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class MouseHandler
    implements MouseListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SearchTree tree;
            Object data;
            TreePath selectionPath;
            if (e.getClickCount() == 2 && (selectionPath = SearchPanel.this._tree.getSelectionPath()) != null && (data = (tree = (SearchTree)selectionPath.getLastPathComponent()).getNode()) != null && data.hasTarget()) {
                data.jumpToTarget();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleContextMenu(e);
        }

        private void handleContextMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int row = SearchPanel.this._tree.getRowForLocation(e.getX(), e.getY());
                TreePath path = SearchPanel.this._tree.getPathForLocation(e.getX(), e.getY());
                SearchPanel.this._tree.setSelectionPath(path);
                if (row > -1) {
                    SearchPanel.this._tree.setSelectionRow(row);
                    EventQueue.invokeLater(() -> new SearchTreeContextMenu().displayContextMenu((SearchTree)path.getLastPathComponent(), e.getX(), e.getY(), (Component)SearchPanel.this._tree));
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

