/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.util.EditorUtilities;
import editor.util.LabToolbarButton;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class DirectoryEditor
extends JPanel {
    private JTextField _editDir;
    private LabToolbarButton _btnDir;

    public DirectoryEditor(String title, String dir, Supplier<Frame> frame) {
        super(new GridBagLayout());
        this.configUi(title, dir, frame);
    }

    public Document getDocument() {
        return this._editDir.getDocument();
    }

    public String getText() {
        return this._editDir.getText();
    }

    public void setText(String path) {
        this._editDir.setText(path);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._editDir.setEnabled(enabled);
        this._btnDir.setEnabled(enabled);
    }

    private void configUi(final String title, String dir, final Supplier<Frame> frame) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 3);
        this._editDir = new JTextField();
        if (dir != null) {
            this._editDir.setText(dir);
        }
        this.add((Component)this._editDir, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this._btnDir = new LabToolbarButton(new AbstractAction(title, EditorUtilities.loadIcon("images/folder.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                File dir = DirectoryEditor.this.getDirectory(title, (Frame)frame.get());
                if (dir != null) {
                    DirectoryEditor.this._editDir.setText(dir.getAbsolutePath());
                }
            }
        });
        this.add((Component)this._btnDir, c);
    }

    File getDirectory(String title, Frame frame) {
        JFileChooser chooser = new JFileChooser();
        String dirText = this._editDir.getText();
        if (dirText != null && dirText.isEmpty()) {
            File dir = new File(dirText);
            if (!dir.isDirectory()) {
                dirText = ".";
            }
        } else {
            dirText = ".";
        }
        chooser.setCurrentDirectory(new File(dirText));
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (0 == chooser.showDialog(frame, "OK")) {
            return chooser.getSelectedFile();
        }
        return null;
    }
}

