/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.LabFrame;
import editor.Scheme;
import editor.plugin.typeloader.ITypeFactory;
import editor.util.PlatformUtil;
import editor.util.SystemColorFilter;
import editor.util.TaskQueue;
import editor.util.TypeNameUtil;
import editor.util.WaitCursorRunner;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuClassTypeInfo;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.ITemplateType;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.PathUtil;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileSystemView;

public class EditorUtilities {
    static final HashMap<String, ImageIcon> ICON_TABLE = new HashMap();
    private static final String BACKGROUND_QUEUE_NAME = "backgroundTasks";
    static Map<Component, Boolean> CONTAINS_FOCUS;
    static Map<Component, Boolean> FOCUS_CONTAINS;
    public static final String CONTROL_KEY_NAME;
    public static final int CONTROL_KEY_MASK;

    public static void doBackgroundOp(final Runnable run) {
        TaskQueue backgroundQueue = EditorUtilities.getBackgroundQueue();
        if (backgroundQueue != null) {
            backgroundQueue.postTask(new Runnable(){

                @Override
                public void run() {
                    run.run();
                }
            });
        } else {
            run.run();
        }
    }

    private static TaskQueue getBackgroundQueue() {
        return TaskQueue.getInstance(BACKGROUND_QUEUE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void settleBackgroundOps() {
        TaskQueue backgroundQueue = EditorUtilities.getBackgroundQueue();
        if (backgroundQueue != null) {
            Object wait;
            Object object = wait = new Object();
            synchronized (object) {
                EditorUtilities.doBackgroundOp(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = wait;
                        synchronized (object) {
                            wait.notifyAll();
                        }
                    }
                });
                try {
                    wait.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static void removePopupBorder(Container c) {
        EventQueue.invokeLater(() -> {
            for (Container p = c; p != null; p = p.getParent()) {
                if (!(p instanceof JComponent)) continue;
                ((JComponent)p).setBorder(null);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void centerWindowInFrame(Component window, Window frame) {
        Point ptOffset;
        Dimension dimCenter;
        block5: {
            if (frame != null) {
                if ((!(frame instanceof Frame) || ((Frame)frame).getState() != 1) && frame.isShowing()) {
                    dimCenter = frame.getSize();
                    ptOffset = frame.getLocation();
                    break block5;
                } else {
                    EditorUtilities.centerWindowInFrame(window, null);
                    return;
                }
            }
            Window owner = SwingUtilities.getWindowAncestor(window);
            if (owner != null && owner.isShowing() && owner.getMinimumSize().height < owner.getHeight()) {
                if ((!(owner instanceof Frame) || ((Frame)owner).getState() != 1) && owner.isShowing()) {
                    Dimension dimCenter2 = owner.getSize();
                    Point ptOffset2 = owner.getLocation();
                    window.setLocation(ptOffset2.x + (dimCenter2.width - window.getWidth()) / 2, ptOffset2.y + (dimCenter2.height - window.getHeight()) / 2);
                }
                return;
            }
            Rectangle screenRect = EditorUtilities.getPrimaryMonitorScreenRect();
            dimCenter = new Dimension((int)screenRect.getWidth(), (int)screenRect.getHeight());
            ptOffset = new Point((int)screenRect.getX(), (int)screenRect.getY());
        }
        window.setLocation(ptOffset.x + (dimCenter.width - window.getWidth()) / 2, ptOffset.y + (dimCenter.height - window.getHeight()) / 2);
    }

    public static Rectangle getPrimaryMonitorScreenRect() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        return gds[0].getConfigurations()[0].getBounds();
    }

    public static ImageIcon loadIcon(String strRes) {
        if (strRes == null || strRes.length() == 0) {
            return null;
        }
        ImageIcon icon = ICON_TABLE.get(strRes);
        if (icon == null && !strRes.contains(" | ")) {
            try {
                URL resource;
                int iDot;
                if (Scheme.active().isDark() && !strRes.contains("_dark.") && (iDot = strRes.lastIndexOf(46)) >= 0) {
                    String strResDark = strRes.substring(0, iDot) + "_dark" + strRes.substring(iDot);
                    icon = EditorUtilities.loadIcon(strResDark);
                }
                if (icon == null && (resource = EditorUtilities.class.getClassLoader().getResource(strRes)) != null) {
                    icon = new ImageIcon(resource);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (icon != null) {
                ICON_TABLE.put(strRes, icon);
            }
        }
        return icon;
    }

    public static Icon findIcon(Path fileOrDir) {
        IType type;
        if (PathUtil.isDirectory((Path)fileOrDir, (LinkOption[])new LinkOption[0])) {
            if (LabFrame.instance().getGosuPanel().getExperimentView().getExperiment().getSourcePath().contains(PathUtil.getAbsolutePathName((Path)fileOrDir))) {
                return EditorUtilities.loadIcon("images/srcfolder.png");
            }
            return EditorUtilities.loadIcon("images/folder.png");
        }
        String classNameForFile = TypeNameUtil.getTypeNameForFile(fileOrDir);
        if (classNameForFile != null && (type = TypeSystem.getByFullNameIfValid((String)classNameForFile)) != null) {
            return EditorUtilities.findIcon(type);
        }
        if (PathUtil.isFile((Path)fileOrDir, (LinkOption[])new LinkOption[0])) {
            try {
                return FileSystemView.getFileSystemView().getSystemIcon(fileOrDir.toFile());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return EditorUtilities.loadIcon("images/FileText.png");
    }

    public static Icon findIcon(IType type) {
        ITypeFactory factory;
        if (type instanceof IGosuClass) {
            if (type.isInterface()) {
                if (((IGosuClass)type).isStructure()) {
                    return EditorUtilities.findIcon(ClassType.Structure);
                }
                if (((IGosuClass)type).isAnnotation()) {
                    return EditorUtilities.findIcon(ClassType.Annotation);
                }
                return EditorUtilities.findIcon(ClassType.Interface);
            }
            if (type instanceof ITemplateType) {
                return EditorUtilities.findIcon(ClassType.Template);
            }
            if (type instanceof IGosuEnhancement) {
                return EditorUtilities.findIcon(ClassType.Enhancement);
            }
            if (type instanceof IGosuProgram) {
                return EditorUtilities.findIcon(ClassType.Program);
            }
            if (type.isEnum()) {
                return EditorUtilities.findIcon(ClassType.Enum);
            }
            return EditorUtilities.findIcon(ClassType.Class);
        }
        if (type instanceof IJavaType) {
            return EditorUtilities.loadIcon("images/javaclass.png");
        }
        if (type != null && (factory = (ITypeFactory)type.getTypeLoader().getInterface(ITypeFactory.class)) != null) {
            return EditorUtilities.loadIcon(factory.getIcon());
        }
        return EditorUtilities.loadIcon("images/empty16x16.gif");
    }

    public static Icon findIcon(ClassType classType) {
        switch (classType) {
            case Class: {
                return EditorUtilities.loadIcon("images/class.png");
            }
            case Enum: {
                return EditorUtilities.loadIcon("images/enum.png");
            }
            case Interface: {
                return EditorUtilities.loadIcon("images/interface.png");
            }
            case Structure: {
                return EditorUtilities.loadIcon("images/structure.png");
            }
            case Annotation: {
                return EditorUtilities.loadIcon("images/annotation.png");
            }
            case Enhancement: {
                return EditorUtilities.loadIcon("images/Enhancement.png");
            }
            case Program: {
                return EditorUtilities.loadIcon("images/program.png");
            }
            case Template: {
                return EditorUtilities.loadIcon("images/template.png");
            }
            case JavaClass: {
                return EditorUtilities.loadIcon("images/javaclass.png");
            }
        }
        return null;
    }

    public static void handleUncaughtException(Throwable e) {
        EditorUtilities.handleUncaughtException("", e);
    }

    public static void handleUncaughtException(String s, Throwable e) {
        System.out.println(s);
        e.printStackTrace();
    }

    public static void settleEventQueue() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (eventQueue.peekEvent() != null) {
            try {
                AWTEvent event = Toolkit.getDefaultToolkit().getSystemEventQueue().getNextEvent();
                Object src = event.getSource();
                if (event instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)event)).dispatch();
                    continue;
                }
                if (src instanceof Component) {
                    ((Component)src).dispatchEvent(event);
                    continue;
                }
                if (!(src instanceof MenuComponent)) continue;
                ((MenuComponent)src).dispatchEvent(event);
            }
            catch (Throwable e) {
                EditorUtilities.handleUncaughtException("", e);
            }
        }
    }

    public static Clipboard getClipboard() {
        return LabFrame.instance().getGosuPanel().getClipboard();
    }

    public static Frame frameForComponent(Component comp) {
        for (Component p = comp; p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static Window windowForComponent(Component comp) {
        for (Component p = comp; p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            return (Window)p;
        }
        return null;
    }

    public static String buildFunctionIntellisenseString(boolean bFeatureLiteralCompletion, IFunctionType functionType) {
        StringBuilder sb = new StringBuilder();
        String rawName = functionType.getDisplayName();
        sb.append(rawName);
        sb.append("()");
        return sb.toString();
    }

    public static Window getWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
    }

    public static Image createSystemColorImage(Image i) {
        SystemColorFilter filter = new SystemColorFilter();
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public static void displayInformation(String strMsg) {
        EditorUtilities.displayMessageBox(strMsg, 1, false);
    }

    public static void displayError(Throwable e) {
        EditorUtilities.displayMessageBox(e == null ? "Error performing operation." : e.getMessage(), 0, false);
    }

    public static void displayError(String strMsg) {
        EditorUtilities.displayMessageBox(strMsg, 0, false);
    }

    public static void displayWarning(String strMsg) {
        EditorUtilities.displayMessageBox(strMsg, 2, false);
    }

    public static void displayMessageBox(String strMsg, final int iType, boolean bWrapText) {
        final String strWrappedMsg = bWrapText ? EditorUtilities.wrapText(strMsg) : strMsg;
        Runnable logMsgBox = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(EditorUtilities.getWindow(), strWrappedMsg, "", iType);
            }
        };
        if (EventQueue.isDispatchThread()) {
            logMsgBox.run();
        } else {
            try {
                EventQueue.invokeAndWait(logMsgBox);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static String wrapText(String strText) {
        return EditorUtilities.wrapText(strText, 60);
    }

    public static String wrapText(String strText, int iLineLen) {
        StringBuilder sb = new StringBuilder();
        while (strText != null) {
            if (strText.length() > iLineLen) {
                sb.append(strText.substring(0, 60)).append("\n");
                strText = strText.substring(60);
                continue;
            }
            sb.append(strText);
            strText = null;
        }
        return sb.toString();
    }

    public static void convertRectangleToScreen(Rectangle rectangle, Component component) {
        Point loc = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(loc, component);
        rectangle.setLocation(loc);
    }

    public static List<String> filterStrings(Collection<? extends CharSequence> collection, String filter) {
        int iDotIndex;
        if (filter != null && (iDotIndex = filter.lastIndexOf(46)) >= 0) {
            filter = filter.substring(iDotIndex + 1);
        }
        ArrayList<String> filteredTypes = new ArrayList<String>();
        if (filter != null && filter.length() > 0) {
            int iFlags = 0;
            if (filter.indexOf(42) < 0 && Character.isUpperCase(filter.charAt(0))) {
                filter = EditorUtilities.camelCasePrefix(filter);
            } else {
                iFlags = 2;
            }
            filter = filter.replaceAll("\\*", "\\.\\*");
            filter = filter.replaceAll("\\#", "\\*");
            boolean bHasDot = filter.indexOf(126) >= 0;
            filter = filter.replaceAll("~", "(\\\\.|\u2024)");
            try {
                Pattern pattern = Pattern.compile(filter + (filter.startsWith(".*") ? "" : ".*"), iFlags);
                for (CharSequence charSequence : collection) {
                    String strType = charSequence.toString();
                    String strName = bHasDot ? strType : EditorUtilities.getRelativeTypeName(strType);
                    if (!pattern.matcher(strName).find()) continue;
                    filteredTypes.add(strType);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return filteredTypes;
    }

    private static String camelCasePrefix(String strPrefix) {
        StringBuilder sb = new StringBuilder();
        for (int i = strPrefix.length() - 1; i >= 0; --i) {
            char c = strPrefix.charAt(i);
            sb.insert(0, c);
            if (i == 0 || !Character.isUpperCase(c)) continue;
            sb.insert(0, "[^A-Z]#");
        }
        return sb.toString();
    }

    private static String getRelativeTypeName(String strType) {
        int iIndex = strType.lastIndexOf(46);
        if (iIndex > 0) {
            return strType.substring(iIndex + 1);
        }
        return strType;
    }

    public static void hideToolTip(JComponent c) {
        try {
            Method hideMethod = ToolTipManager.class.getDeclaredMethod("hide", JComponent.class);
            hideMethod.setAccessible(true);
            hideMethod.invoke((Object)ToolTipManager.sharedInstance(), c);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JRootPane rootPaneForComponent(Component comp) {
        for (Component p = comp; p != null; p = p.getParent()) {
            if (p instanceof JRootPane) {
                return (JRootPane)p;
            }
            if (comp instanceof JFrame) {
                return ((JFrame)comp).getRootPane();
            }
            if (comp instanceof JDialog) {
                return ((JDialog)comp).getRootPane();
            }
            if (!(comp instanceof JWindow)) continue;
            return ((JWindow)comp).getRootPane();
        }
        return null;
    }

    public static void invokeInDispatchThread(Runnable task) {
        if (task == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            try {
                EventQueue.invokeAndWait(task);
            }
            catch (Throwable t) {
                EditorUtilities.handleUncaughtException(t);
            }
        }
    }

    public static void invokeNowOrLater(Runnable task) {
        if (task == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            try {
                EventQueue.invokeLater(task);
            }
            catch (Throwable t) {
                EditorUtilities.handleUncaughtException(t);
            }
        }
    }

    public static Process browse(String strURL) throws IOException {
        String strCmd = PlatformUtil.isWindows() ? "rundll32 url.dll,FileProtocolHandler " + strURL : "firefox " + strURL;
        return Runtime.getRuntime().exec(strCmd);
    }

    public static <T> T findAncestor(Component start, Class<T> aClass) {
        if (start == null) {
            return null;
        }
        return EditorUtilities.findAtOrAbove(start.getParent(), aClass);
    }

    public static <T> T findAtOrAbove(Component start, Class<T> aClass) {
        for (Component comp = start; comp != null; comp = comp.getParent()) {
            if (!aClass.isInstance(comp)) continue;
            return (T)comp;
        }
        return null;
    }

    public static <T> List<T> findDecendents(Component configUI, Class<T> aClass) {
        return EditorUtilities.findDecendents(configUI, aClass, c -> true);
    }

    private static <T> void _findDecendents(ArrayList<T> comps, Component component, Class<T> aClass, Predicate<Container> recurseToChildren) {
        if (aClass.isInstance(component)) {
            comps.add(component);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] components = container.getComponents();
            if (recurseToChildren.test(container)) {
                JPopupMenu popupMenu;
                for (Component child : components) {
                    EditorUtilities._findDecendents(comps, child, aClass, recurseToChildren);
                }
                if (container instanceof JMenu && (popupMenu = ((JMenu)container).getPopupMenu()) != null) {
                    EditorUtilities._findDecendents(comps, popupMenu, aClass, recurseToChildren);
                }
            }
        }
    }

    public static <T> List<T> findDecendents(Component configUI, Class<T> aClass, Predicate<Container> recurseToChildren) {
        ArrayList comps = new ArrayList();
        EditorUtilities._findDecendents(comps, configUI, aClass, recurseToChildren);
        return comps;
    }

    public static boolean isRunnable(IType type) {
        if (type == null || !type.isValid()) {
            return false;
        }
        if (LabFrame.instance().getGosuPanel().isRunning() || LabFrame.instance().getGosuPanel().isDebugging()) {
            return false;
        }
        if (type instanceof IGosuProgram) {
            return true;
        }
        if (type instanceof IGosuClass && !type.isAbstract() && ((IGosuClassTypeInfo)type.getTypeInfo()).isPublic()) {
            IMethodInfo main = type.getTypeInfo().getMethod((CharSequence)"main", new IType[]{JavaTypes.STRING().getArrayType()});
            if (main != null && main.isStatic() && main.getReturnType() == JavaTypes.pVOID()) {
                return true;
            }
            if (type.getTypeInfo().getConstructor(new IType[0]) != null) {
                IType baseTest = TypeSystem.getByFullNameIfValid((String)"junit.framework.Assert");
                if (baseTest != null) {
                    return baseTest.isAssignableFrom(type);
                }
                return type.getName().endsWith("Test");
            }
        }
        return false;
    }

    public static void fixSwingFocusBugWhenPopupCloses(Component c) {
        EditorUtilities.rootPaneForComponent(c).dispatchEvent(new MouseEvent(c, 501, System.currentTimeMillis(), 0, 3, 3, 1, false));
    }

    public static Component showWaitCursor(boolean bWait) {
        return WaitCursorRunner.showWaitCursor(bWait);
    }

    public static void showWaitCursor(boolean bWait, Component c) {
        WaitCursorRunner.showWaitCursor(bWait, c);
    }

    public static void doWaitOperation(Runnable op) {
        Component key = EditorUtilities.showWaitCursor(true);
        try {
            op.run();
        }
        finally {
            EditorUtilities.showWaitCursor(false, key);
        }
    }

    public static Component getFocus() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
    }

    public static Window getFocusedWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
    }

    public static Window getActiveWindow() {
        Frame[] frames;
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeWindow == null && (frames = Frame.getFrames()) != null && frames.length > 0) {
            return frames[0];
        }
        return activeWindow;
    }

    public static boolean containsFocus(Component c) {
        Component focusOwner;
        EditorUtilities.addFocusListener();
        Boolean containsFocus = CONTAINS_FOCUS.get(c);
        if (containsFocus != null) {
            return containsFocus;
        }
        Component temp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        while (temp != null) {
            if (temp == c) {
                CONTAINS_FOCUS.put(c, true);
                return true;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        CONTAINS_FOCUS.put(c, false);
        return false;
    }

    public static boolean focusContains(Component c) {
        EditorUtilities.addFocusListener();
        Boolean focusContains = FOCUS_CONTAINS.get(c);
        if (focusContains != null) {
            return focusContains;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        Component temp = c;
        while (temp != null) {
            if (temp == focusOwner) {
                FOCUS_CONTAINS.put(c, true);
                return true;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        FOCUS_CONTAINS.put(c, false);
        return false;
    }

    private static void addFocusListener() {
        if (CONTAINS_FOCUS != null) {
            return;
        }
        CONTAINS_FOCUS = new HashMap<Component, Boolean>();
        FOCUS_CONTAINS = new HashMap<Component, Boolean>();
        KeyboardFocusManager focusMgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusMgr.addPropertyChangeListener("permanentFocusOwner", evt -> {
            CONTAINS_FOCUS.clear();
            FOCUS_CONTAINS.clear();
        });
    }

    public static boolean isInFocusLineage(Component c) {
        return EditorUtilities.containsFocus(c) || EditorUtilities.focusContains(c);
    }

    public static Point getXYForDialogRelativeToStudioFrame(int width, int height) {
        Rectangle screenRect = EditorUtilities.getPrimaryMonitorScreenRect();
        return new Point((int)(screenRect.getX() + (screenRect.getWidth() - (double)width) / 2.0), (int)(screenRect.getY() + (screenRect.getHeight() - (double)height) / 2.0));
    }

    public static String hex(Color color) {
        return Integer.toHexString(color.getRGB() & 0xFFFFFF | 0x1000000).substring(1);
    }

    public static String getFontFamilyOrDefault(String name, String defaultFont) {
        if (Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()).anyMatch(e -> e.equalsIgnoreCase(name))) {
            return name;
        }
        return defaultFont;
    }

    static {
        if (PlatformUtil.isMac()) {
            CONTROL_KEY_MASK = 4;
            CONTROL_KEY_NAME = "meta";
        } else {
            CONTROL_KEY_MASK = 2;
            CONTROL_KEY_NAME = "control";
        }
    }
}

