/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.Scheme;
import editor.util.ContainerMoverSizer;
import editor.util.EditorUtilities;
import editor.util.ProgressPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JWindow;

public class ProgressWindow
extends JWindow {
    private Window _window;

    public ProgressWindow(ProgressPanel panel) {
        super(ProgressWindow.getFrameWindow());
        this.configUI(panel);
    }

    private static Frame getFrameWindow() {
        Window activeWindow = EditorUtilities.getActiveWindow();
        if (activeWindow == null) {
            return ProgressWindow.getActiveFrameFromApp();
        }
        if (activeWindow instanceof Frame) {
            return (Frame)activeWindow;
        }
        return (Frame)activeWindow.getOwner();
    }

    private static Frame getActiveFrameFromApp() {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            Frame frame = frames[i];
            if (!frame.isShowing()) continue;
            return frame;
        }
        return null;
    }

    private void configUI(ProgressPanel panel) {
        ContainerMoverSizer contentPane = new ContainerMoverSizer(null);
        contentPane.setLayout(new BorderLayout());
        contentPane.setBackground(Scheme.active().getWindow());
        this.setContentPane(contentPane);
        this.add((Component)panel, "Center");
    }

    @Override
    public void show() {
        this.pack();
        EditorUtilities.centerWindowInFrame(this, this.getOwner());
        super.show();
        this._window = EditorUtilities.getActiveWindow();
        if (this._window != null) {
            this._window.setEnabled(false);
        }
    }

    @Override
    public void dispose() {
        if (this._window != null) {
            this._window.setEnabled(true);
        }
        this.setVisible(false);
        super.dispose();
    }
}

